;;; color-mate-util.el -- Color-Mate utility routines.  -*-emacs-lisp-*-

;; Copyright (C) YOKOTA Hiroshi

;; Author: Hiroshi Yokota <yokota@netlab.is.tsukuba.ac.jp>
;; Maintainer: Hiroshi Yokota <yokota@netlab.is.tsukuba.ac.jp>
;; Version: 10.4
;; Keywords: color-mate
;; Content-Type: text/plain; charset=x-euc-jp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;   Color-Mate  Ver.10.4
;;         by  ͵ (yokota@netlab.is.tsukuba.ac.jp)
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; $Id: color-mate-util.el,v 10.5 2001/03/16 05:09:02 elca Exp $

(require 'assoc)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; ʪؿ
(defun color-mate:emacs-version ()
  "return emacs major version"
  (progn
   (string-to-int emacs-version)))

; xemacs Ѥ emacs ߴؿ
(if (not (fboundp 'set-cursor-color))
;; from skk-foreword.el
(defun set-cursor-color (color-name)
  "Compatibility routine for xemacs."
  (set-frame-property (selected-frame) 'cursor-color
                      (if (color-instance-p color-name)
                          color-name
                        (make-color-instance color-name))))
)
(if (not (fboundp 'custom-face-attributes-get))
(defun custom-face-attributes-get (a b)
  "It's dummy function for xemacs"
  nil)
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; emacs/xemacs κۼĤĥƥफ鸽ߤοФؿ
;;
(defun color-mate:face-background (emacs-face xemacs-face)
  "Get background face color."
  (progn
    (if (featurep 'xemacs)
	(face-background-name xemacs-face)
      (face-background emacs-face))))
(defun color-mate:face-foreground (emacs-face xemacs-face)
  "Get foreground face color."
  (progn
    (if (featurep 'xemacs)
	(face-foreground-name xemacs-face)
      (face-foreground emacs-face))))
(defun color-mate:frame-param-or-face-background (emacs-param xemacs-face)
  "Get background face color from an alist(emacs) or a function(xemacs)"
  (progn
    (if (featurep 'xemacs)
	(face-background-name xemacs-face)
      (aget (frame-parameters (selected-frame)) emacs-param))))
(defun color-mate:frame-param-or-face-foreground (emacs-param xemacs-face)
  "Get foreground face color from an alist(emacs) or a function(xemacs)"
  (progn
    (if (featurep 'xemacs)
	(face-foreground-name xemacs-face)
      (aget (frame-parameters (selected-frame)) emacs-param))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; ǻѤؿ
;--------------------------------------------------------------------
; emacs
;
; from-alist  from-key бͤ ʸʤ to-alist 
; to-key Ͽ
(defun color-mate:_set-alist-if-string (from-alist to-alist from-key to-key)
  "This is Color-Mate's internal function. Don't use this!"
  (progn
    (let ((val (aget from-alist from-key)))
      (if (stringp val)
	  (aput to-alist to-key val)
	))))


; from-alist  from-key бͤ ʤ to-alist 
; to-key Ͽ
(defun color-mate:_set-alist-if-integer (from-alist to-alist from-key to-key)
  "This is Color-Mate's internal function. Don't use this!"
  (progn
    (let ((val (aget from-alist from-key)))
      (if (integerp val)
	  (aput to-alist to-key val)
	))))

;-----------------------------------------------------------------
; xemacs
;
; from-alist  from-key бͤ ʸʤ to-plist 
; to-key Ͽ
(defun color-mate:_set-plist-if-string (from-alist to-plist from-key to-key)
  "This is Color-Mate's internal function. Don't use this!"
  (progn
    (let ((val (aget from-alist from-key)))
      (if (stringp val)
	  (eval
	   (list
	    'setq to-plist (list 'quote (append (symbol-value to-plist)
				  (list to-key val)))))
	))))

; from-alist  from-key бͤ ʤ to-plist 
; to-key Ͽ
(defun color-mate:_set-plist-if-integer (from-alist to-plist from-key to-key)
  "This is Color-Mate's internal function. Don't use this!"
  (progn
    (let ((val (aget from-alist from-key)))
      (if (integerp val)
	  (eval
	   (list
	    'setq to-plist (list 'quote (append (symbol-value to-plist)
						(list to-key val)))))
	))))

;---------------------------------------------------------------

(defun color-mate:_set-underline (alist key face-name)
  "This is Color-Mate's internal function. Don't use it."
  (progn
    (let ((u (aget alist key))
	  l)
      (if u
	  (if (and (featurep 'custom)
		   (featurep 'cus-face))
	      (progn
		(setq l (custom-face-attributes-get face-name nil))
		(append l (list ':underline t))
		(custom-set-faces
		 (list face-name (list (list t l)))))
	    (set-face-underline-p face-name t))))))

(defun color-mate:_set-face-if-string (alist bg-key fg-key face-name)
  "This is Color-Mate's internal function. Don't use it."
  (progn
    (let ((bg-val (aget alist bg-key))
	  (fg-val (aget alist fg-key))
	  l)
      (if (and (featurep 'custom)
	       (featurep 'cus-face))
	  ;; new method with custom.el
	  (progn
	    (setq l (custom-face-attributes-get face-name nil))
	    (if (stringp bg-val)
		(setq l (append l (list ':background bg-val))))
	    (if (stringp fg-val)
		(setq l (append l (list ':foreground fg-val))))
	    (custom-set-faces
	     (list face-name (list (list t l)))))
	;; old method
	(progn
	  (if (stringp bg-val)
	      (set-face-background face-name bg-val))
	  (if (stringp fg-val)
	      (set-face-foreground face-name fg-val)))
	))))

(provide 'color-mate-util)

;;; color-mate-util.el ends here.
