<?php
/* daCode http://www.dacode.org/
 * src/phplib/board.php3
 * $Id: board.php3,v 1.52 2001/07/22 21:51:46 penso Exp $
 * Fabien Penso <penso@linuxfr.org>
 *
 * This will be the board Class. This is to make a board like bbs ones
 *
 * Depends: Config Db Utils Html
*/


class Board {
	var $utils,$db,$html,$HTTP_REFERER;

	Function Board() {
//echo '<br>Board';
		global $HTTP_REFERER;

		$this->db = LoadClass('Db');
		$this->session = LoadClass('Session');
		$this->cache = LoadClass('Cache');
		$this->utils = LoadClass('Utils');
		$this->html  = LoadClass('Html');

		$this->HTTP_REFERER = $HTTP_REFERER;
	}

	/*
	 * This function add a new message to the board
	 */
	Function add($message,$section=1) {
		global $HTTP_USER_AGENT;
		global $config;

		if (!ereg("^".$config->basehref,$this->HTTP_REFERER) &&
				($this->session->param & pow(2,3) == 0)) {
			echo lecho("Might got fucked! :-)<BR>\nLook at <a href=\"http://lwn.net/2000/features/Redirect.phtml\">http://lwn.net/2000/features/Redirect.phtml</a> to see what happened!<BR>\nThen come back here. :-)");
			exit;
		}

		// Thanks alain@antinea.com
		$maxsize = 30;
		$ar_message = explode (" ", $message);
		while (list($key, $val) = each($ar_message)) {
			if (strlen($val) > $maxsize && !ereg("^(ht|f)tp://", $val)) {
				echo lecho("Sorry but your message contains too long words");
				exit;
			}
		}

		if (empty($message)) {
			if (!empty($this->HTTP_REFERER))
				header ("Location: ".$this->HTTP_REFERER);
			else
				header ("Location: ".$config->basehref.$config->newsfile);
		}

		if (strlen($message) > 4 && strlen($message) <= 255) {
			$sqlc_q = "SELECT ip from ".$config->tables['board']." WHERE section='".
					addslashes($section)."' ORDER BY timestamp DESC LIMIT 1";
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				echo lecho("SQL Failed: "). $this->db->error();
				echo lecho("SQL command was: ").$sqlc_q."<br>\n";
				exit;
			}
			$row = $this->db->fetch_array();
			// Section number 2 is used for admin. So they can post twice.
			if ($row[0] == $this->utils->ip() && $section != 2) {
				echo lecho("Sorry but you can't add two messages in a row");
				exit;
			}
			$this->db->free();
			$message = $this->utils->htmlspecial_board($message);
			$sqlc_q = "INSERT INTO ".$config->tables['board'].
				" (message,ip,info,section) VALUES ('".
				addslashes($message)."','".
				addslashes($this->utils->ip())."','".
				addslashes($HTTP_USER_AGENT)."','".
				addslashes($section)."')";

			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				echo lecho("SQL Failed: "). $this->db->error();
				echo lecho("SQL command was: ").$sqlc_q."<br>\n";
				exit;
			}

			if (!empty($config->htmldir)) {
				//   PHP3 files call $board->print_messages()
				//   so only .html files have to be removed.
				$this->cache->delete_htmlfiles('section',0,0,0,'\.html');
				$this->cache->delete_htmlfiles('topic',0,0,0,'\.html');
				$this->cache->delete_htmlfiles('.',1,0,0,'^index.*\.html','^[0-9]+$');
			}
			if (!empty($config->cachedir)) {
				$this->cache->delete_boxfiles('board',0,0,0,"^#".$section.'\.');
			}
		}

		header("Cache-Control: no-cache, must-revalidate");
		header("Pragma: no-cache");
		if (!empty($this->HTTP_REFERER))
			header ("Location: ".$this->HTTP_REFERER);
		else
			header ("Location: ".$config->basehref.$config->newsfile);
	}

	/*
	 * This will print information about a message
	 */
	Function print_info($id) {
		global $config;

		if (!ereg("^[0-9]+$",$id)) {
			return "Id looks wrong. Have id cookie ?";
		}
		$sqlc_q = "SELECT timestamp,info from ".$config->tables['board'].
			" WHERE id='".addslashes($id)."'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo lecho("SQL Failed: ").$this->db->error();
			exit;
		}

		$tmp = "";
		while($row = $this->db->fetch_array()) {
			$row[1] = htmlentities($row[1]);
			$tmp .= $this->utils->stamp2date($row[0],"long");
			$tmp .= "<br>$row[1]";
		}
		$this->db->free();
		return $tmp;
	}

	/* Print a number of messages */
	Function print_message($nb=10,$section=1,$inputsize=25) {
		global $config;

		if (!is_integer($nb) or $nb<1 or $nb>5000) {
			$nb = 10; // sqlchecked: it must be in [1..5000];
		}

		$cachetmp = array ($section,$nb,$config->ext);

		$fcontents = $this->cache->check_box("3600",'board',$cachetmp);
		if (!empty($fcontents)) {
			return $fcontents;
		}

		$sqlc_q = "SELECT message,timestamp,id from ".$config->tables['board'].
			" WHERE section='".addslashes($section)."' ORDER BY timestamp ".
			"DESC LIMIT $nb";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo lecho("SQL Failed: "). $this->db->error();
			echo lecho("SQL command was: ").$sqlc_q."<br>\n";
			return -1;
		}

		if ($this->db->num_rows() < $nb) {
			$nb = $this->db->num_rows();
		}
		$i=$nb;

		while ($row = $this->db->fetch_array()) {
			$message[$i] = $row["message"];
			$timestamp[$i] = $row["timestamp"];
			$id[$i] = $row["id"];
			$i--;
		}
		$this->db->free();

		$oldt = "";
		$tmp = "";
		for ($i=1;$i<=$nb;$i++) {
			$t = substr($timestamp[$i],8,2).substr($timestamp[$i],10,2);
			if (isset($timestamp[($i+1)])) {
				$t2 = substr($timestamp[($i+1)],8,2).substr($timestamp[($i+1)],10,2);
			} else {
				$t2 = $t;
			}

			$tmp .= "&nbsp;<A HREF=\"".$config->basehref.
					$config->boardinfofile."?id=$id[$i]\">";

			if ($t == $t2 || $oldt == $t) {
				$tmp .= $this->utils->stamp2time($timestamp[$i],"long");
			} else {
				$tmp .= $this->utils->stamp2time($timestamp[$i],"short");
			}
			$oldt = $t;

			$tmp .= "</A> $message[$i]<BR>\n";
		}

		/* We make a link so users can add entries */
		$tmp .= "<CENTER><FORM ACTION=\"".$config->basehref.$config->boardaddfile."\" METHOD=\"POST\">\n";
		$tmp .= "<INPUT NAME=\"message\" TYPE=\"TEXT\" SIZE=\"".$inputsize."\" MAXLENGTH=\"255\" VALUE=\"\">\n";
		$tmp .= "<INPUT NAME=\"board_section\" TYPE=\"hidden\" VALUE=\"".htmlentities($section).
				"\">\n";
		$tmp .= "</FORM></CENTER>\n";


		$out = $this->html->sidebox("<A HREF=\"".$config->basehref.
			$config->boardindexfile.
			"\">".lecho("Board")."</a>", $tmp, 'board');

		$this->cache->write_box('board',$cachetmp,$out);
		return $out;
	}

}

?>
