<?php
/* daCode http://www.dacode.org/
 * src/phplib/search.php3
 * $Id: search.php3,v 1.57 2001/07/22 22:07:15 penso Exp $
 * Paul Gonin
 *
 * Depends: Config Db Utils
*/

Class Search{
	var $db,$session,$utils,$keywords,$topic,$section,$comments,$author,$from,$to;

	Function Search() {
		$this->db = LoadClass('Db');
		$this->session = LoadClass('Session');
		$this->utils = LoadClass('Utils');
		$this->html = LoadClass('Html');
	}

	Function display_results($pos,$step) {
		global $config;

		$content = "<center><h2>".lecho("Search results:").
			"</h2></center><br>";

		if ( $this->db->num_rows() > 0 ) {

			$last = min($this->db->num_rows(), $step);
			for ($i=0; $i<$last; $i++) {
				$row = $this->db->fetch_array();
				ereg("^([0-9]{4})([0-9]{2})([0-9]{2})([0-9]{2})([0-9]{2})([0-9]{2})$",
					$row['timestamp'], $regs);
				$year = $regs[1];
				$month = $regs[2];
				$day = $regs[3];

				$id = $row['id'];
				$section = ($row['main_page'] ? "" : $row['section']);

				$content .= "<dl><dt><b><a href=\"".
					$this->session->newsurls($id,$section,"",$year,$month,$day)."\">".
					$row['title']."</a> (".lecho("Author").": ".$row['name'].
					") @ ".
					$this->utils->stamp2date($row['timestamp'],"long").
					"<dd>".nl2br($row['body'])."</dd></dl>\n";


			}//for


			$content .="<table width=\"100%\"><tr> <td align=\"center\"".
				" width=\"50%\"> ";
			if($pos > 0) {
				$content .= "<a href=".$config->basehref.
				"search.".$config->php."?keywords=".$this->keywords.
				"&amp;topic=".$this->topic.
				"&amp;section=".$this->section.
				"&amp;comments=".$this->comments.
				"&amp;author=".$this->author.
				"&amp;pos=".($pos-$step)."&amp;step=".$step.">".
				"<< ".lecho("Previous results")."</A>";
			} //if
			$content .= "</td>";
			$content .= "<td align=\"center\">";
			if($this->db->num_rows() > $step) {
				$content .= "<a href=".$config->basehref.
					"search.".$config->php."?keywords=".$this->keywords.
					"&amp;topic=".$this->topic.
					"&amp;section=".$this->section.
					"&amp;comments=".$this->comments.
					"&amp;author=".$this->author.
					"&amp;pos=".($pos+$step)."&amp;step=".$step.">".
					lecho("Next results").">> </a>";
			}//if
			$content .= "</td><tr>";
			$content .= "</table>";
		} else {
			$content .= lecho("Sorry, no results.");
		}

		return $this->html->simplebox($content);
	}

	Function go_search() {
		global $HTTP_GET_VARS;
		global $config;

		$keywords= (isset($HTTP_GET_VARS['keywords'])?$HTTP_GET_VARS['keywords']:"");
		$topic	 = (isset($HTTP_GET_VARS['topic'])?$HTTP_GET_VARS['topic']:"");
		$section = (isset($HTTP_GET_VARS['section'])?$HTTP_GET_VARS['section']:"");
		$comments= (isset($HTTP_GET_VARS['comments'])?$HTTP_GET_VARS['comments']:"");
		$author	 = (isset($HTTP_GET_VARS['author'])?$HTTP_GET_VARS['author']:"");
		$pos	 = (isset($HTTP_GET_VARS['pos'])?$HTTP_GET_VARS['pos']:"");
		$step	 = (isset($HTTP_GET_VARS['step'])?$HTTP_GET_VARS['step']:"");
		$from	 = (isset($HTTP_GET_VARS['from'])?$HTTP_GET_VARS['from']:"");
		$to		 = (isset($HTTP_GET_VARS['to'])?$HTTP_GET_VARS['to']:"");

		$interval = $config->default_search_interval;

		if (ereg('^[0-9]{8}$',$from)) {
			$from .= "000000";
		} elseif (!$from) {
			$from = date("YmdHis",mktime(0,0,0,date("m")-$interval,date("d"),date("Y")));
		}

		if (ereg('^[0-9]{8}$',$to)) {
			$to .= "000000";
		} elseif (!$to) {
			$to = date("YmdHis",mktime(date("H"),date("i"),date("s"),date("m"),date("d"),date("Y")));
		}

		$tbl_news = $config->tables['news'];           //sqlchecked: def of tables;
		$tbl_body = $config->tables['news_body'];      //sqlchecked: def of tables;
		$tbl_section = $config->tables['sections'];    //sqlchecked: def of tables;
		$tbl_author = $config->tables['news_author'];  //sqlchecked: def of tables;
		$tbl_comments = $config->tables['comments'];   //sqlchecked: def of tables;

		$this->keywords = $keywords;
		$this->topic = $topic;
		$this->section = $section;
		$this->comments = $comments;
		$this->author = $author;
		$this->from = $from;
		$this->to = $to;

		// Construction of request
		$sqlc_q = "SELECT DISTINCT n.id,n.title,n.timestamp,n.main_page,s.section,a.name,b.body ".
			"FROM ".$tbl_news." n,".$tbl_body." b,";
		if ($comments == "on") {
			$sqlc_q .=  $tbl_comments." c,";
		}
		$sqlc_q .= $tbl_author." a,".$tbl_section." s WHERE n.state='1'";

		$datefrom = ereg_replace('([0-9]{4})([0-9]{2})([0-9]{2})([0-9]{2})([0-9]{2})([0-9]{2})', 
								 '\1-\2-\3 \4:\5:\6', $from);
		$dateto   = ereg_replace('([0-9]{4})([0-9]{2})([0-9]{2})([0-9]{2})([0-9]{2})([0-9]{2})', 
								 '\1-\2-\3 \4:\5:\6', $to);
		$sqlc_q .= " AND n.timestamp >= '".addslashes($datefrom).
			"' AND n.timestamp <= '".addslashes($dateto)."'";

		if (!empty($keywords)) {
			$sqlkw = ereg_replace('%','\\%',$keywords);
			$sqlc_q .= " AND (n.title LIKE '%".addslashes($sqlkw)."%'".
				" OR b.body LIKE '%".addslashes($sqlkw)."%'";
			if ($comments == "on") {
				$sqlc_q .=  " OR c.subject LIKE '%".addslashes($sqlkw)."%'".
					" OR c.body LIKE '%".addslashes($sqlkw)."%'";
			}
			$sqlc_q .= ")";
		}
		$sqlc_q .= " AND n.id=b.id AND n.author_id=a.id";
		if ($comments == "on")  $sqlc_q .= " AND n.id=c.news_id ";
		$sqlc_q .= " AND n.section_id=s.id";
		if ($topic > -1)
			$sqlc_q .= " AND n.topic_id='".addslashes($topic)."'";
		if ($section > -1)
			$sqlc_q .= " AND n.section_id='".addslashes($section)."'";
		if (!empty($author))
			$sqlc_q .= " AND a.name LIKE '%".addslashes($author)."%'";
		$sqlc_q .= " ORDER BY timestamp DESC ".
			$this->db->compat_limit($pos+$step+1,$pos);
		if ( !empty($keywords) || !empty($author) || ($topic > -1 ) || ($section > -1) ) {
			// Submission of request
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				return "<!-- Search: SQL Request Failed:\n$sqlc_q\n -->\n";
			}
			//$content .= $this->db->num_rows() . " results for request ".$sqlc_q ." :";

			// Display results of request
			$content .= $this->display_results($pos,$step);
		}
		return $content;
	}//go_search

	Function adv_search_form() {
		global $config,$utils,$HTTP_GET_VARS;

		$content = "<!-- ADVANCED SEARCH FORM -->\n";

		$content .= "<form method=\"get\" action=\"".$config->basehref."search.".$config->php."\">\n".
			"<table class='searchform' border='1' cellspacing='1' cellpadding='1' ".
			"width=\"75%\">\n<tr>\n".
			"<td class='searchformheader' colspan=\"2\">".lecho("Advanced Search")."</td></tr>\n".
			"<tr class='searchform' ><td colspan=\"2\">\n".
			"<table align=\"center\" border=\"0\" cellspacing=\"1\" cellpadding=\"1\">\n".
			"<tr><td class='searchform' colspan=\"2\">\n".
			"<input type=\"text\" name=\"keywords\" value=\"".$HTTP_GET_VARS['keywords'].
			"\" size=\"50\" maxlength=\"100\">\n".
			"</td></tr>\n".
			"<tr><td class='searchform' >\n".
			$this->utils->make_topics_button().
			"</td><td class='searchform' >Topic</td></tr>\n".
			"<tr><td class='searchform' >\n".
			$this->utils->make_sections_button().
			"</td>\n".
			"<td class='searchform' >Section</td></tr>\n".
			"<tr><td class='searchform' ><input type=\"checkbox\" name=\"comments\"></td>\n".
			"<td class='searchform' >".lecho("Include comments")."</td>\n".
			"</tr></table></td></tr>\n".
			"<tr class='searchform'><td colspan=\"2\"><table border=\"0\" align=\"center\"".
			" cellspacing=\"1\" cellpadding=\"1\">\n".
			"<tr><td class='searchform' > ".lecho("Author")." : </td>\n".
			"<td class='searchform' > <input type=\"text\" name=\"author\"".
			" size=\"40\" maxlength=\"100\"> </td></tr>\n".
			"</table></td>\n".
			"</tr>\n".
			"<tr class='searchform'><td colspan=\"2\"><table border=\"0\" ".
			"align=\"center\" cellspacing=\"1\" cellpadding=\"1\">\n".
			"<tr><td class='searchform'>".lecho("From")." : <input type=\"text\"".
			" name=\"from\" size=\"8\"></td>\n".
			"<td class='searchform'>".lecho("To")." : <input type=\"text\" name=\"to\"".
			" size=\"8\"></td>\n".
			"</tr><tr><td class='searchform' colspan=\"2\"> ".lecho("Dates of form").
			" YYYYMMDD </td>\n".
			"</tr></td></table></tr>\n".
			"<tr class='searchform'><td class='searchform' align=\"center\">".
			lecho("Results per page")." : "."<input type=\"text\" name=\"step\"".
			" value=\"25\" size=\"2\"></td>\n <td class='searchform' align=\"center\">".
			"<input type=\"submit\" name=\"submit\" value=\"".lecho("Submit")."\">\n".
			"<input type=\"hidden\" name=\"pos\" value=\"0\">\n".
			"</td></tr></form></table>\n";

		return $content;
	}

}//class Search

?>
