<?php
/* daCode http://www.dacode.org/
 * src/phplib/sidebox.php3
 * $Id: sidebox.php3,v 1.70 2001/07/11 09:22:27 penso Exp $
 * Fabien Penso <penso@linuxfr.org>
 *
 * This Class will host all the sidebox
 * If you wanna commit a new sidebox, do it here
 *
 * Depends: Config Db Html Cache Redirect
*/

Class Sidebox {
	var $db,$html,$redirect,$cache,$news;

	Function Sidebox() {
		global $config;
		$this->db = LoadClass('Db');
		$this->user = LoadClass('User');
		$this->session= LoadClass('Session');
		$this->html  = LoadClass('Html');
		$this->cache = LoadClass('Cache');
		$this->redirect = LoadClass('Redirect');
		$this->news = LoadClass('News');
	}

	/*
	 * Returns a box with all the section inside
	 * This is usually used as first box
	 */
	Function dacode() {
		global $section;
		global $config;

		$cachetmp = array ($section,$config->ext,$config->score,$config->hide_sig);

		$fcontents = $this->cache->check_box("180","sidebox_dacode",$cachetmp);
		if (!empty($fcontents)) {
			return $fcontents;
		}

		$out = "";
		$sqlc_q = "SELECT section FROM ". $config->tables['sections'].
			" WHERE state='1' ORDER BY section";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo "<!-- SQL Failed: ".$this->db->error()." -->\n";
			return;
		}

		$i=0;
		while($row=$this->db->fetch_array()) {
			$table[$i] = $row;
			$i++;
		}
		$this->db->free();

		$i=0;
		$tempo = array();
		while ($cur = current($table)) {
			$tempo[$i] = $cur;
			$i++;
			next($table);
		}

		$tempo_nb = $this->news->count_section($tempo);
		reset($table);

		while ($cur = current($table)) {
			$out .= "&nbsp;-&nbsp;";
			if ($section == $cur['section']) {
				$out .= "<B>";
			}

			if (gettype($tempo_nb) == "array") {
				reset($tempo_nb);
				while($cur2 = current($tempo_nb)) {
					$ok=0;
					if ($cur2['section'] == $cur['section']) {
						$out .= "[".$cur2[0]."] ";
						$ok=1;
						break;
					}
					next($tempo_nb);
				}
			} else {
				$ok = 0;
			}
			if ($ok=='0') {
				$out .= "[0] ";
			}

			$url_tmp = $config->basehref.($config->visiblenewsfile ? $config->newsfile . "/" : "");
			$out .= $this->redirect->make(htmlentities($cur['section']),$url_tmp.
				"section/".urlencode($cur['section']).$config->extraopts.$config->ext)."<BR>";

			if ($section == $cur['section']) {
				$out .= "</B>";
			}

			next($table);
		}

		$out .= "<center><hr noshade size=\"1\" width=\"80%\"></center>\n";
		$out .= "&nbsp;-&nbsp;<a href=\"".$config->basehref."submit.".$config->php."\">".
				lecho("Submit a news")."</A>\n";

		$title_tmp = $this->redirect->make("daCode v".$config->version,
					"http://www.dacode.org/");
		$out = $this->html->sidebox($title_tmp, $out);
		$this->cache->write_box("sidebox_dacode",$cachetmp,$out);
		return $out;
	}


	/* This is to show the topics box on the left */
	Function topics() {
		global $topic;
		global $config;

		$cachetmp = array ($config->ext,$config->score,$config->hide_sig);

		$fcontents = $this->cache->check_box("180","sidebox_topics",$cachetmp);
		if (!empty($fcontents)) {
			return $fcontents;
		}

		$out = "";
		$sqlc_q = "SELECT topic FROM ". $config->tables['topics'].
			" ORDER BY topic";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo "<!-- SQL Failed: ".$this->db->error()." -->";
			return;
		}

		while($row=$this->db->fetch_array()) {
			$out .= "&nbsp;-&nbsp;";
			if ($topic == $row[0]) {
				$out .= "<B>";
			}
			$url_tmp = $config->basehref.($config->visiblenewsfile ? $config->newsfile . "/" : "");
			$out .= $this->redirect->make(htmlentities($row[0]),
				$url_tmp."topic/".urlencode($row[0]).$config->extraopts.$config->ext)."<BR>";
			if ($topic == $row[0]) {
				$out .= "</B>";
			}
		}

		$this->db->free();
		$out = $this->html->sidebox("Topics", $out);
		$this->cache->write_box("sidebox_topics",$cachetmp,$out);
		return $out;
	}

	/*
	 * I use this box to put local links
	 */
	Function local_links() {
		$title = lecho("Local Links");
		$tmp = "&nbsp;-&nbsp;".
			$this->redirect->make("Statistiques LinuxFr","http://linuxfr.org/stats").
			"<BR>";

		return $this->html->sidebox($title,$tmp);
	}

	/*
	 * This is called edito and will be the first box on the right
	 */
	Function edito() {
		global $config;

		if (empty($config->edito)) {
			return;
		}
		$title = lecho("Editorial");
		$body = nl2br($config->edito);
		return $this->html->sidebox($title,$body);
	}

	/*
	 * This is to show the last people connected 
	 */
	Function lastconnected($nb=10) {
		$out = $this->user->get_lastconnected($nb);
		return $this->html->sidebox("Utilisateurs",$out);
	}

	/*
	 * Search box
	 */
	Function searchbox($box="1") {
		global $config;

		if ($box == 1) {
			$tmp = "<form method=\"get\" action=\"".$config->basehref.
				"search.".$config->php."\">".
				"<center><input type=\"text\" name=\"keywords\" size=\"20\"".
				" maxlength=\"100\"><br>".
				"<input type=\"hidden\" name=\"pos\" value=\"0\">".
				"<input type=\"hidden\" name=\"step\" value=\"".
				$config->default_results_step."\">".
				"<input type=\"hidden\" name=\"topic\" value=\"-1\">".
				"<input type=\"hidden\" name=\"section\" value=\"-1\">".
				"<input type=\"submit\" name=\"submit\" value=\"".
				lecho("Search")."\"></center>"."</form>";

			$boxtitle = "<a href=\"".$config->basehref."search.".$config->php."\">".

			lecho("Search")."</a>";


			return $this->html->sidebox($boxtitle,$tmp);
		} else {
			$tmp = "<form method=\"get\" action=\"".$config->basehref.
				"search.".$config->php."\">".
				"<input type=\"text\" name=\"keywords\" size=\"20\"".
				" maxlength=\"100\">&nbsp;".
				"<input type=\"hidden\" name=\"pos\" value=\"0\">".
				"<input type=\"hidden\" name=\"step\" value=\"".
				$config->default_results_step."\">".
				"<input type=\"hidden\" name=\"topic\" value=\"-1\">".
				"<input type=\"hidden\" name=\"section\" value=\"-1\">".
				"<input type=\"submit\" name=\"submit\" value=\"".
				lecho("Search")."\">"."</form>";
			return $tmp;
		}
	}//searchbox

}

?>
