<?php
/* daCode http://www.dacode.org
 * src/phplib/html.php3
 *
 *	All HTML design will be put here
 *
 *	header($title)	Return the header with $title as title.
 *	footer()		Return footer.
 *	newsbox($title, $news, $icon, $urls, footer)	Return the box.
 *
 * Depends: Config Redirect Utils User
 */

class Htmlwm extends Html {
	var $session;
	var $redirect;
	var $hits;
	var $fortune;
	var $utils;

	Function Htmlwm() {
		global $config;

		//echo '<br>Htmlwm';
		$this->utils = LoadClass('Utils',$config);
		$this->session = LoadClass('Session',$config);
		$this->hits = LoadClass('Hits',$config);
		$this->redirect = LoadClass('Redirect',$config);
		$this->fortune = LoadClass('Fortunes',$config);
	}

	/* Returns the header */
	Function header($title,$nobanner="0") {
		global $config;

		$title = (empty($title)) ? $config->titledefault : $title;
		$tmp = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\" ";
		$tmp .= "\"http://www.w3.org/TR/REC-html40/loose.dtd\">\n";
		$tmp .= "\n<html>\n<head>\n";
		$tmp .= "<!-- This page has been generated at the following time: ".
			date("d/m/Y H:j:s")." -->\n";
		$tmp .= "<title>$title</title>\n";
		$tmp .= "<link rel=\"stylesheet\" type=\"text/css\" href=\"".
			$this->session->href_theme('wm.css')."\" >\n";
		$tmp .= "</head>\n";
		$tmp .= "<body bgcolor=\"#515171\">\n";
		$tmp .= "<div class=\"backtext\">\n";
/*  		$tmp .= "<center><table border=\"0\" cellpadding=\"2\" bgcolor=\"#000000\"><tr><td><a href=\"".$config->basehref."\"><img src=\"". */
/*  			 $this->session->imgurl('logo'). */
/*  			 "\" border=\"0\" alt=\"top banner\"></a></td></tr></table></center>\n"; */
		if (!$nobanner) {
		  $tmp .= 
			"<center>". $this->simplebox(
				   "<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr>" .
				   $this->gtkbox("<table cellpadding=\"5\"><tr><td><a href=\"".$config->basehref."\"><img src=\"".
						 $this->session->imgurl('logo').
						 "\" border=\"0\" alt=\"top banner\"></a></td></tr></table>", "c7c7c7") .
				   $tmp .= "</tr></table>\n", ""
				   ).
		  "</center>\n";
		}
		return $tmp;
	}


	/* Returns the footer */
	Function footer($text="",$nobanner="0") {
	  if (!$nobanner) {
		$out = "<table width=\"100%\" border=\"0\"><tr>";
		$out .= "<td class=\"newstext\"><ul>";
		$out .= "<li>".lecho("This website runs")." <a href=\"http://www.dacode.org/\">";
		$out .= "daCode</a></li>\n";
		$out .= "</ul></td>";

		$out .= "<td class=\"newstext\" nowrap>";
		$out .= $this->fortune->get_random();
		$out .= "</td></tr>";
		$out .= "</table>";
		$out .= $text;
		$tmp = $this->simplebox($out);
	  }
	  $tmp .= "</body>\n</html>\n";
	  return $tmp;
	}

	/* Return HTML code for side box with $text */
	Function sidebox($title,$text, $type="") {
		$title = preg_replace ("/(<[A-a].*>)(.*)<\/a>/", "\\1<font color=\"White\">\\2</font></a>", $title); /* kludge, en attendant mieux */
		$tmp = "
		<!-- SIDEBOX $type -->\n".
		  $this->titlebar($title,"boxheader",0) .
		  "		<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"2\" bgcolor=\"#c7c7c7\"><tr><td class=\"boxtext\">$text</td></tr></table>\n".
		  $this->bottombar().
		  "		<!-- /SIDEBOX $type -->\n";
		return $tmp;
	}
	
	/* Return HTML code for simple box with $text */
	Function simplebox($text, $width="100%") {
		$tmp = "<!-- SIMPLEBOX -->\n";
		$tmp .= "<table border=\"0\" cellspacing=\"0\" cellpadding=\"1\" width=\"$width\" bgcolor=\"#000000\">\n<tbody>";
		$tmp .= "  <tr><td>\n";
		$tmp .= "   <table border=\"0\" cellspacing=\"0\" cellpadding=\"2\" width=\"100%\" bgcolor=\"#c7c7c7\">\n<tbody>";
		$tmp .= "   <tr><td class=\"newstext\">\n";
		$tmp .= "   $text\n";
		$tmp .= "   </td></tr>\n";
		$tmp .= "   </table>\n";
		$tmp .= "  </td></tr>\n";
		$tmp .= "</table><br>\n";
		$tmp .= "<!-- /SIMPLEBOX -->\n";
		return $tmp;
	}

	/* Return HTML code for news box with $row from news table */
	Function newsbox($row,$preview=0) {
		global $section,$topic;
		global $config;
	
 		// Title is referenced by a <a name>
 		$title = 	'<a name="n'.$row['id'].'">'.
 				((empty($row['title'])) ?
 					$config->newstitledefault :
 					$row['title']).
 				'</a>';

		$body = $this->linkto_topic($row['topic']);
		$body .= (empty($row['body'])) ? $config->newsbodydefault : 
			 (($row[content_type]=="text/plain") ? nl2br($row['body']) : $row['body']);

		$row[section]=(empty($row['section'])) ? "nosection" : $row['section'];
		$row[topic]=(empty($row['topic'])) ? "notopic" : $row['topic'];
		
		// Let's do HTML code
		$tmp = " <!-- NEWSBOX $row[id] -->\n";
		$tmp .= $this->titlebar($title, "newstitle", 1);
		$tmp .= "<table border=\"0\" bgcolor=\"#c7c7c7\" cellspacing=\"0\" ".
		  "cellpadding=\"3\" width=\"100%\"><tr><td bgcolor=\"#c7c7c7\" nowrap class=\"newsinfo\">";

		$tmp .= $this->newsbox_posted_by($row,$preview);

		$tmp .= "<!-- ADMINEDIT:".$row['id']." -->";
		if ($this->session->checked && ($this->session->level&pow(2,21))) {
			$tmp .= " - <B><A HREF=\"".$config->basehref.
					$config->adminfile."?action=edit_news&amp;news_id=".$row['id']."\">Edit!</A></B>";
		}
		$tmp .= "<!-- /ADMINEDIT -->";

		
		if (!empty($departement)) {
			$tmp .= "<br>\n" . ucfirst(lecho("dept")) . ": <b>$departement</b>";
		}
		$tmp .= "\n      </td>\n     </tr>\n     <tr bgcolor=\"#C7C7C7\">\n";
		$tmp .= "<td class=\"newstext\">";
 		$links = $this->newsbox_show_links($row,$preview);
		$tmp .= $this->gtkbox($body.$links, "ffffff");
		$tmp .= "</td></tr>";

		$tmp .= "<tr><td class=\"newstext\">\n";
 		ereg("^([0-9]{4})([0-9]{2})([0-9]{2})", $row['timestamp'], $regs);
 		$count = $this->newsbox_count_comments($row,$section,$topic,$regs[1],$regs[2],$regs[3]) . "&nbsp;&nbsp;";
 		$tmp .= $this->gtkbox($count.$this->newsbox_show_attachments($row), "c7c7c7");
 		$tmp .= "</td></tr></table>";

		$tmp .= $this->bottombar();
		  
		$tmp .= "<!-- /NEWSBOX -->\n";
		return $tmp;
		
	}

	/* Function to print comment top banner */
	Function commentbanner ($score) {
		global $config,$news;
		global $section,$topic;
		global $HTTP_GET_VARS,$news_id;

		// Get information to get timestamp + news
		global $PATH_INFO;
		$path = ereg_replace('^/'.$config->htmldir, '/', $PATH_INFO);
		if (ereg("^(.*)\\.(html|$config->php)", $path, $res)) {
			$path = $res[1];
		}
		if (ereg('^([^,]*)(,.+)$', $path, $res)) {
			$path = $res[1];
		}
		if (ereg("^/([0-9]{4})/([0-9]{2})/([0-9]{2})/([0-9]+)$", $path, $res)) {
			$year = $res[1];
			$month= $res[2];
			$day  = $res[3];
		} else {
			$timestamp = $this->utils->gettimestampnews($news_id);

			ereg("^([0-9]{4})([0-9]{2})([0-9]{2})", $timestamp, $res);
			$year = $res[1];
			$month= $res[2];
			$day  = $res[3];

		}
		/////

		if (isset($HTTP_GET_VARS['score'])) {
			$score = $HTTP_GET_VARS['score'];
		}
 		$out = "<a name=\"banner\" href=\"".
 			$this->session->newsurls($news_id,'','',$year,$month,$day,$score).
 			"\"><font color=\"#ffffff\">\n";
		$out .= $news->show_title($news_id);
 		$out .= "</font></a> | ";
 		$out .= "<a href=\"".$config->basehref.
 				"users/?a=na\"><font color=\"#ffffff\">".lecho("New Account").
 				"</font></a> | <b>";
		$counttmp = $news->count_comments($news_id);
		$out .= $counttmp . "</b> ";
		if ($counttmp <= 1) {
			$out .= lecho("comment")."\n";
		} else {
			$out .= lecho("comments")."\n";
		}

		$out = $this->titlebar($out, "boxheader", 0);
		
 		$out .= "<table width=\"100%\" bgcolor=\"#c7c7c7\" border=\"0\" cellpadding=\"2\" cellspacing=\"0\"><tr><td class=\"commentboxmiddle\">\n";
 		$out .= "<form method=\"post\" action=\"". $config->basehref.$config->commaddfile."\">\n";
 		$out .= "<input type=\"hidden\" name=\"news_id\"".
 				"value=\"$news_id\">\n";
		$out .= "<input type=\"hidden\" name=\"year\" value=\"$year\">\n";
		$out .= "<input type=\"hidden\" name=\"month\" value=\"$month\">\n";
		$out .= "<input type=\"hidden\" name=\"day\" value=\"$day\">\n";

		if (!empty($section)) {
			$out .= "<input type=\"hidden\" name=\"section\" value=\"$section\">\n";
		} else {
			$out .= "<input type=\"hidden\" name=\"section\" value=\"0\">\n";
		}

		if (!empty($topic)) {
			$out .= "<input type=\"hidden\" name=\"topic\" value=\"$topic\">\n";
		} else {
			$out .= "<input type=\"hidden\" name=\"topic\" value=\"0\">\n";
		}

		$out .= "<input type=\"checkbox\" name=\"hide_sig\" ";
		if ($config->hide_sig == "1") {
			$out .= "checked>\n";
		} else {
			$out .= ">\n";
		}
		$out .= "Score: <select name=\"score\">\n";
		$score_comment = (array) $news->count_comments_array($news_id);
		for ($i=-1;$i<6;$i++) {
			$counttmp = $score_comment['n'.$news_id]['s'.$i];
			$out .= "<option value=\"$i\" ";

			if ($i == $score || (!isset($score) && $this->session->score == $i)) {
				$out .= "selected";
			}

			$out .= ">$i: $counttmp ";
			if ($counttmp <= 1) {
				$out .= lecho("comment")."\n";
			} else {
				$out .= lecho("comments")."\n";
			}
		}
		$out .= "</select>";
 		$out .= "<input type=\"submit\" name=\"op\"".
 				"value=\"".lecho("Change")."\">\n";
 		$out .= "<input type=\"submit\" name=\"op\"".
 				"value=\"".lecho("Reply")."\">\n</form></td></tr>\n";
 		$out .= "<tr><td class=\"commentbox\">\n";
 		$out .= lecho("<b>The fine print</b>: The following comments are owned by whoever posted them.")." ";
		$out .= lecho("We are not responsible for what they say.")."\n";
		$out .= "</TD></TR></TABLE>\n";
		
		$out .= $this->bottombar();

		return $out;
	}

	Function titlebar ($title, $style, $buttons) {
		return 
    "<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr>".
    "<td width=\"".($buttons?"10":"2")."\"><img border=\"0\" ".
    " src=\"".
    ($buttons?$this->session->imgurl('tw'):$this->session->imgurl('ttw')).
    "\" ALT=\"(( \"></td>".
    "<td width=\"100%\" bgcolor=\"#000000\" background=\"".$this->session->imgurl('t')."\" class=\"$style\"><nobr>&nbsp;$title&nbsp;</nobr></td><td width=\"".($buttons?"10":"2")."\"".
    " align=\"right\"><img border=\"0\" ".
    " src=\"".
    ($buttons?$this->session->imgurl('te'):$this->session->imgurl('tte')).
    "\" ALT=\"))\"></td></tr></table>\n".
    "<table border=\"0\" cellspacing=\"0\" cellpadding=\"1\" width=\"100%\" bgcolor=\"#000000\">".
    "<tr><td valign=\"bottom\">";
	}


	Function bottombar () {
		return 
    "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">".
    "<tr>".
    "<td valign=\"top\"><img border=\"0\" ".
    " src=\"".$this->session->imgurl('tsw')."\" ALT=\"\"></td>".
    "<td width=\"100%\" valign=\"middle\" background=\"".$this->session->imgurl('ts')."\"><img src=\"".$this->session->imgurl('ts')."\" alt=\"\"></td><td width=\"10\"".
    " align=\"right\" valign=\"top\"><img border=\"0\" ".
    " src=\"".$this->session->imgurl('tse')."\" ALT=\"\"></td></tr>\n".
    "</table>".
    "</td>\n  </tr>\n".
    " </table>\n <br>\n";
		}

	Function gtkbox ($content, $color) {
		$tmp = "<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\">\n".
			"<tr><td width=\"2\" background=\"".$this->session->imgurl('n')."\"><img border=\"0\" src=\"".$this->session->imgurl('nw')."\" height=\"2\" width=\"2\" alt=\"\"></td>".
			"<td width=\"100%\" background=\"".$this->session->imgurl('n')."\"><img src=\"".$this->session->imgurl('n')."\" height=\"2\" alt=\"\"></td>".
			"<td width=\"2\" background=\"".$this->session->imgurl('n')."\"><img border=\"0\" src=\"".$this->session->imgurl('ne')."\" width=\"2\" height=\"2\" alt=\"\"></td>".
			"</tr>\n";
  
  $tmp .= "<tr><td width=\"2\" border=\"0\" background=\"".$this->session->imgurl("w-$color")."\"><img src=\"".$this->session->imgurl("w-$color")."\" alt=\"\"></td>";
  $tmp .= "<td width=\"100%\" class=\"newstext\" bgcolor=\"#$color\">";
  $tmp .= $content;
  $tmp .= "</td><td width=\"2\" border=\"0\" background=\"".$this->session->imgurl("e-$color")."\"><img src=\"".$this->session->imgurl("e-$color")."\" height=\"2\" width=\"2\" alt=\"\"></td>";
  $tmp .= "</tr><tr>";
  $tmp .= "<td width=\"2\" background=\"".$this->session->imgurl('s')."\"><img border=\"0\" src=\"".$this->session->imgurl('sw')."\" alt=\"\"></td>";
  $tmp .= "<td width=\"100%\" background=\"".$this->session->imgurl('s')."\"><img src=\"".$this->session->imgurl('s')."\" height=\"2\" alt=\"\"></td>";
  $tmp .= "<td width=\"2\" background=\"".$this->session->imgurl('s')."\"><img border=\"0\" src=\"".$this->session->imgurl('se')."\" height=\"2\" width=\"2\" alt=\"\"></td>";
  $tmp .= "</tr></table>\n";

  return $tmp;
	}

}
