#
# FtpCube
# Copyright (C) 2001 Michael Gilfix
#
# This file is part of FtpCube.
#
# You should have received a file COPYING containing license terms
# along with this program; if not, write to Michael Gilfix
# (mgilfix@eecs.tufts.edu) for a copy.
#
# This version of FtpCube is open source; you can redistribute it and/or
# modify it under the terms listed in the file COPYING.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#

import gtk
import sys, os
import main

from intl import _

# For compatibility with win32 pygtk
if sys.platform == "win32":
	import GTKconst
	GTK = GTKconst
else:
	import GTK

class CmdWin:

	"""Command window class

	This object displays the command window within the alloted
	container, which is a scrolled, non-editable text window. The
	command-window also takes care of all the formatting and color
	coding of the displayed text."""

	def __init__ (self, container):
		"""Initializes and displays the command window. Text colors
		are initialized to 'None' by default."""

		self.format = {
			'local'  : _("LOCAL >  %s\n"),
			'remote' : _("REMOTE> %s\n"),
			'error'  : _("! - %s\n")
		}

		self.colors = {
			'local' : None,
			'remote' : None,
			'error' : None
		}

		self.gdk_colors = {
			'local' : None,
			'remote' : None,
			'error' : None
		}

		win = gtk.GtkScrolledWindow ()
		win.set_policy (GTK.POLICY_AUTOMATIC, GTK.POLICY_AUTOMATIC)
		win.show ()
		container.add (win)

		self.text = gtk.GtkText ()
		self.text.set_usize (-1, 150)
		self.text.set_editable (gtk.FALSE)
		self.text.show ()
		win.add (self.text)

		self.colormap = self.text.get_colormap()

	def display_banner (self):
		"""Prints the application greeting in the command window."""

		self.insert_color_text ('local', _('Welcome to FtpCube v0.3.2'))
		self.insert_color_text ('local', _('Copyright (C) 2001  Michael Gilfix'))
		self.insert_color_text ('local', _('=========================================='))
		self.insert_color_text ('local', '')

	def insert_color_text(self, kind, text):
		"""Reformats the 'text' string according to its type string 'kind' and
		prints it in the appropriate color."""

		gdk_color = self.get_gdk_color(kind)
		text = self.format[kind] % text
		self.text.insert (None, gdk_color, None, text)

	def get_gdk_color(self, kind):
		"""Returns the GDK color object associated with the color type string
		'kind'."""

		current_color = main.app[kind + '_color']

		if self.colors[kind] == current_color:
			gdk_color = self.gdk_colors[kind]
		else:
			rgbo = map (lambda c: int (c * 65535.0), current_color)
			gdk_color = apply (self.colormap.alloc, rgbo)
			self.colors[kind] = current_color
			self.gdk_colors[kind] = gdk_color

		return gdk_color
