/* DiaCanvas -- A technical drawing canvas.
 * Copyright (C) 1999, Arjan Molenaar
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/* Original license:
 * Dia -- an diagram creation/manipulation program
 * Copyright (C) 1999 Alexander Larsson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __DIA_IMAGE_H__
#define __DIA_IMAGE_H__

#include <diacanvas/geometry.h>
#include <diacanvas/diarenderer.h>
#include <diacanvas/diadefs.h>

DIA_OPEN

typedef void DiaImage;


void      dia_image_init (void);

DiaImage* dia_image_get_broken (void);

DiaImage* dia_image_load (gchar *filename);
void      dia_image_release (DiaImage* image);
void      dia_image_draw (DiaImage* image, GdkWindow *window,
		     gint x, gint y, gint width, gint height);

gint     dia_image_width (DiaImage* image);
gint     dia_image_height (DiaImage* image);
guint8  *dia_image_rgb_data (DiaImage* image);
gchar   *dia_image_filename (DiaImage* image);

DIA_CLOSE

#endif /* __DIA_IMAGE_H__ */


