# __init__.py
#
# Moleskine: a source code editor for the GNOME desktop
#
# Copyright (c) 2000 - 2002   Michele Campeotto <micampe@micampe.it>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


try:
    import gettext
    import commands
    
    domain = 'moleskine'
    
    data_dir = commands.getoutput('gnome-config --datadir')
    locale_dir = data_dir + '/locale'
    
    gettext.bindtextdomain(domain, locale_dir)
    gettext.textdomain(domain)
    
    # here from _gladetext module to direct call GNU gettext
    # so libglade can know where to find the mo file
    try:
        import _gtkscintilla
        _gtkscintilla.bindtextdomain(domain, locale_dir)
        _gtkscintilla.textdomain(domain)
    except:
        pass
except IOError:
    pass
    
import __builtin__
__builtin__.__dict__['_'] = gettext.gettext
