###
# Application: pyFind
# File:        config.py
# Description: Configuration class.
# Copyright (c) 2001-2002   Andy Balcombe <kinematics _at_ ntlworld.com>
###
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#standard python modules
import gnome.config

#version info for pyFind
app_name = "pyFind"
app_version = "0.10.2"
authors = [ "Andy Balcombe <kinematics@ntlworld.com>", 
            "Contributors:", 
            "     Michele Campeotto <micampe@f2s.com>",
            "     David Rasch <drasch@science.uva.nl>",
            "     John W. Shipman <john@nmt.edu>",
            "     Jeff Bauer <jbauer@rubic.com>",
            "Translators:",
            "     ru: Vladimir and Pavel (svo@asplinux.udm.net)",
            "Thanks to:",
            "     Jonathan Slavin (jslavin@cfa.harvard.edu)",
            "     Michele Campeotto <micampe@f2s.com>",
            "         and all the contributors to the excellent",
            "         Moleskine editor <http://www.moleskine.f2s.com>"
          ]
            

#use the gnome configuration api
class GnomeConfig: 
    #init config file
    def __init__( self, psApp ):
        #set application filename to look for in ~/.gnome directory
        self.config_filename = psApp
        
    # sync the gnome config file
    def sync( self ):
        gnome.config.sync_file( self.config_filename )

    #return string value of specified key
    def get_value( self, psSection, psKey, psDefault ):
        #get dictionary of all entries in specified section
        sValue = gnome.config.get_string( self.config_filename + "/" + psSection + "/" + psKey )
        if sValue != None:
            return sValue
        else:
            return psDefault
            
    #save string value of specified key
    def set_value( self, psSection, psKey, psValue ):
        gnome.config.set_string( self.config_filename + "/" + psSection + "/" + psKey, psValue )

