###
# Application: pyFind
# File:        dlgPreferences.py
# Description: Preferences dialog
# Copyright (c) 2001   Andy Balcombe <kinematics _at_ ntlworld.com>
###
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#project imports
from LoadGlade import *
import config

class dlgPreferences(LoadGlade):
    """
    pyfind preferences dialog class
    """
    def init_Preferences(self, app):
        #init prefs
        self.app = app
        self.dlgPreferences.set_parent(self.app.appMain)
        self.dlgPreferences.set_transient_for(self.app.appMain)

        #get config
        self.bLoading = 1
        self.confPrefs = config.GnomeConfig("pyFind")
        
        #set toolbar radio buttons
        iTbrMain = int(self.confPrefs.get_value( "config", "tbrMain", str(TOOLBAR_BOTH)))
        if iTbrMain == TOOLBAR_BOTH:
            self.optTbrMainBoth.set_active(TRUE)
        elif iTbrMain == TOOLBAR_TEXT:
            self.optTbrMainText.set_active(TRUE)
        elif iTbrMain == TOOLBAR_ICONS:
            self.optTbrMainIcons.set_active(TRUE)
        
        iTbrFile = int(self.confPrefs.get_value( "config", "tbrFile", str(TOOLBAR_BOTH)))
        if iTbrFile == TOOLBAR_BOTH:
            self.optTbrFileBoth.set_active(TRUE)
        elif iTbrFile == TOOLBAR_TEXT:
            self.optTbrFileText.set_active(TRUE)
        elif iTbrFile == TOOLBAR_ICONS:
            self.optTbrFileIcons.set_active(TRUE)

        #set columns tab
        sResultCols = self.confPrefs.get_value( "config", "ResultCols", "011100101")
        lCols = ["chkColType","","","chkColPermissions","chkColUser","chkColGroup","chkColSize","chkColATime","chkColMTime",]
        iCol = 0
        for sCol in sResultCols:
            if lCols[ iCol ] != "":
                #build up this codestring and execute it
                sExec = "self." + lCols[ iCol ] + ".set_active( int(sCol) )"
                exec sExec
            iCol = iCol +1
        
        #self.confPrefs.sync()

        #display prefs
        self.bLoading = 0
        self.dlgPreferences.show()
        
    def on_preferences_changed(self, *args):
        #tells gnome to call on_preferences_apply when OK or Apply pressed in dialog
        if not self.bLoading:
            print "on_preferences_changed"
            self.dlgPreferences.changed() 

    def on_preferences_apply(self, ctlPropBox, page, *args):
        print "on_preferences_apply, page=", page
        if (page != -1):
            return

        #init config values
        iTbrMain = TOOLBAR_ICONS
        iTbrFile = TOOLBAR_ICONS
        sResultsCols = ""

        # Check and save the display toolbar radio buttons (Main Toolbar)
        if self.optTbrMainBoth.get_active():
            iTbrMain = TOOLBAR_BOTH
        elif self.optTbrMainIcons.get_active():
            iTbrMain = TOOLBAR_ICONS
        elif self.optTbrMainText.get_active():
            iTbrMain = TOOLBAR_TEXT
        self.confPrefs.set_value( "config", "tbrMain", str(iTbrMain) )

        # Check and save the display toolbar radio buttons (File Toolbar)
        if self.optTbrFileBoth.get_active():
            iTbrFile = TOOLBAR_BOTH
        elif self.optTbrFileIcons.get_active():
            iTbrFile = TOOLBAR_ICONS
        elif self.optTbrFileText.get_active():
            iTbrFile = TOOLBAR_TEXT
        self.confPrefs.set_value( "config", "tbrFile", str(iTbrFile) )
    
        #check and save the results columns list
        sResultCols = str(self.chkColType.get_active()) + \
                      "11" + \
                      str(self.chkColPermissions.get_active()) + \
                      str(self.chkColUser.get_active()) + \
                      str(self.chkColGroup.get_active()) + \
                      str(self.chkColSize.get_active()) + \
                      str(self.chkColATime.get_active()) + \
                      str(self.chkColMTime.get_active())
        self.confPrefs.set_value( "config", "ResultCols", sResultCols )

        #sync config
        self.confPrefs.sync()
        
        #redisplay preferences
        self.app.set_config_preferences()
        
        