## $Id: expand.py,v 1.1.1.1 2000/05/12 14:58:53 dagb Exp $

## System modules
from gtk import *
from gnome.ui import *


##
##
## Expand name confirmation window class
##
##
class ExpandWindow:
    ##
    ## Method __init__ (self, folder window class instance)
    ##
    ##    Expand widget constructor.
    ##
    ##
    def __init__(self, fld, name, email, hdr):
        self.fld = fld
        self.fld.status = 0
        self.win = GnomeMessageBox('Expand Name in %s header' % hdr, 'question',
                                   STOCK_BUTTON_YES, STOCK_BUTTON_NO)
        self.win.set_parent(self.fld.win)
        self.win.connect('clicked', self.handle_callbacks)
	self.win.connect('delete_event', self.destroy)
	self.win.connect('destroy', self.destroy)
	l = GtkLabel("Do you want to expand '%s' to '%s' ?" %(name, email))
        l.show()
        self.win.vbox.pack_start(l)
        self.win.show()


    ##
    ## Method handle_callbacks (self, button, no)
    ##
    ##    Handle callbacks for the action buttons.
    ##
    ##
    def handle_callbacks(self, button, no):
        # no == 0 -> expand, otherwise not expand
        self.fld.status = ( no == 0 )
        self.destroy()

    ## Just to short-circuit the window delete/destroy events
    def destroy(self, foo=None, bar=None):
        self.win.destroy()
        mainquit()

    ## Mainloop stuff
    def mainloop(self):
        mainloop()
