## $Id: pygmymailbox.py,v 1.7 2001/06/11 19:32:07 jdhildeb Exp $

## System Modules
import mailbox, rfc822


##
##
## Pygmy mailbox class
##
##
class PygmyMailbox(mailbox.UnixMailbox):
    # Have to include the seek-start parameter here
    def __init__(self, fp, start=0):
        self.fp = fp
        self.seekp = start
        self.factory = rfc822.Message

    # Current start index in file
    cur_start = 0

    def _search_start(self):
        while 1:
            pos = int(self.fp.tell())
            line = self.fp.readline()
            if not line:
                raise EOFError
            if line[:5] == 'From ' and self._isrealfromline(line):
                self.fp.seek(pos)
                # Record current start of message
                self.cur_start = pos
                return

    def _search_end(self):
        while 1:
            pos = int(self.fp.tell())
            line = self.fp.readline()
            if not line:
                return
            if line[:5] == 'From ' and self._isrealfromline(line) \
            and pos > self.cur_start:
                # Next message start must differ from the previous
                self.fp.seek(pos)
                return

    _fromlinepattern = r"""From \s*('.+'[^\s]*|".+"[^\s]*|[^\s]+)\s+\w\w\w\s+\w\w\w"""\
                       r"""\s+\d?\d\s+\d?\d:\d\d(:\d\d)?(\s+[^\s]+)?\s+\d\d\d\d\s*([+-]\d\d\d\d)?\s*$"""
    _regexp = None

    def _isrealfromline(self, line):
        if not self._regexp:
            import re
            self._regexp = re.compile(self._fromlinepattern)
        return self._regexp.match(line)
