/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.translators;

import artofillusion.ModellingApp;
import artofillusion.Scene;
import artofillusion.animation.PositionTrack;
import artofillusion.animation.RotationTrack;
import artofillusion.animation.Track;
import artofillusion.image.ImageMap;
import artofillusion.image.ImageOrColor;
import artofillusion.image.ImageOrValue;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.DirectionalLight;
import artofillusion.object.Mesh;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SceneCamera;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.ImageMapTexture;
import artofillusion.texture.Texture;
import artofillusion.texture.Texture2D;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.UVMapping;
import artofillusion.texture.UniformTexture;
import artofillusion.ui.MessageDialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class OBJImporter {
    /*
     * WARNING - void declaration
     */
    public static void importFile(Frame parent) {
        FileDialog fd = new FileDialog(parent, "Import OBJ Fie", 0);
        if (ModellingApp.currentDirectory != null) {
            fd.setDirectory(ModellingApp.currentDirectory);
        }
        fd.show();
        if (fd.getFile() == null) {
            return;
        }
        File f = new File(fd.getDirectory(), fd.getFile());
        ModellingApp.currentDirectory = fd.getDirectory();
        String objName = fd.getFile();
        if (objName.lastIndexOf(46) > 0) {
            objName = objName.substring(0, objName.lastIndexOf(46));
        }
        Scene theScene = new Scene();
        CoordinateSystem coords = new CoordinateSystem(new Vec3(0.0, 0.0, 20.0), new Vec3(0.0, 0.0, -1.0), Vec3.vy());
        ObjectInfo info = new ObjectInfo((Object3D)new SceneCamera(), coords, "Camera 1");
        info.addTrack((Track)new PositionTrack(info), 0);
        info.addTrack((Track)new RotationTrack(info), 1);
        theScene.addObject(info, null);
        info = new ObjectInfo((Object3D)new DirectionalLight(new RGBColor(1.0f, 1.0f, 1.0f), 0.8f), coords.duplicate(), "Light 1");
        info.addTrack((Track)new PositionTrack(info), 0);
        info.addTrack((Track)new RotationTrack(info), 1);
        theScene.addObject(info, null);
        Hashtable<String, Vector> groupTable = new Hashtable<String, Vector>();
        Hashtable textureTable = new Hashtable();
        Vector<Vec3> vertex = new Vector<Vec3>();
        Vector<Vec3> normal = new Vector<Vec3>();
        Vector<Vec3> texture = new Vector<Vec3>();
        Vector[] face = new Vector[]{new Vector()};
        groupTable.put("default", face[0]);
        int lineno = 0;
        int smoothingGroup = -1;
        String currentTexture = null;
        VertexInfo[] vertIndex = new VertexInfo[3];
        double[] val = new double[3];
        BufferedReader in = null;
        try {
            String s;
            in = new BufferedReader(new FileReader(f));
            while ((s = in.readLine()) != null) {
                int i;
                String[] fields;
                void var18_19;
                ++lineno;
                if (var18_19.startsWith("#") || (fields = OBJImporter.breakLine((String)var18_19)).length == 0) continue;
                if ("v".equals(fields[0]) && fields.length == 4) {
                    i = 0;
                    while (i < 3) {
                        try {
                            val[i] = new Double(fields[i + 1]);
                        }
                        catch (NumberFormatException ex) {
                            throw new Exception("Illegal value '" + fields[i + 1] + "' found in line " + lineno + ".");
                        }
                        ++i;
                    }
                    vertex.addElement(new Vec3(val[0], val[1], val[2]));
                    continue;
                }
                if ("vn".equals(fields[0]) && fields.length == 4) {
                    i = 0;
                    while (i < 3) {
                        try {
                            val[i] = new Double(fields[i + 1]);
                        }
                        catch (NumberFormatException ex) {
                            throw new Exception("Illegal value '" + fields[i + 1] + "' found in line " + lineno + ".");
                        }
                        ++i;
                    }
                    normal.addElement(new Vec3(val[0], val[1], val[2]));
                    continue;
                }
                if ("vt".equals(fields[0]) && fields.length > 1) {
                    i = 0;
                    while (i < 3) {
                        try {
                            val[i] = i < fields.length - 1 ? new Double(fields[i + 1]) : 0.0;
                        }
                        catch (NumberFormatException ex) {
                            throw new Exception("Illegal value '" + fields[i + 1] + "' found in line " + lineno + ".");
                        }
                        ++i;
                    }
                    texture.addElement(new Vec3(val[0], val[1], val[2]));
                    continue;
                }
                if ("f".equals(fields[0])) {
                    if (vertIndex.length != fields.length - 1) {
                        vertIndex = new VertexInfo[fields.length - 1];
                    }
                    i = 0;
                    while (i < vertIndex.length) {
                        vertIndex[i] = OBJImporter.parseVertexSpec(fields[i + 1], vertex, texture, normal, lineno);
                        ++i;
                    }
                    int i2 = 0;
                    while (i2 < face.length) {
                        if (fields.length == 4) {
                            face[i2].addElement(new FaceInfo(vertIndex[0], vertIndex[1], vertIndex[2], smoothingGroup, currentTexture));
                        } else if (fields.length == 5) {
                            face[i2].addElement(new FaceInfo(vertIndex[0], vertIndex[1], vertIndex[2], smoothingGroup, currentTexture));
                            face[i2].addElement(new FaceInfo(vertIndex[2], vertIndex[3], vertIndex[0], smoothingGroup, currentTexture));
                        } else if (fields.length > 5) {
                            int step = 1;
                            while (2 * step < vertIndex.length) {
                                int start = 0;
                                while (start + 2 * step < vertIndex.length) {
                                    face[i2].addElement(new FaceInfo(vertIndex[start], vertIndex[start + step], vertIndex[start + 2 * step], smoothingGroup, currentTexture));
                                    start += 2 * step;
                                }
                                if (start + step < vertIndex.length) {
                                    face[i2].addElement(new FaceInfo(vertIndex[start], vertIndex[start + step], vertIndex[0], smoothingGroup, currentTexture));
                                }
                                step *= 2;
                            }
                        }
                        ++i2;
                    }
                    continue;
                }
                if ("s".equals(fields[0])) {
                    if (fields.length == 1 || "off".equalsIgnoreCase(fields[1])) {
                        smoothingGroup = 0;
                        continue;
                    }
                    try {
                        smoothingGroup = Integer.parseInt(fields[1]);
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        throw new Exception("Illegal value '" + fields[1] + "' found in line " + lineno + ".");
                    }
                }
                if ("g".equals(fields[0])) {
                    face = new Vector[fields.length - 1];
                    i = 0;
                    while (i < face.length) {
                        face[i] = (Vector)groupTable.get(fields[i + 1]);
                        if (face[i] == null) {
                            face[i] = new Vector();
                            groupTable.put(fields[i + 1], face[i]);
                        }
                        ++i;
                    }
                    continue;
                }
                if ("usemtl".equals(fields[0]) && fields.length > 1) {
                    currentTexture = fields[1];
                    continue;
                }
                if (!"mtllib".equals(fields[0])) continue;
                i = 1;
                while (i < fields.length) {
                    OBJImporter.parseTextures(fields[i], new File(fd.getDirectory()), textureTable);
                    ++i;
                }
            }
            Enumeration enumeration = groupTable.keys();
            Hashtable<String, Texture> realizedTextures = new Hashtable<String, Texture>();
            Hashtable imageMaps = new Hashtable();
            while (enumeration.hasMoreElements()) {
                String group = (String)enumeration.nextElement();
                Vector groupFaces = (Vector)groupTable.get(group);
                if (groupFaces.size() == 0) continue;
                int[] realIndex = new int[vertex.size()];
                int i = 0;
                while (i < realIndex.length) {
                    realIndex[i] = -1;
                    ++i;
                }
                int[][] fc = new int[groupFaces.size()][];
                int numVert = 0;
                int i3 = 0;
                while (i3 < fc.length) {
                    FaceInfo fi = (FaceInfo)groupFaces.elementAt(i3);
                    int j = 0;
                    while (j < 3) {
                        if (realIndex[fi.getVertex((int)j).vert] == -1) {
                            realIndex[fi.getVertex((int)j).vert] = numVert++;
                        }
                        ++j;
                    }
                    fc[i3] = new int[]{realIndex[fi.v1.vert], realIndex[fi.v2.vert], realIndex[fi.v3.vert]};
                    ++i3;
                }
                Vec3[] vert = new Vec3[numVert];
                Vec3 center = new Vec3();
                int i4 = 0;
                while (i4 < realIndex.length) {
                    if (realIndex[i4] > -1) {
                        vert[realIndex[i4]] = (Vec3)vertex.elementAt(i4);
                        center.add(vert[realIndex[i4]]);
                    }
                    ++i4;
                }
                center.scale(1.0 / (double)vert.length);
                int i5 = 0;
                while (i5 < vert.length) {
                    vert[i5] = vert[i5].minus(center);
                    ++i5;
                }
                coords = new CoordinateSystem(center, Vec3.vz(), Vec3.vy());
                info = new ObjectInfo((Object3D)new TriangleMesh(vert, (int[][])fc), coords, "default".equals(group) ? objName : group);
                info.addTrack((Track)new PositionTrack(info), 0);
                info.addTrack((Track)new RotationTrack(info), 1);
                TriangleMesh.Edge[] edge = ((TriangleMesh)info.object).getEdges();
                int i6 = 0;
                while (i6 < edge.length) {
                    if (edge[i6].f2 != -1) {
                        FaceInfo f1 = (FaceInfo)groupFaces.elementAt(edge[i6].f1);
                        FaceInfo f2 = (FaceInfo)groupFaces.elementAt(edge[i6].f2);
                        if (f1.smoothingGroup == 0 || f1.smoothingGroup != f2.smoothingGroup) {
                            edge[i6].smoothness = 0.0f;
                        } else {
                            int j = 0;
                            while (j < 3) {
                                int k = 0;
                                while (k < 3) {
                                    if (f1.getVertex((int)j).vert == f2.getVertex((int)k).vert) {
                                        int n1 = f1.getVertex((int)j).norm;
                                        int n2 = f2.getVertex((int)k).norm;
                                        if (n1 == n2 || !(((Vec3)normal.elementAt(n1)).distance((Vec3)normal.elementAt(n2)) > 1.0E-10)) break;
                                        edge[i6].smoothness = 0.0f;
                                        break;
                                    }
                                    ++k;
                                }
                                ++j;
                            }
                        }
                    }
                    ++i6;
                }
                String texName = ((FaceInfo)groupFaces.elementAt((int)0)).texture;
                if (texName != null && textureTable.get(texName) != null) {
                    Texture tex = (Texture)realizedTextures.get(texName);
                    if (tex == null) {
                        tex = OBJImporter.createTexture((TextureInfo)textureTable.get(texName), theScene, fd.getDirectory(), imageMaps, parent);
                        realizedTextures.put(texName, tex);
                    }
                    if (tex instanceof Texture2D) {
                        UVMapping map = new UVMapping(tex);
                        info.setTexture(tex, (TextureMapping)map);
                        Vec2[] uv = new Vec2[numVert];
                        int j = 0;
                        while (j < groupFaces.size()) {
                            FaceInfo fi = (FaceInfo)groupFaces.elementAt(j);
                            int k = 0;
                            while (k < 3) {
                                VertexInfo vi = fi.getVertex(k);
                                Vec3 texCoords = (Vec3)(vi.tex < texture.size() ? texture.elementAt(vi.tex) : vertex.elementAt(vi.vert));
                                uv[realIndex[vi.vert]] = new Vec2(texCoords.x, texCoords.y);
                                ++k;
                            }
                            ++j;
                        }
                        map.setTextureCoordinates((Mesh)info.object, map.getParameters(), uv);
                    } else {
                        info.setTexture(tex, tex.getDefaultMapping());
                    }
                }
                theScene.addObject(info, null);
            }
        }
        catch (Exception ex) {
            try {
                in.close();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            new MessageDialog(parent, new String[]{"An error occurred while reading the file:", ex.getMessage()});
            return;
        }
        ModellingApp.newWindow((Scene)theScene);
    }

    private static String[] breakLine(String line) {
        StringTokenizer st = new StringTokenizer(line);
        Vector<String> v = new Vector<String>();
        while (st.hasMoreTokens()) {
            v.addElement(st.nextToken());
        }
        Object[] result = new String[v.size()];
        v.copyInto(result);
        return result;
    }

    private static VertexInfo parseVertexSpec(String spec, Vector vertex, Vector texture, Vector normal, int lineno) throws Exception {
        VertexInfo info = new VertexInfo();
        StringTokenizer st = new StringTokenizer(spec, "/", true);
        info.norm = Integer.MAX_VALUE;
        info.tex = Integer.MAX_VALUE;
        int i = 0;
        while (st.hasMoreTokens()) {
            String value = st.nextToken();
            if ("/".equals(value)) {
                ++i;
                continue;
            }
            try {
                int index = Integer.parseInt(value);
                int total = 0;
                total = i == 0 ? vertex.size() : (i == 1 ? texture.size() : normal.size());
                index = index < 0 ? (index += total) : --index;
                if (i == 0) {
                    info.vert = index;
                    continue;
                }
                if (i == 1) {
                    info.tex = index;
                    continue;
                }
                info.norm = index;
            }
            catch (NumberFormatException ex) {
                throw new Exception("Illegal value '" + spec + "' found in line " + lineno + ".");
            }
        }
        if (info.tex == Integer.MAX_VALUE) {
            info.tex = info.vert;
        }
        if (info.norm == Integer.MAX_VALUE) {
            info.norm = info.vert;
        }
        return info;
    }

    /*
     * WARNING - void declaration
     */
    private static void parseTextures(String file, File baseDir, Hashtable textures) throws Exception {
        String line;
        File f = new File(baseDir, file);
        if (!f.isFile()) {
            f = new File(file);
        }
        if (!f.isFile()) {
            throw new Exception("Cannot locate material file '" + file + "'.");
        }
        BufferedReader in = new BufferedReader(new FileReader(f));
        TextureInfo currentTexture = null;
        while ((line = in.readLine()) != null) {
            void var5_6;
            try {
                String[] fields;
                if (var5_6.startsWith("#") || (fields = OBJImporter.breakLine((String)var5_6)).length == 0) continue;
                if ("newmtl".equals(fields[0])) {
                    currentTexture = null;
                    if (fields.length == 1 || textures.get(fields[1]) != null) continue;
                    currentTexture = new TextureInfo();
                    currentTexture.name = fields[1];
                    textures.put(fields[1], currentTexture);
                }
                if (currentTexture == null || fields.length < 2) continue;
                if ("Kd".equals(fields[0])) {
                    currentTexture.diffuse = OBJImporter.parseColor(fields);
                    continue;
                }
                if ("Ka".equals(fields[0])) {
                    currentTexture.ambient = OBJImporter.parseColor(fields);
                    continue;
                }
                if ("Ks".equals(fields[0])) {
                    currentTexture.specular = OBJImporter.parseColor(fields);
                    continue;
                }
                if ("d".equals(fields[0]) || "Tr".equals(fields[0])) {
                    currentTexture.transparency = 1.0 - new Double(fields[1]);
                    continue;
                }
                if ("Ns".equals(fields[0])) {
                    currentTexture.shininess = new Double(fields[1]);
                    continue;
                }
                if ("map_Kd".equals(fields[0])) {
                    currentTexture.diffuseMap = fields[1];
                    continue;
                }
                if ("map_Ka".equals(fields[0])) {
                    currentTexture.ambientMap = fields[1];
                    continue;
                }
                if ("map_Ks".equals(fields[0])) {
                    currentTexture.specularMap = fields[1];
                    continue;
                }
                if ("map_d".equals(fields[0])) {
                    currentTexture.transparentMap = fields[1];
                    continue;
                }
                if (!"map_Bump".equals(fields[0])) continue;
                currentTexture.bumpMap = fields[1];
            }
            catch (Exception ex) {
                in.close();
                throw new Exception("Illegal line '" + (String)var5_6 + "' found in file '" + file + "'.");
            }
        }
        in.close();
    }

    private static Texture createTexture(TextureInfo info, Scene scene, String baseDir, Hashtable imageMaps, Frame parent) throws Exception {
        info.resolveColors();
        ImageMap diffuseMap = OBJImporter.loadMap(info.diffuseMap, scene, baseDir, imageMaps, parent);
        ImageMap specularMap = OBJImporter.loadMap(info.specularMap, scene, baseDir, imageMaps, parent);
        ImageMap transparentMap = OBJImporter.loadMap(info.transparentMap, scene, baseDir, imageMaps, parent);
        ImageMap bumpMap = OBJImporter.loadMap(info.bumpMap, scene, baseDir, imageMaps, parent);
        RGBColor transparentColor = new RGBColor(info.transparency, info.transparency, info.transparency);
        if (diffuseMap == null && specularMap == null && transparentMap == null && bumpMap == null) {
            UniformTexture tex = new UniformTexture();
            tex.diffuseColor = info.diffuse.duplicate();
            tex.specularColor = info.specular.duplicate();
            tex.transparentColor = transparentColor;
            tex.shininess = (float)info.specularity;
            tex.specularity = 0.0f;
            tex.roughness = info.roughness;
            tex.setName(info.name);
            scene.addTexture((Texture)tex);
            return tex;
        }
        ImageMapTexture tex = new ImageMapTexture();
        tex.diffuseColor = diffuseMap == null ? new ImageOrColor(info.diffuse) : new ImageOrColor(info.diffuse, diffuseMap);
        tex.specularColor = specularMap == null ? new ImageOrColor(info.specular) : new ImageOrColor(info.specular, specularMap);
        ImageOrColor imageOrColor = tex.transparentColor = transparentMap == null ? new ImageOrColor(transparentColor) : new ImageOrColor(transparentColor, transparentMap);
        if (bumpMap != null) {
            tex.bump = new ImageOrValue(1.0f, bumpMap, 0);
        }
        tex.shininess = new ImageOrValue((float)info.specularity);
        tex.specularity = new ImageOrValue(0.0f);
        tex.roughness = new ImageOrValue((float)info.roughness);
        tex.tileY = true;
        tex.tileX = true;
        tex.mirrorY = false;
        tex.mirrorX = false;
        tex.setName(info.name);
        scene.addTexture((Texture)tex);
        return tex;
    }

    private static ImageMap loadMap(String name, Scene scene, String baseDir, Hashtable imageMaps, Frame parent) throws Exception {
        if (name == null) {
            return null;
        }
        ImageMap map = (ImageMap)imageMaps.get(name);
        if (map != null) {
            return map;
        }
        File f = new File(baseDir, name);
        if (!f.isFile()) {
            f = new File(name);
        }
        if (!f.isFile()) {
            throw new Exception("Cannot locate image map file '" + name + "'.");
        }
        try {
            map = new ImageMap(parent, f.getAbsolutePath());
        }
        catch (InterruptedException ex) {
            throw new Exception("Unable to load image map file '" + f.getAbsolutePath() + "'.");
        }
        scene.addImage(map);
        imageMaps.put(name, map);
        return map;
    }

    private static RGBColor parseColor(String[] fields) throws NumberFormatException {
        if (fields.length < 4) {
            return null;
        }
        return new RGBColor(new Double(fields[1]).doubleValue(), new Double(fields[2]).doubleValue(), new Double(fields[3]).doubleValue());
    }

    private static class TextureInfo {
        public String name;
        public RGBColor ambient;
        public RGBColor diffuse;
        public RGBColor specular;
        public double shininess;
        public double transparency;
        public double specularity;
        public double roughness;
        public String ambientMap;
        public String diffuseMap;
        public String specularMap;
        public String transparentMap;
        public String bumpMap;

        private TextureInfo() {
        }

        public void resolveColors() {
            if (this.diffuse == null) {
                this.diffuse = new RGBColor(0.0, 0.0, 0.0);
            }
            if (this.ambient == null) {
                this.ambient = new RGBColor(0.0, 0.0, 0.0);
            }
            if (this.specular == null) {
                this.specular = new RGBColor(0.0, 0.0, 0.0);
            } else {
                this.specularity = 1.0;
            }
            this.diffuse.scale(1.0 - this.transparency);
            this.specular.scale(1.0 - this.transparency);
            this.roughness = 1.0 - (this.shininess - 1.0) / 128.0;
            if (this.roughness > 1.0) {
                this.roughness = 1.0;
            }
            this.checkColorRange(this.ambient);
            this.checkColorRange(this.diffuse);
            this.checkColorRange(this.specular);
        }

        private void checkColorRange(RGBColor c) {
            float r = c.getRed();
            float g = c.getGreen();
            float b = c.getBlue();
            if (r < 0.0f) {
                r = 0.0f;
            }
            if (r > 1.0f) {
                r = 1.0f;
            }
            if (g < 0.0f) {
                g = 0.0f;
            }
            if (g > 1.0f) {
                g = 1.0f;
            }
            if (b < 0.0f) {
                b = 0.0f;
            }
            if (b > 1.0f) {
                b = 1.0f;
            }
            c.setRGB(r, g, b);
        }
    }

    private static class FaceInfo {
        public VertexInfo v1;
        public VertexInfo v2;
        public VertexInfo v3;
        public int smoothingGroup;
        public String texture;

        public FaceInfo(VertexInfo v1, VertexInfo v2, VertexInfo v3, int smoothingGroup, String texture) {
            this.v1 = v1;
            this.v2 = v2;
            this.v3 = v3;
            this.smoothingGroup = smoothingGroup;
            this.texture = texture;
        }

        public VertexInfo getVertex(int which) {
            switch (which) {
                case 0: {
                    return this.v1;
                }
                case 1: {
                    return this.v2;
                }
            }
            return this.v3;
        }
    }

    private static class VertexInfo {
        public int vert;
        public int norm;
        public int tex;

        private VertexInfo() {
        }
    }
}

