/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Callback;
import artofillusion.CurveViewer;
import artofillusion.MeshEditorWindow;
import artofillusion.ModellingApp;
import artofillusion.MoveViewTool;
import artofillusion.ReshapeMeshTool;
import artofillusion.RotateMeshTool;
import artofillusion.RotateViewTool;
import artofillusion.ScaleMeshTool;
import artofillusion.SkewMeshTool;
import artofillusion.TaperMeshTool;
import artofillusion.UndoRecord;
import artofillusion.math.Vec3;
import artofillusion.object.Curve;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.MessageDialog;
import artofillusion.ui.ToolPalette;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueSlider;
import java.awt.BorderLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class CurveEditorWindow
extends MeshEditorWindow
implements EditingWindow,
KeyListener,
ActionListener,
ItemListener {
    Menu editMenu;
    Menu meshMenu;
    Menu smoothMenu;
    MenuItem[] editMenuItem;
    MenuItem[] meshMenuItem;
    CheckboxMenuItem[] smoothItem;
    Callback onClose;

    public CurveEditorWindow(EditingWindow parent, String title, ObjectInfo obj, Callback onClose) {
        super(parent, title, (Mesh)((Object)obj.object));
        ObjectInfo info = obj.duplicate();
        info.object = info.object.duplicate();
        this.onClose = onClose;
        this.helpText = new Label();
        this.add((Component)this.helpText, "South");
        Panel p1 = new Panel();
        this.add((Component)p1, "Center");
        p1.setLayout(new BorderLayout());
        Panel p2 = new Panel();
        p1.add((Component)p2, "North");
        p2.setLayout(new BorderLayout());
        Panel p3 = new Panel();
        p2.add((Component)p3, "West");
        this.theView = new CurveViewer(info, p3);
        p1.add((Component)this.theView, "Center");
        p3 = new Panel();
        p2.add((Component)p3, "East");
        p3.add(Translate.button("ok", this));
        p3.add(Translate.button("cancel", this));
        Panel p4 = new Panel();
        this.add((Component)p4, "West");
        p4.setLayout(new BorderLayout());
        this.tools = new ToolPalette(1, 7);
        p4.add((Component)this.tools, "North");
        this.defaultTool = new ReshapeMeshTool(this);
        this.tools.addTool(this.defaultTool);
        this.tools.addTool(new ScaleMeshTool(this));
        this.tools.addTool(new RotateMeshTool(this, false));
        this.tools.addTool(new SkewMeshTool(this));
        this.tools.addTool(new TaperMeshTool(this));
        MoveViewTool metaTool = new MoveViewTool(this);
        this.tools.addTool(metaTool);
        RotateViewTool altTool = new RotateViewTool(this);
        this.tools.addTool(altTool);
        this.tools.selectTool(this.defaultTool);
        this.theView.setMetaTool(metaTool);
        this.theView.setAltTool(altTool);
        this.theView.setMeshVisible(true);
        this.helpText.setBackground(ModellingApp.APP_BACKGROUND_COLOR);
        p2.setBackground(ModellingApp.APP_BACKGROUND_COLOR);
        p3.setBackground(ModellingApp.APP_BACKGROUND_COLOR);
        p4.setBackground(ModellingApp.APP_BACKGROUND_COLOR);
        this.menubar = new MenuBar();
        this.setMenuBar(this.menubar);
        this.createEditMenu();
        this.createMeshMenu((Curve)obj.object);
        this.createViewMenu();
        this.recursivelyAddListeners(this);
        this.oldMesh = (Curve)obj.object;
        this.pack();
        Dimension d1 = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d2 = new Dimension(d1.width * 2 / 3, d1.height * 2 / 3);
        ((Component)this).setSize(d2);
        ((Component)this).setLocation((d1.width - d2.width) / 2, (d1.height - d2.height) / 2);
        this.updateMenus();
    }

    protected CurveEditorWindow(EditingWindow parent, String title, Mesh obj) {
        super(parent, title, obj);
    }

    void createEditMenu() {
        this.editMenu = Translate.menu("edit");
        this.menubar.add(this.editMenu);
        this.editMenuItem = new MenuItem[2];
        this.undoItem = Translate.menuItem("undo", this);
        this.editMenu.add(this.undoItem);
        this.undoItem.setEnabled(false);
        this.editMenu.add(Translate.menuItem("selectAll", this));
        this.editMenuItem[0] = Translate.menuItem("extendSelection", this);
        this.editMenu.add(this.editMenuItem[0]);
        this.editMenuItem[1] = Translate.checkboxMenuItem("freehandSelection", this, false);
        this.editMenu.add(this.editMenuItem[1]);
        this.editMenu.addSeparator();
        this.editMenu.add(Translate.menuItem("curveTension", this));
    }

    void createMeshMenu(Curve obj) {
        this.meshMenu = Translate.menu("curve");
        this.menubar.add(this.meshMenu);
        this.meshMenuItem = new MenuItem[7];
        this.meshMenuItem[0] = Translate.menuItem("deletePoints", this);
        this.meshMenu.add(this.meshMenuItem[0]);
        this.meshMenuItem[1] = Translate.menuItem("subdivide", this);
        this.meshMenu.add(this.meshMenuItem[1]);
        this.meshMenuItem[2] = Translate.menuItem("editPoints", this);
        this.meshMenu.add(this.meshMenuItem[2]);
        this.meshMenuItem[3] = Translate.menuItem("transformPoints", this);
        this.meshMenu.add(this.meshMenuItem[3]);
        this.meshMenuItem[4] = Translate.menuItem("randomize", this);
        this.meshMenu.add(this.meshMenuItem[4]);
        this.meshMenu.add(Translate.menuItem("centerCurve", this));
        this.meshMenu.addSeparator();
        this.meshMenuItem[5] = Translate.menuItem("smoothness", this);
        this.meshMenu.add(this.meshMenuItem[5]);
        this.smoothMenu = Translate.menu("smoothingMethod");
        this.meshMenu.add(this.smoothMenu);
        this.smoothItem = new CheckboxMenuItem[3];
        this.smoothItem[0] = Translate.checkboxMenuItem("none", this, obj.getSmoothingMethod() == 0);
        this.smoothMenu.add(this.smoothItem[0]);
        this.smoothItem[1] = Translate.checkboxMenuItem("interpolating", this, obj.getSmoothingMethod() == 2);
        this.smoothMenu.add(this.smoothItem[1]);
        this.smoothItem[2] = Translate.checkboxMenuItem("approximating", this, obj.getSmoothingMethod() == 3);
        this.smoothMenu.add(this.smoothItem[2]);
        this.meshMenuItem[6] = Translate.menuItem("closedEnds", this);
        this.meshMenu.add(this.meshMenuItem[6]);
        if (obj.isClosed()) {
            this.meshMenuItem[6].setLabel(Translate.text("menu.openEnds"));
        }
    }

    protected Menu createShowMenu() {
        Menu menu = Translate.menu("show");
        this.showItem = new CheckboxMenuItem[4];
        this.showItem[0] = Translate.checkboxMenuItem("curve", this, true);
        menu.add(this.showItem[0]);
        this.showItem[3] = Translate.checkboxMenuItem("entireScene", this, this.theView.getSceneVisible());
        menu.add(this.showItem[3]);
        return menu;
    }

    public void setTool(EditingTool tool) {
        this.theView.setTool(tool);
        this.currentTool = tool;
    }

    public void updateMenus() {
        boolean[] selected = ((CurveViewer)this.theView).getSelection();
        int i = 0;
        while (i < selected.length && !selected[i]) {
            ++i;
        }
        if (i < selected.length) {
            this.editMenuItem[0].setEnabled(true);
            i = 0;
            while (i < 6) {
                this.meshMenuItem[i].setEnabled(true);
                ++i;
            }
        } else {
            this.editMenuItem[0].setEnabled(false);
            i = 0;
            while (i < 6) {
                this.meshMenuItem[i].setEnabled(false);
                ++i;
            }
        }
        this.templateItem.setEnabled(this.theView.getTemplateImage() != null);
    }

    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == 8 || code == 127) {
            this.deleteCommand();
        } else {
            super.keyPressed(e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (command.equals("ok")) {
            Curve theMesh = (Curve)this.theView.getObject().object;
            this.oldMesh.copyObject(theMesh);
            this.oldMesh = null;
            this.dispose();
            this.onClose.execute();
        } else if (command.equals("cancel")) {
            this.oldMesh = null;
            this.dispose();
        } else if (command.equals("undo")) {
            this.undoCommand();
        } else if (command.equals("selectAll")) {
            this.selectAllCommand();
        } else if (command.equals("extendSelection")) {
            this.extendSelectionCommand();
        } else if (command.equals("deletePoints")) {
            this.deleteCommand();
        } else if (command.equals("subdivide")) {
            this.subdivideCommand();
        } else if (command.equals("editPoints")) {
            this.setPointsCommand();
        } else if (command.equals("transformPoints")) {
            this.transformPointsCommand();
        } else if (command.equals("randomize")) {
            this.randomizeCommand();
        } else if (command.equals("centerCurve")) {
            this.centerCommand();
        } else if (command.equals("smoothness")) {
            this.setSmoothnessCommand();
        } else if (command.equals("curveTension")) {
            this.setTensionCommand();
        } else if (command.equals("closedEnds")) {
            this.toggleClosedCommand();
        } else if (command.equals("grid")) {
            this.setGridCommand();
        } else if (command.equals("showTemplate")) {
            boolean wasShown = this.theView.getTemplateShown();
            this.templateItem.setLabel(Translate.text(wasShown ? "menu.showTemplate" : "menu.hideTemplate"));
            this.theView.setShowTemplate(!wasShown);
            this.updateImage();
        } else if (command.equals("setTemplate")) {
            this.setTemplateCommand();
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.editMenuItem[1]) {
            ((CurveViewer)this.theView).setFreehandSelection(((CheckboxMenuItem)this.editMenuItem[1]).getState());
            return;
        }
        if (source == this.smoothItem[0]) {
            this.setSmoothingMethod(0);
        } else if (source == this.smoothItem[1]) {
            this.setSmoothingMethod(2);
        } else if (source == this.smoothItem[2]) {
            this.setSmoothingMethod(3);
        } else {
            super.itemStateChanged(e);
        }
    }

    void selectAllCommand() {
        boolean[] selected = ((CurveViewer)this.theView).getSelection();
        int i = 0;
        while (i < selected.length) {
            selected[i] = true;
            ++i;
        }
        ((CurveViewer)this.theView).setSelection(selected);
    }

    void extendSelectionCommand() {
        Curve theMesh = (Curve)this.theView.getObject().object;
        int oldDist = MeshEditorWindow.tensionDistance;
        MeshEditorWindow.tensionDistance = 1;
        int[] dist = ((CurveViewer)this.theView).getSelectionDistance();
        boolean[] selected = new boolean[dist.length];
        MeshEditorWindow.tensionDistance = oldDist;
        int i = 0;
        while (i < dist.length) {
            selected[i] = dist[i] == 0 || dist[i] == 1;
            ++i;
        }
        ((CurveViewer)this.theView).setSelection(selected);
    }

    void deleteCommand() {
        int num = 0;
        Curve theCurve = (Curve)this.theView.getObject().object;
        boolean[] selected = ((CurveViewer)this.theView).getSelection();
        MeshVertex[] vt = theCurve.getVertices();
        float[] s = theCurve.getSmoothness();
        int i = 0;
        while (i < selected.length) {
            if (selected[i]) {
                ++num;
            }
            ++i;
        }
        if (num == 0) {
            return;
        }
        if (!theCurve.isClosed() && selected.length - num < 2) {
            new MessageDialog((Frame)this, "A curve must have at least two points.");
            return;
        }
        if (theCurve.isClosed() && selected.length - num < 3) {
            new MessageDialog((Frame)this, "A closed curve must have at least three points.");
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theCurve, theCurve.duplicate()}));
        Vec3[] v = new Vec3[vt.length - num];
        float[] news = new float[vt.length - num];
        boolean[] newsel = new boolean[vt.length - num];
        i = 0;
        int j = 0;
        while (i < vt.length) {
            if (!selected[i]) {
                newsel[j] = selected[i];
                news[j] = s[i];
                v[j++] = vt[i].r;
            }
            ++i;
        }
        theCurve.setShape(v, news);
        ((CurveViewer)this.theView).setSelection(newsel);
    }

    void subdivideCommand() {
        Curve theCurve = (Curve)this.theView.getObject().object;
        MeshVertex[] vt = theCurve.getVertices();
        float[] s = theCurve.getSmoothness();
        boolean[] selected = ((CurveViewer)this.theView).getSelection();
        int splitcount = 0;
        int method = theCurve.getSmoothingMethod();
        Vec3[] v = new Vec3[vt.length];
        int i = 0;
        while (i < vt.length) {
            v[i] = vt[i].r;
            ++i;
        }
        boolean[] split = theCurve.isClosed() ? new boolean[vt.length] : new boolean[vt.length - 1];
        i = 0;
        while (i < split.length) {
            if (selected[i] && selected[(i + 1) % selected.length]) {
                split[i] = true;
                ++splitcount;
            }
            ++i;
        }
        Vec3[] newpos = new Vec3[vt.length + splitcount];
        float[] news = new float[vt.length + splitcount];
        boolean[] newsel = new boolean[vt.length + splitcount];
        i = 0;
        int j = 0;
        while (i < split.length) {
            newsel[j] = selected[i];
            int p1 = i - 1;
            if (p1 < 0) {
                p1 = theCurve.isClosed() ? v.length - 1 : 0;
            }
            int p3 = i < v.length - 1 ? i + 1 : (theCurve.isClosed() ? 0 : v.length - 1);
            newpos[j] = selected[i] && method == 3 ? Curve.calcApproxPoint(v, s, p1, i, p3) : vt[i].r;
            news[j] = selected[i] ? Math.min(s[i] * 2.0f, 1.0f) : s[i];
            if (!split[i]) {
                ++j;
            } else {
                if (method == 0) {
                    newpos[j + 1] = v[i].plus(v[p3]).times(0.5);
                } else if (method == 2) {
                    int p4 = i < v.length - 2 ? i + 2 : (theCurve.isClosed() ? (i + 2) % v.length : v.length - 1);
                    newpos[j + 1] = Curve.calcInterpPoint(v, s, p1, i, p3, p4);
                } else {
                    newpos[j + 1] = v[i].plus(v[p3]).times(0.5);
                }
                news[j + 1] = 1.0f;
                newsel[j + 1] = true;
                j += 2;
            }
            ++i;
        }
        if (!theCurve.isClosed()) {
            newpos[0] = v[0];
            newpos[j] = v[i];
            news[j] = s[i];
            newsel[j] = selected[i];
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theCurve, theCurve.duplicate()}));
        theCurve.setShape(newpos, news);
        ((CurveViewer)this.theView).setSelection(newsel);
    }

    void setSmoothnessCommand() {
        Curve theCurve = (Curve)this.theView.getObject().object;
        MeshVertex[] vt = theCurve.getVertices();
        boolean[] selected = ((CurveViewer)this.theView).getSelection();
        float[] s = theCurve.getSmoothness();
        int i = 0;
        while (i < selected.length && !selected[i]) {
            ++i;
        }
        if (i == selected.length) {
            return;
        }
        float value = 0.001f * (float)Math.round(s[i] * 1000.0f);
        ValueSlider smoothness = new ValueSlider(0.0, 1.0, 100, value);
        ComponentsDialog dlg = new ComponentsDialog((Frame)this, "Set Smoothness for Selected Points", new Component[]{smoothness}, new String[]{Translate.text("Smoothness")});
        if (!dlg.clickedOk()) {
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theCurve, theCurve.duplicate()}));
        float[] news = new float[vt.length];
        i = 0;
        while (i < selected.length) {
            news[i] = selected[i] ? (float)smoothness.getValue() : s[i];
            ++i;
        }
        theCurve.setSmoothness(news);
        this.theView.objectChanged();
        this.theView.updateImage();
        this.theView.repaint();
    }

    void setSmoothingMethod(int method) {
        Curve theCurve = (Curve)this.theView.getObject().object;
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theCurve, theCurve.duplicate()}));
        int i = 0;
        while (i < this.smoothItem.length) {
            this.smoothItem[i].setState(false);
            ++i;
        }
        if (method == 0) {
            this.smoothItem[0].setState(true);
        } else if (method == 2) {
            this.smoothItem[1].setState(true);
        } else {
            this.smoothItem[2].setState(true);
        }
        theCurve.setSmoothingMethod(method);
        this.theView.objectChanged();
        this.theView.updateImage();
        this.theView.repaint();
    }

    void toggleClosedCommand() {
        Curve theCurve = (Curve)this.theView.getObject().object;
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theCurve, theCurve.duplicate()}));
        if (theCurve.isClosed()) {
            theCurve.setClosed(false);
            this.meshMenuItem[6].setLabel(Translate.text("menu.closedEnds"));
        } else {
            theCurve.setClosed(true);
            this.meshMenuItem[6].setLabel(Translate.text("menu.openEnds"));
        }
        this.theView.setMesh(theCurve);
        this.theView.updateImage();
        this.theView.repaint();
    }

    public void adjustDeltas(Vec3[] delta) {
        int[] dist = this.theView.getSelectionDistance();
        int[] count = new int[delta.length];
        Curve theCurve = (Curve)this.theView.getObject().object;
        int maxDistance = MeshEditorWindow.getTensionDistance();
        double tension = MeshEditorWindow.getMeshTension();
        double[] scale = new double[maxDistance + 1];
        int i = 0;
        while (i < delta.length) {
            if (dist[i] != 0) {
                delta[i].set(0.0, 0.0, 0.0);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < maxDistance) {
            int j = 0;
            while (j < count.length) {
                count[j] = 0;
                ++j;
            }
            int j2 = 0;
            while (j2 < dist.length - 1) {
                if (dist[j2] == i2 && dist[j2 + 1] == i2 + 1) {
                    int n = j2 + 1;
                    count[n] = count[n] + 1;
                    delta[j2 + 1].add(delta[j2]);
                } else if (dist[j2 + 1] == i2 && dist[j2] == i2 + 1) {
                    int n = j2;
                    count[n] = count[n] + 1;
                    delta[j2].add(delta[j2 + 1]);
                }
                ++j2;
            }
            if (theCurve.isClosed()) {
                if (dist[0] == i2 && dist[dist.length - 1] == i2 + 1) {
                    int n = dist.length - 1;
                    count[n] = count[n] + 1;
                    delta[dist.length - 1].add(delta[0]);
                } else if (dist[dist.length - 1] == i2 && dist[0] == i2 + 1) {
                    count[0] = count[0] + 1;
                    delta[0].add(delta[dist.length - 1]);
                }
            }
            int j3 = 0;
            while (j3 < count.length) {
                if (count[j3] > 1) {
                    delta[j3].scale(1.0 / (double)count[j3]);
                }
                ++j3;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < scale.length) {
            scale[i3] = Math.pow(((double)(maxDistance - i3) + 1.0) / ((double)maxDistance + 1.0), tension);
            ++i3;
        }
        int i4 = 0;
        while (i4 < delta.length) {
            if (dist[i4] > 0) {
                delta[i4].scale(scale[dist[i4]]);
            }
            ++i4;
        }
    }
}

