/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.ModellingApp;
import artofillusion.Renderer;
import artofillusion.Scene;
import artofillusion.image.ImageAverager;
import artofillusion.image.ImageSaver;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SceneCamera;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ImageObserver;

public class RenderingDialog
extends Dialog
implements ActionListener,
ImageObserver {
    Canvas canvas;
    Image theImage;
    Renderer renderer;
    Scene theScene;
    ObjectInfo sceneCamera;
    Camera theCamera;
    double start;
    double end;
    double originalTime;
    ImageSaver imgsaver;
    ImageAverager imgaverager;
    Button closeButton;
    Button saveButton;
    Label label1;
    Label label2;
    Frame parent;
    int w;
    int h;
    int fps;
    int subimages;
    int currentFrame;
    int currentSubimage;
    int totalFrames;
    long startTime;
    boolean done;

    public RenderingDialog(Frame parent, Renderer rend, Scene sc, Camera cam, double depthOfField, double focalDist) {
        super(parent, true);
        this.parent = parent;
        this.renderer = rend;
        this.theScene = sc;
        this.layoutDialog(parent, cam);
        this.startTime = System.currentTimeMillis();
        rend.renderScene(sc, cam, this, depthOfField, focalDist);
        this.show();
    }

    public RenderingDialog(Frame parent, Renderer rend, Scene sc, Camera cam, ObjectInfo sceneCamera, double start, double end, int fps, int subimages, ImageSaver imgsaver) {
        super(parent, true);
        this.parent = parent;
        this.renderer = rend;
        this.theScene = sc;
        this.theCamera = cam;
        this.sceneCamera = sceneCamera;
        this.start = start;
        this.end = end;
        this.fps = fps;
        this.subimages = subimages;
        this.imgsaver = imgsaver;
        this.originalTime = this.theScene.getTime();
        this.totalFrames = (int)Math.ceil((end - start) * (double)fps);
        if (this.totalFrames <= 0) {
            this.totalFrames = 1;
        }
        if (subimages > 1) {
            this.imgaverager = new ImageAverager(this.theCamera.getSize().width, this.theCamera.getSize().height);
        }
        this.layoutDialog(parent, cam);
        this.startTime = System.currentTimeMillis();
        sc.setTime(start);
        this.theCamera.setCameraCoordinates(sceneCamera.coords.duplicate());
        SceneCamera scm = (SceneCamera)sceneCamera.object;
        this.theCamera.setDistToScreen((double)this.h / 200.0 / Math.tan(scm.getFieldOfView() * Math.PI / 360.0));
        rend.renderScene(sc, this.theCamera, this, scm.getDepthOfField(), scm.getFocalDistance());
        this.show();
    }

    private void layoutDialog(Frame parent, Camera cam) {
        Dimension dim = cam.getSize();
        this.w = dim.width;
        this.h = dim.height;
        this.setFont(parent.getFont());
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        c.anchor = 17;
        c.weightx = 1.0;
        c.gridx = 0;
        this.label1 = new Label(this.getStatusLabel());
        this.add((Component)this.label1, c);
        this.label2 = new Label("Elapsed Time: 0:00     ");
        this.add((Component)this.label2, c);
        c.fill = 2;
        c.weightx = 0.0;
        c.gridx = 1;
        this.closeButton = new Button("Cancel");
        this.add((Component)this.closeButton, c);
        this.saveButton = new Button("Save");
        this.add((Component)this.saveButton, c);
        this.saveButton.setVisible(false);
        this.closeButton.setActionCommand("close");
        this.closeButton.addActionListener(this);
        this.saveButton.setActionCommand("save");
        this.saveButton.addActionListener(this);
        c.gridx = 0;
        c.gridwidth = 2;
        ScrollPane sp = new ScrollPane();
        c.weighty = 1.0;
        c.fill = 1;
        this.add((Component)sp, c);
        Dimension screendim = Toolkit.getDefaultToolkit().getScreenSize();
        int sw = Math.min(this.w + sp.getVScrollbarWidth(), screendim.width - 50);
        int sh = Math.min(this.h + sp.getHScrollbarHeight(), screendim.height - 100);
        sp.setSize(sw, sh);
        this.canvas = new Canvas(){

            public void paint(Graphics g) {
                if (RenderingDialog.this.theImage != null) {
                    g.drawImage(RenderingDialog.this.theImage, 0, 0, this);
                }
            }

            public Dimension getPreferredSize() {
                return new Dimension(RenderingDialog.this.w, RenderingDialog.this.h);
            }
        };
        sp.add(this.canvas);
        this.pack();
        ModellingApp.centerWindow(this);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("close")) {
            this.done = true;
            this.renderer.cancelRendering(this.theScene);
            if (this.imgsaver != null) {
                this.theScene.setTime(this.originalTime);
                this.imgsaver.lastMovieImage();
            }
            this.dispose();
        } else if (command.equals("save")) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            ImageSaver saver = new ImageSaver(this.parent);
            if (saver.clickedOk()) {
                saver.saveImage(this.theImage);
            }
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if ((infoflags & 0x80) != 0) {
            this.dispose();
            return false;
        }
        this.theImage = img;
        if ((infoflags & 8) != 0) {
            this.canvas.repaint(x, y, width, height);
        }
        if ((infoflags & 0x20) != 0) {
            this.canvas.repaint();
            if (this.imgsaver != null) {
                this.nextFrame();
            }
            if (this.currentFrame == this.totalFrames) {
                this.done = true;
                if (this.imgsaver != null) {
                    this.imgsaver.lastMovieImage();
                }
                this.label1.setText("Done Rendering.");
                this.closeButton.setLabel("Close");
                this.saveButton.setVisible(this.imgsaver == null);
            }
            this.label1.invalidate();
            this.pack();
        }
        int dt = (int)((System.currentTimeMillis() - this.startTime) / 1000L);
        int min = dt / 60;
        int sec = dt - 60 * min;
        this.label2.setText("Elapsed Time: " + min + ":" + (sec < 10 ? "0" : "") + sec);
        return false;
    }

    private void nextFrame() {
        if (this.done) {
            return;
        }
        if (this.imgaverager != null) {
            this.imgaverager.addImage(this.theImage);
            ++this.currentSubimage;
            if (this.currentSubimage == this.subimages) {
                this.imgsaver.saveImage(this.imgaverager.getAverageImage());
                this.imgaverager.clear();
                this.currentSubimage = 0;
                ++this.currentFrame;
                if (this.currentFrame == this.totalFrames) {
                    return;
                }
            }
        } else {
            this.imgsaver.saveImage(this.theImage);
            ++this.currentFrame;
        }
        this.theScene.setTime(this.start + (double)(this.currentFrame * this.subimages + this.currentSubimage) / (double)(this.fps * this.subimages));
        this.theCamera.setCameraCoordinates(this.sceneCamera.coords.duplicate());
        SceneCamera scm = (SceneCamera)this.sceneCamera.object;
        this.theCamera.setDistToScreen((double)this.h / 200.0 / Math.tan(scm.getFieldOfView() * Math.PI / 360.0));
        this.renderer.renderScene(this.theScene, this.theCamera, this, scm.getDepthOfField(), scm.getFocalDistance());
        this.label1.setText(this.getStatusLabel());
        this.label1.invalidate();
        this.validate();
    }

    private String getStatusLabel() {
        if (this.imgsaver == null) {
            return "Rendering...";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("Rendering Frame ");
        buf.append(Integer.toString(this.currentFrame + 1));
        buf.append(" of ");
        buf.append(Integer.toString(this.totalFrames));
        if (this.subimages <= 1) {
            return buf.toString();
        }
        buf.append(", Subimage ");
        buf.append(Integer.toString(this.currentSubimage + 1));
        return buf.toString();
    }
}

