/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.MeshEditorWindow;
import artofillusion.MeshViewer;
import artofillusion.ObjectViewer;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class ReshapeMeshTool
extends EditingTool {
    boolean dragged;
    static Image icon;
    static Image selectedIcon;
    Point clickPoint;
    Vec3 clickPos;

    public ReshapeMeshTool(EditingWindow fr) {
        super(fr);
        icon = this.loadImage("movePoints.gif");
        selectedIcon = this.loadImage("selected/movePoints.gif");
    }

    public void activate() {
        super.activate();
        this.theWindow.setHelpText(Translate.text("reshapeMeshTool.helpText"));
    }

    public int whichClicks() {
        return 2;
    }

    public Image getIcon() {
        return icon;
    }

    public Image getSelectedIcon() {
        return selectedIcon;
    }

    public void mousePressedOnHandle(MouseEvent e, ViewerCanvas view, int obj, int handle) {
        Mesh mesh = (Mesh)((Object)((MeshViewer)view).getObject().object);
        MeshVertex[] v = mesh.getVertices();
        this.clickPoint = e.getPoint();
        this.clickPos = v[handle].r;
        this.dragged = false;
    }

    public void mouseDragged(MouseEvent e, ViewerCanvas view) {
        Mesh mesh = (Mesh)((Object)((MeshViewer)view).getObject().object);
        MeshVertex[] vert = mesh.getVertices();
        Graphics g = view.getGraphics();
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        int size = 5;
        int[] selectDist = ((MeshViewer)view).getSelectionDistance();
        if (this.dragged) {
            view.drawImage(g);
        }
        this.dragged = true;
        int dx = dragPoint.x - this.clickPoint.x;
        int dy = dragPoint.y - this.clickPoint.y;
        if (e.isShiftDown()) {
            if (Math.abs(dx) > Math.abs(dy)) {
                dy = 0;
            } else {
                dx = 0;
            }
        }
        Vec3[] v = this.findDraggedPositions(this.clickPos, vert, dx, dy, (MeshViewer)view, e.isControlDown());
        g.setColor(Color.gray);
        ((MeshViewer)view).drawDraggedSelection(g, cam, v);
        Vec3 drag = e.isControlDown() ? view.getCamera().getCameraCoordinates().getZDirection().times((double)(-dy) * 0.01) : view.getCamera().findDragVector(this.clickPos, dx, dy);
        this.theWindow.setHelpText(Translate.text("reshapeMeshTool.dragText", (double)Math.round(drag.x * 100000.0) / 100000.0 + ", " + (double)Math.round(drag.y * 100000.0) / 100000.0 + ", " + (double)Math.round(drag.z * 100000.0) / 100000.0));
        g.dispose();
    }

    public void mouseReleased(MouseEvent e, ViewerCanvas view) {
        Mesh mesh = (Mesh)((Object)((MeshViewer)view).getObject().object);
        MeshVertex[] vert = mesh.getVertices();
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        int dx = dragPoint.x - this.clickPoint.x;
        int dy = dragPoint.y - this.clickPoint.y;
        if (e.isShiftDown()) {
            if (Math.abs(dx) > Math.abs(dy)) {
                dy = 0;
            } else {
                dx = 0;
            }
        }
        if (dx != 0 || dy != 0) {
            this.theWindow.setUndoRecord(new UndoRecord(this.theWindow, false, 0, new Object[]{mesh, mesh.duplicate()}));
            Vec3[] v = this.findDraggedPositions(this.clickPos, vert, dx, dy, (MeshViewer)view, e.isControlDown());
            mesh.setVertices(v);
        }
        ((ObjectViewer)view).objectChanged();
        this.theWindow.updateImage();
        this.theWindow.setHelpText(Translate.text("reshapeMeshTool.helpText"));
    }

    public void keyPressed(KeyEvent e, ViewerCanvas view) {
        int dy;
        int dx;
        Mesh mesh = (Mesh)((Object)((MeshViewer)view).getObject().object);
        MeshVertex[] vert = mesh.getVertices();
        Camera cam = view.getCamera();
        int[] selectDist = ((MeshViewer)view).getSelectionDistance();
        int key = e.getKeyCode();
        if (key == 38) {
            dx = 0;
            dy = -1;
        } else if (key == 40) {
            dx = 0;
            dy = 1;
        } else if (key == 37) {
            dx = -1;
            dy = 0;
        } else if (key == 39) {
            dx = 1;
            dy = 0;
        } else {
            return;
        }
        int i = 0;
        while (i < vert.length && selectDist[i] != 0) {
            ++i;
        }
        if (i == vert.length) {
            return;
        }
        this.theWindow.setUndoRecord(new UndoRecord(this.theWindow, false, 0, new Object[]{mesh, mesh.duplicate()}));
        Vec3[] v = this.findDraggedPositions(vert[i].r, vert, dx, dy, (MeshViewer)view, e.isControlDown());
        mesh.setVertices(v);
        ((ObjectViewer)view).objectChanged();
        this.theWindow.updateImage();
    }

    Vec3[] findDraggedPositions(Vec3 pos, MeshVertex[] vert, int dx, int dy, MeshViewer view, boolean controlDown) {
        int maxDistance = MeshEditorWindow.getTensionDistance();
        double tension = MeshEditorWindow.getMeshTension();
        Vec3[] drag = new Vec3[maxDistance + 1];
        Vec3[] v = new Vec3[vert.length];
        int[] selectDist = view.getSelectionDistance();
        drag[0] = controlDown ? view.getCamera().getCameraCoordinates().getZDirection().times((double)(-dy) * 0.01) : view.getCamera().findDragVector(pos, dx, dy);
        int i = 1;
        while (i <= maxDistance) {
            drag[i] = drag[0].times(Math.pow(((double)(maxDistance - i) + 1.0) / ((double)maxDistance + 1.0), tension));
            ++i;
        }
        i = 0;
        while (i < vert.length) {
            v[i] = selectDist[i] > -1 ? vert[i].r.plus(drag[selectDist[i]]) : vert[i].r;
            ++i;
        }
        return v;
    }
}

