/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.LayoutWindow;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class RotateViewTool
extends EditingTool {
    static final double DRAG_SCALE = 0.01;
    static Image icon;
    static Image selectedIcon;
    Point clickPoint;
    Mat4 viewToWorld;
    boolean controlDown;
    CoordinateSystem oldCoords;

    public RotateViewTool(EditingWindow fr) {
        super(fr);
        if (icon == null) {
            icon = this.loadImage("rotateView.gif");
            selectedIcon = this.loadImage("selected/rotateView.gif");
        }
    }

    public void activate() {
        super.activate();
        this.theWindow.setHelpText(Translate.text("rotateViewTool.helpText"));
    }

    public int whichClicks() {
        return 0;
    }

    public boolean hilightSelection() {
        return !(this.theWindow instanceof LayoutWindow);
    }

    public Image getIcon() {
        return icon;
    }

    public Image getSelectedIcon() {
        return selectedIcon;
    }

    public void mousePressed(MouseEvent e, ViewerCanvas view) {
        Camera cam = view.getCamera();
        this.controlDown = e.isControlDown();
        this.clickPoint = e.getPoint();
        this.oldCoords = cam.getCameraCoordinates().duplicate();
        this.viewToWorld = cam.getViewToWorld();
    }

    public void mouseDragged(MouseEvent e, ViewerCanvas view) {
        double angle;
        Vec3 axis;
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        CoordinateSystem c = this.oldCoords.duplicate();
        int dx = dragPoint.x - this.clickPoint.x;
        int dy = dragPoint.y - this.clickPoint.y;
        if (this.controlDown) {
            axis = this.viewToWorld.timesDirection(Vec3.vz());
            angle = (double)dx * 0.01;
        } else if (e.isShiftDown()) {
            if (Math.abs(dx) > Math.abs(dy)) {
                axis = this.viewToWorld.timesDirection(Vec3.vy());
                angle = (double)dx * 0.01;
            } else {
                axis = this.viewToWorld.timesDirection(Vec3.vx());
                angle = (double)(-dy) * 0.01;
            }
        } else {
            axis = new Vec3((double)(-dy) * 0.01, (double)dx * 0.01, 0.0);
            angle = axis.length();
            axis = axis.times(1.0 / angle);
            axis = this.viewToWorld.timesDirection(axis);
        }
        if (angle != 0.0) {
            Mat4 m = Mat4.axisRotation(axis, -angle);
            c.transformCoordinates(m);
            cam.setCameraCoordinates(c);
            view.updateImage();
        }
        Graphics g = view.getGraphics();
        view.drawImage(g);
        g.dispose();
    }

    public void mouseReleased(MouseEvent e, ViewerCanvas view) {
        this.mouseDragged(e, view);
        Point dragPoint = e.getPoint();
        if (dragPoint.x != this.clickPoint.x || dragPoint.y != this.clickPoint.y) {
            view.orientationChanged();
        }
        if (this.theWindow != null) {
            this.theWindow.updateImage();
            ObjectInfo bound = view.getBoundCamera();
            if (bound != null) {
                this.theWindow.setUndoRecord(new UndoRecord(this.theWindow, false, 1, new Object[]{bound.coords, this.oldCoords}));
            }
        }
    }
}

