/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ModellingApp;
import artofillusion.ui.Translate;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class TransformDialog
extends Dialog
implements ActionListener,
FocusListener {
    private double[] initialValues;
    private double[] finalValues;
    private String[] initialStrings;
    private TextField[] fields;
    private Checkbox childrenBox;
    private Checkbox objectCenterBox;
    private Checkbox selectionCenterBox;
    private CheckboxGroup centerGroup;
    private boolean clicked;
    private boolean ok;
    private static boolean children = true;
    private static boolean selectionCenter = true;

    public TransformDialog(Frame parent, String title, double[] values, boolean transformLabels, boolean extraOptions) {
        super(parent, title, true);
        this.initialValues = values;
        this.initialStrings = new String[9];
        this.fields = new TextField[9];
        int i = 0;
        while (i < 9) {
            this.initialStrings[i] = this.numberToString(values[i]);
            ++i;
        }
        this.layoutDialog(transformLabels, extraOptions);
        this.pack();
        this.setResizable(false);
        ModellingApp.centerWindow(this);
        this.fields[0].requestFocus();
        this.show();
    }

    public TransformDialog(Frame parent, String title, boolean transformLabels, boolean extraOptions) {
        this(parent, title, new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN}, transformLabels, extraOptions);
    }

    public double[] getValues() {
        return this.finalValues;
    }

    public boolean clickedOk() {
        return this.ok;
    }

    public boolean applyToChildren() {
        return children;
    }

    public boolean useSelectionCenter() {
        return selectionCenter;
    }

    void layoutDialog(boolean transformLabels, boolean extraOptions) {
        Panel p = new Panel();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        c.anchor = 13;
        c.ipadx = 5;
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        if (transformLabels) {
            this.add((Component)new Label("Move"), c);
            c.gridy = -1;
            this.add((Component)new Label("Rotate"), c);
            this.add((Component)new Label("Scale"), c);
        } else {
            this.add((Component)new Label("Position"), c);
            c.gridy = -1;
            this.add((Component)new Label("Orientation"), c);
            this.add((Component)new Label("Size"), c);
        }
        c.anchor = 10;
        c.ipadx = 0;
        c.gridx = 1;
        c.gridy = 0;
        this.add((Component)new Label("        X        "), c);
        c.gridx = -1;
        this.add((Component)new Label("        Y        "), c);
        this.add((Component)new Label("        Z        "), c);
        c.fill = 2;
        c.gridy = 1;
        this.fields[0] = new TextField(this.initialStrings[0]);
        this.add((Component)this.fields[0], c);
        this.fields[1] = new TextField(this.initialStrings[1]);
        this.add((Component)this.fields[1], c);
        this.fields[2] = new TextField(this.initialStrings[2]);
        this.add((Component)this.fields[2], c);
        c.gridy = 2;
        this.fields[3] = new TextField(this.initialStrings[3]);
        this.add((Component)this.fields[3], c);
        this.fields[4] = new TextField(this.initialStrings[4]);
        this.add((Component)this.fields[4], c);
        this.fields[5] = new TextField(this.initialStrings[5]);
        this.add((Component)this.fields[5], c);
        c.gridy = 3;
        this.fields[6] = new TextField(this.initialStrings[6]);
        this.add((Component)this.fields[6], c);
        this.fields[7] = new TextField(this.initialStrings[7]);
        this.add((Component)this.fields[7], c);
        this.fields[8] = new TextField(this.initialStrings[8]);
        this.add((Component)this.fields[8], c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 4;
        if (extraOptions) {
            this.childrenBox = new Checkbox("Apply to unselected children of selected objects", children);
            this.add((Component)this.childrenBox, c);
            c.gridy = 5;
            this.add((Component)p, c);
            p.add(new Label("Rotate/Scale Around"));
            Panel panel = p;
            p = new Panel();
            panel.add(p);
            this.centerGroup = new CheckboxGroup();
            p.setLayout(new GridLayout(2, 1));
            this.objectCenterBox = new Checkbox("Individual Object Centers", !selectionCenter, this.centerGroup);
            p.add(this.objectCenterBox);
            this.selectionCenterBox = new Checkbox("Center of Selection", selectionCenter, this.centerGroup);
            p.add(this.selectionCenterBox);
            p = new Panel();
            c.gridy = 6;
        }
        this.add((Component)p, c);
        p.add(Translate.button("ok", this));
        p.add(Translate.button("cancel", this));
        MouseAdapter listen = new MouseAdapter(){

            public void mousePressed(MouseEvent ev) {
                TransformDialog.this.clicked = true;
            }
        };
        int i = 0;
        while (i < 9) {
            this.fields[i].addActionListener(this);
            this.fields[i].addFocusListener(this);
            this.fields[i].addMouseListener(listen);
            ++i;
        }
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        String[] finalStrings = new String[9];
        if (command.equals("cancel")) {
            this.finalValues = this.initialValues;
        } else {
            this.finalValues = new double[9];
            int i = 0;
            while (i < 9) {
                finalStrings[i] = this.fields[i].getText();
                try {
                    this.finalValues[i] = Double.valueOf(finalStrings[i]);
                    if (finalStrings[i].equals(this.initialStrings[i])) {
                        this.finalValues[i] = this.initialValues[i];
                    }
                }
                catch (NumberFormatException ex) {
                    this.finalValues[i] = Double.NaN;
                }
                ++i;
            }
            if (this.childrenBox != null) {
                children = this.childrenBox.getState();
            }
            if (this.centerGroup != null) {
                selectionCenter = this.centerGroup.getSelectedCheckbox() == this.selectionCenterBox;
            }
            this.ok = true;
        }
        this.dispose();
    }

    public void focusGained(FocusEvent e) {
        TextField t = (TextField)e.getSource();
        if (!this.clicked) {
            t.setSelectionStart(0);
            t.setSelectionEnd(t.getText().length());
        }
        this.clicked = false;
    }

    public void focusLost(FocusEvent e) {
        TextField t = (TextField)e.getSource();
        t.setSelectionStart(0);
        t.setSelectionEnd(0);
    }

    private String numberToString(double value) {
        String text;
        if (Double.isNaN(value)) {
            text = "";
        } else if (value == 0.0 || value == -0.0) {
            text = "0.0";
        } else {
            int digits = (int)Math.floor(Math.log(value) / Math.log(10.0));
            double scale = Math.pow(10.0, digits < 0 ? (double)(2 - digits) : 3.0);
            text = Double.toString((double)Math.round(value * scale) / scale);
        }
        return text;
    }
}

