/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ModellingApp;
import artofillusion.ui.Translate;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class TransformPointsDialog
extends Dialog
implements ActionListener,
FocusListener {
    double[] finalValues;
    TextField[] fields = new TextField[9];
    Choice centerChoice;
    boolean clicked;

    public TransformPointsDialog(Frame parent) {
        super(parent, "Transform Points", true);
        this.layoutDialog();
        this.pack();
        this.setResizable(false);
        ModellingApp.centerWindow(this);
        this.fields[0].requestFocus();
        this.show();
    }

    public double[] getValues() {
        return this.finalValues;
    }

    public boolean useSelectionCenter() {
        return this.centerChoice.getSelectedIndex() == 0;
    }

    void layoutDialog() {
        Panel p = new Panel();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        c.anchor = 13;
        c.ipadx = 5;
        c.gridx = 0;
        c.gridy = 1;
        this.add((Component)new Label("Move"), c);
        c.gridy = -1;
        this.add((Component)new Label("Rotate"), c);
        this.add((Component)new Label("Scale"), c);
        c.anchor = 10;
        c.ipadx = 0;
        c.gridx = 1;
        c.gridy = 0;
        this.add((Component)new Label("        X        "), c);
        c.gridx = -1;
        this.add((Component)new Label("        Y        "), c);
        this.add((Component)new Label("        Z        "), c);
        c.fill = 2;
        c.gridy = 1;
        c.weightx = 1.0;
        this.fields[0] = new TextField("");
        this.add((Component)this.fields[0], c);
        this.fields[1] = new TextField("");
        this.add((Component)this.fields[1], c);
        this.fields[2] = new TextField("");
        this.add((Component)this.fields[2], c);
        c.gridy = 2;
        this.fields[3] = new TextField("");
        this.add((Component)this.fields[3], c);
        this.fields[4] = new TextField("");
        this.add((Component)this.fields[4], c);
        this.fields[5] = new TextField("");
        this.add((Component)this.fields[5], c);
        c.gridy = 3;
        this.fields[6] = new TextField("");
        this.add((Component)this.fields[6], c);
        this.fields[7] = new TextField("");
        this.add((Component)this.fields[7], c);
        this.fields[8] = new TextField("");
        this.add((Component)this.fields[8], c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 5;
        this.add((Component)p, c);
        p.add(new Label("Transform Around"));
        this.centerChoice = new Choice();
        p.add(this.centerChoice);
        this.centerChoice.add("Selection Center");
        this.centerChoice.add("Object Origin");
        c.gridy = 5;
        p = new Panel();
        this.add((Component)p, c);
        p.add(Translate.button("ok", this));
        p.add(Translate.button("cancel", this));
        MouseAdapter listen = new MouseAdapter(){

            public void mousePressed(MouseEvent ev) {
                TransformPointsDialog.this.clicked = true;
            }
        };
        int i = 0;
        while (i < 9) {
            this.fields[i].addActionListener(this);
            this.fields[i].addFocusListener(this);
            this.fields[i].addMouseListener(listen);
            ++i;
        }
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        String[] finalStrings = new String[9];
        if (!command.equals("cancel")) {
            this.finalValues = new double[9];
            int i = 0;
            while (i < 9) {
                try {
                    this.finalValues[i] = Double.valueOf(this.fields[i].getText());
                }
                catch (NumberFormatException ex) {
                    this.finalValues[i] = i < 6 ? 0.0 : 1.0;
                }
                ++i;
            }
        }
        this.dispose();
    }

    public void focusGained(FocusEvent e) {
        TextField t = (TextField)e.getSource();
        if (!this.clicked) {
            t.setSelectionStart(0);
            t.setSelectionEnd(t.getText().length());
        }
        this.clicked = false;
    }

    public void focusLost(FocusEvent e) {
        TextField t = (TextField)e.getSource();
        t.setSelectionStart(0);
        t.setSelectionEnd(0);
    }
}

