/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.LayoutWindow;
import artofillusion.ModellingApp;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.animation.ObjectRef;
import artofillusion.animation.ObjectRefSelector;
import artofillusion.animation.Track;
import artofillusion.animation.WeightTrack;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import java.awt.CardLayout;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class ConstraintTrack
extends Track {
    ObjectInfo info;
    int xType;
    int yType;
    int zType;
    int orientType;
    int orientMode;
    ObjectRef faceToward;
    Vec3 pos;
    Vec3 orient;
    WeightTrack theWeight;
    private static final int NONE = 0;
    private static final int LESS_THAN = 1;
    private static final int EQUAL_TO = 2;
    private static final int GREATER_THAN = 3;
    private static final int FORCE_X = 1;
    private static final int FORCE_Y = 2;
    private static final int FORCE_Z = 3;
    private static final int PARALLEL = 0;
    private static final int PERPENDICULAR = 1;
    private static final int FACES_OBJECT = 2;

    public ConstraintTrack(ObjectInfo info) {
        super("Constraint");
        this.info = info;
        this.theWeight = new WeightTrack(this);
        this.orientType = 0;
        this.zType = 0;
        this.yType = 0;
        this.xType = 0;
        this.orientMode = 0;
        this.faceToward = new ObjectRef();
        this.pos = new Vec3();
        this.orient = Vec3.vx();
    }

    public void edit(LayoutWindow win) {
        new Editor(win);
    }

    public void apply(double time) {
        double weight = this.theWeight.getWeight(time);
        Vec3 v = this.info.coords.getOrigin();
        v.x = this.findCoordinate(v.x, this.pos.x, this.xType, weight);
        v.y = this.findCoordinate(v.y, this.pos.y, this.yType, weight);
        v.z = this.findCoordinate(v.z, this.pos.z, this.zType, weight);
        if (this.orientType != 0) {
            Vec3 zdir = this.info.coords.getZDirection();
            Vec3 ydir = this.info.coords.getUpDirection();
            Vec3 xdir = ydir.cross(zdir);
            if (this.orientType == 1) {
                this.adjustAxes(xdir, ydir, zdir);
            } else if (this.orientType == 2) {
                this.adjustAxes(ydir, zdir, xdir);
            } else {
                this.adjustAxes(zdir, xdir, ydir);
            }
            this.info.coords.setOrientation(zdir, ydir);
        }
        this.info.coords.setOrigin(v);
    }

    private double findCoordinate(double current, double con, int type, double weight) {
        if (type == 0) {
            return current;
        }
        if (type == 3 && current > con) {
            con = current;
        } else if (type == 1 && current < con) {
            con = current;
        }
        return (1.0 - weight) * current + weight * con;
    }

    private void adjustAxes(Vec3 xdir, Vec3 ydir, Vec3 zdir) {
        Vec3 v;
        if (this.orientMode == 2) {
            CoordinateSystem target = this.faceToward.getCoords();
            if (target == null) {
                return;
            }
            v = target.getOrigin().minus(this.info.coords.getOrigin());
        } else {
            v = new Vec3(this.orient);
        }
        double len = v.length();
        if (len == 0.0) {
            return;
        }
        v.scale(1.0 / len);
        if (this.orientMode == 1) {
            double dot = xdir.dot(v);
            xdir.subtract(v.times(dot));
            xdir.normalize();
        } else {
            xdir.set(v);
        }
        zdir.set(xdir.cross(ydir));
        ydir.set(zdir.cross(xdir));
        zdir.normalize();
        ydir.normalize();
    }

    public Track duplicate(Object obj) {
        ConstraintTrack t = new ConstraintTrack((ObjectInfo)obj);
        t.xType = this.xType;
        t.yType = this.yType;
        t.zType = this.zType;
        t.orientType = this.orientType;
        t.orientMode = this.orientMode;
        t.pos = new Vec3(this.pos);
        t.orient = new Vec3(this.orient);
        t.faceToward = this.faceToward.duplicate();
        t.theWeight = (WeightTrack)this.theWeight.duplicate(t);
        return t;
    }

    public void copy(Track tr) {
        ConstraintTrack t = (ConstraintTrack)tr;
        this.xType = t.xType;
        this.yType = t.yType;
        this.zType = t.zType;
        this.orientType = t.orientType;
        this.orientMode = t.orientMode;
        this.pos = new Vec3(t.pos);
        this.orient = new Vec3(t.orient);
        this.faceToward.copy(t.faceToward);
        this.theWeight = (WeightTrack)t.theWeight.duplicate(t);
    }

    public double[] getKeyTimes() {
        return new double[0];
    }

    public int moveKeyframe(int which, double time) {
        return -1;
    }

    public void deleteKeyframe(int which) {
    }

    public boolean isNullTrack() {
        return false;
    }

    public Track[] getSubtracks() {
        return new Track[]{this.theWeight};
    }

    public boolean canAcceptAsParent(Object obj) {
        return obj instanceof ObjectInfo;
    }

    public Object getParent() {
        return this.info;
    }

    public void setParent(Object obj) {
        this.info = (ObjectInfo)obj;
    }

    public ObjectInfo[] getDependencies() {
        ObjectInfo info;
        if (this.orientType != 0 && this.orientMode == 2 && (info = this.faceToward.getObject()) != null) {
            return new ObjectInfo[]{info};
        }
        return new ObjectInfo[0];
    }

    public void deleteDependencies(ObjectInfo obj) {
        if (this.faceToward.getObject() == obj) {
            this.faceToward = new ObjectRef();
        }
    }

    public void writeToStream(DataOutputStream out, Scene scene) throws IOException {
        out.writeShort(0);
        out.writeUTF(this.name);
        out.writeBoolean(this.enabled);
        out.writeInt(this.xType);
        out.writeInt(this.yType);
        out.writeInt(this.zType);
        out.writeInt(this.orientType);
        out.writeInt(this.orientMode);
        this.pos.writeToFile(out);
        this.orient.writeToFile(out);
        if (this.orientType != 0 && this.orientMode == 2) {
            this.faceToward.writeToStream(out);
        }
        this.theWeight.writeToStream(out, scene);
    }

    public ConstraintTrack(DataInputStream in, Object parent, Scene scene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.name = in.readUTF();
        this.enabled = in.readBoolean();
        this.xType = in.readInt();
        this.yType = in.readInt();
        this.zType = in.readInt();
        this.orientType = in.readInt();
        this.orientMode = in.readInt();
        this.pos = new Vec3(in);
        this.orient = new Vec3(in);
        this.faceToward = this.orientType != 0 && this.orientMode == 2 ? new ObjectRef(in, scene) : new ObjectRef();
        this.info = (ObjectInfo)parent;
        this.theWeight = new WeightTrack(in, this, scene);
    }

    private class Editor
    extends Dialog
    implements ActionListener,
    ItemListener {
        LayoutWindow window;
        Choice xChoice;
        Choice yChoice;
        Choice zChoice;
        Choice orientChoice;
        Choice orientModeChoice;
        ValueField xField;
        ValueField yField;
        ValueField zField;
        ValueField orientXField;
        ValueField orientYField;
        ValueField orientZField;
        Panel orientPanel;
        ObjectRefSelector objSelector;
        CardLayout orientPanelLayout;
        TextField nameField;

        public Editor(LayoutWindow win) {
            super(win, "Constraint Track", true);
            this.window = win;
            this.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridx = 0;
            gc.anchor = 13;
            gc.insets.right = 5;
            this.add((Component)new Label("Track Name:"), gc);
            this.add((Component)new Label("X Constraint:"), gc);
            this.add((Component)new Label("Y Constraint:"), gc);
            this.add((Component)new Label("Z Constraint:"), gc);
            this.add((Component)new Label("Orientation:"), gc);
            gc.gridx = 1;
            gc.anchor = 17;
            gc.gridwidth = 2;
            this.nameField = new TextField(ConstraintTrack.this.getName(), 30);
            this.add((Component)this.nameField, gc);
            gc.gridwidth = 1;
            gc.fill = 2;
            this.xChoice = new Choice();
            this.add((Component)this.xChoice, gc);
            this.xChoice.add("None");
            this.xChoice.add("Less Than");
            this.xChoice.add("Equal To");
            this.xChoice.add("Greater Than");
            this.xChoice.select(ConstraintTrack.this.xType);
            this.xChoice.addItemListener(this);
            this.yChoice = new Choice();
            this.add((Component)this.yChoice, gc);
            this.yChoice.add("None");
            this.yChoice.add("Less Than");
            this.yChoice.add("Equal To");
            this.yChoice.add("Greater Than");
            this.yChoice.select(ConstraintTrack.this.yType);
            this.yChoice.addItemListener(this);
            this.zChoice = new Choice();
            this.add((Component)this.zChoice, gc);
            this.zChoice.add("None");
            this.zChoice.add("Less Than");
            this.zChoice.add("Equal To");
            this.zChoice.add("Greater Than");
            this.zChoice.select(ConstraintTrack.this.zType);
            this.zChoice.addItemListener(this);
            this.orientChoice = new Choice();
            this.add((Component)this.orientChoice, gc);
            this.orientChoice.add("None");
            this.orientChoice.add("X Axis");
            this.orientChoice.add("Y Axis");
            this.orientChoice.add("Z Axis");
            this.orientChoice.select(ConstraintTrack.this.orientType);
            this.orientChoice.addItemListener(this);
            gc.gridx = 2;
            gc.gridy = 1;
            gc.fill = 0;
            this.xField = new ValueField(ConstraintTrack.this.pos.x, 0, 5);
            this.add((Component)this.xField, gc);
            gc.gridy = -1;
            this.yField = new ValueField(ConstraintTrack.this.pos.y, 0, 5);
            this.add((Component)this.yField, gc);
            this.zField = new ValueField(ConstraintTrack.this.pos.z, 0, 5);
            this.add((Component)this.zField, gc);
            this.orientModeChoice = new Choice();
            this.add((Component)this.orientModeChoice, gc);
            this.orientModeChoice.add("Parallel To");
            this.orientModeChoice.add("Perpendicular To");
            this.orientModeChoice.add("Faces Toward");
            this.orientModeChoice.select(ConstraintTrack.this.orientMode);
            this.orientModeChoice.addItemListener(this);
            gc.gridx = 1;
            gc.gridwidth = 2;
            this.orientPanel = new Panel();
            this.add((Component)this.orientPanel, gc);
            this.orientPanelLayout = new CardLayout();
            this.orientPanel.setLayout(this.orientPanelLayout);
            Panel p = new Panel();
            this.orientPanel.add((Component)p, "dir");
            p.add(new Label("X"));
            this.orientXField = new ValueField(ConstraintTrack.this.orient.x, 0, 5);
            p.add(this.orientXField);
            p.add(new Label("Y"));
            this.orientYField = new ValueField(ConstraintTrack.this.orient.y, 0, 5);
            p.add(this.orientYField);
            p.add(new Label("Z"));
            this.orientZField = new ValueField(ConstraintTrack.this.orient.z, 0, 5);
            p.add(this.orientZField);
            this.objSelector = new ObjectRefSelector(ConstraintTrack.this.faceToward, win, "Axis Faces Toward:", ConstraintTrack.this.info);
            this.orientPanel.add((Component)this.objSelector, "obj");
            gc.gridx = 0;
            gc.gridwidth = 3;
            gc.weighty = 0.0;
            gc.insets.right = 0;
            p = new Panel();
            p.add(Translate.button("ok", this));
            p.add(Translate.button("cancel", this));
            gc.anchor = 10;
            this.add((Component)p, gc);
            this.pack();
            ModellingApp.centerWindow(this);
            this.updateComponents();
            this.show();
        }

        public void actionPerformed(ActionEvent ev) {
            String command = ev.getActionCommand();
            if ("ok".equals(command)) {
                this.window.setUndoRecord(new UndoRecord(this.window, false, 2, new Object[]{ConstraintTrack.this.info, ConstraintTrack.this.info.duplicate()}));
                ConstraintTrack.this.setName(this.nameField.getText());
                ConstraintTrack.this.xType = this.xChoice.getSelectedIndex();
                ConstraintTrack.this.yType = this.yChoice.getSelectedIndex();
                ConstraintTrack.this.zType = this.zChoice.getSelectedIndex();
                ConstraintTrack.this.orientType = this.orientChoice.getSelectedIndex();
                ConstraintTrack.this.orientMode = this.orientModeChoice.getSelectedIndex();
                ConstraintTrack.this.pos.set(this.xField.getValue(), this.yField.getValue(), this.zField.getValue());
                ConstraintTrack.this.orient.set(this.orientXField.getValue(), this.orientYField.getValue(), this.orientZField.getValue());
                ConstraintTrack.this.faceToward = this.objSelector.getSelection();
                this.window.getScore().repaintAll();
            }
            this.dispose();
        }

        private void updateComponents() {
            this.xField.setEnabled(this.xChoice.getSelectedIndex() > 0);
            this.yField.setEnabled(this.yChoice.getSelectedIndex() > 0);
            this.zField.setEnabled(this.zChoice.getSelectedIndex() > 0);
            boolean orientEnabled = this.orientChoice.getSelectedIndex() > 0;
            this.orientXField.setEnabled(orientEnabled);
            this.orientYField.setEnabled(orientEnabled);
            this.orientZField.setEnabled(orientEnabled);
            this.objSelector.setEnabled(orientEnabled);
            this.orientModeChoice.setEnabled(orientEnabled);
            if (this.orientModeChoice.getSelectedIndex() == 2) {
                this.orientPanelLayout.last(this.orientPanel);
            } else {
                this.orientPanelLayout.first(this.orientPanel);
            }
            this.orientPanel.repaint();
        }

        public void itemStateChanged(ItemEvent ev) {
            this.updateComponents();
        }
    }
}

