/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation.distortion;

import artofillusion.animation.distortion.Distortion;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.procedural.OutputModule;
import artofillusion.procedural.PointInfo;
import artofillusion.procedural.Procedure;

public class CustomDistortion
implements Distortion {
    private Procedure proc;
    private int procVersion;
    PointInfo point;
    private double weight;
    private Mat4 preTransform;
    private Mat4 postTransform;
    private Distortion previous;

    public CustomDistortion(Procedure proc, int procVersion, PointInfo point, double weight, Mat4 preTransform, Mat4 postTransform) {
        this.proc = proc;
        this.procVersion = procVersion;
        this.point = point;
        this.weight = weight;
        this.preTransform = preTransform;
        this.postTransform = postTransform;
    }

    public void setPreviousDistortion(Distortion previous) {
        this.previous = previous;
    }

    public boolean isIdenticalTo(Distortion d) {
        if (!(d instanceof CustomDistortion)) {
            return false;
        }
        CustomDistortion s = (CustomDistortion)d;
        if (this.previous != null && !this.previous.isIdenticalTo(s.previous)) {
            return false;
        }
        if (this.previous == null && s.previous != null) {
            return false;
        }
        if (this.weight != s.weight || this.proc != s.proc || this.procVersion != s.procVersion) {
            return false;
        }
        if (this.point.t != s.point.t) {
            return false;
        }
        if (this.point.param == null) {
            if (s.point.param != null) {
                return false;
            }
        } else {
            if (s.point.param == null || this.point.param.length != s.point.param.length) {
                return false;
            }
            int i = 0;
            while (i < this.point.param.length) {
                if (this.point.param[i] != s.point.param[i]) {
                    return false;
                }
                ++i;
            }
        }
        if (this.preTransform == s.preTransform && this.postTransform == s.postTransform) {
            return true;
        }
        return this.preTransform != null && this.preTransform.equals(s.preTransform) && this.postTransform != null && this.postTransform.equals(s.postTransform);
    }

    public Distortion duplicate() {
        CustomDistortion d = new CustomDistortion(this.proc, this.procVersion, this.point, this.weight, this.preTransform, this.postTransform);
        if (this.previous != null) {
            d.previous = this.previous.duplicate();
        }
        return d;
    }

    public Mesh transform(Mesh obj) {
        if (this.previous != null) {
            obj = this.previous.transform(obj);
        }
        Mesh newmesh = (Mesh)((Object)obj.duplicate());
        MeshVertex[] vert = newmesh.getVertices();
        Vec3[] newvert = new Vec3[vert.length];
        OutputModule[] output = this.proc.getOutputModules();
        double w2 = 1.0 - this.weight;
        int i = 0;
        while (i < newvert.length) {
            newvert[i] = vert[i].r;
            if (this.preTransform != null) {
                this.preTransform.transform(newvert[i]);
            }
            this.point.x = newvert[i].x;
            this.point.y = newvert[i].y;
            this.point.z = newvert[i].z;
            this.proc.initForPoint(this.point);
            if (output[0].inputConnected(0)) {
                newvert[i].x = this.weight * output[0].getAverageValue(0, 0.0) + w2 * newvert[i].x;
            }
            if (output[1].inputConnected(0)) {
                newvert[i].y = this.weight * output[1].getAverageValue(0, 0.0) + w2 * newvert[i].y;
            }
            if (output[2].inputConnected(0)) {
                newvert[i].z = this.weight * output[2].getAverageValue(0, 0.0) + w2 * newvert[i].z;
            }
            if (this.postTransform != null) {
                this.postTransform.transform(newvert[i]);
            }
            ++i;
        }
        newmesh.setVertices(newvert);
        return newmesh;
    }
}

