/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.material;

import artofillusion.MaterialPreviewer;
import artofillusion.material.Material;
import artofillusion.material.Material3D;
import artofillusion.material.MaterialMapping;
import artofillusion.material.MaterialSpec;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.object.Object3D;
import artofillusion.ui.ValueField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class LinearMaterialMapping
extends MaterialMapping {
    CoordinateSystem coords;
    double ax;
    double bx;
    double cx;
    double dx;
    double ay;
    double by;
    double cy;
    double dy;
    double az;
    double bz;
    double cz;
    double dz;
    double xscale;
    double yscale;
    double zscale;
    double matScaleX;
    double matScaleY;
    double matScaleZ;

    public LinearMaterialMapping(Material3D theMaterial) {
        super(theMaterial);
        this.coords = new CoordinateSystem(new Vec3(), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 1.0, 0.0));
        this.zscale = 1.0;
        this.yscale = 1.0;
        this.xscale = 1.0;
        this.dz = 0.0;
        this.dy = 0.0;
        this.dx = 0.0;
        this.findCoefficients();
    }

    public static String getName() {
        return "Linear";
    }

    public static boolean legalMapping(Object3D obj, Material mat) {
        return mat instanceof Material3D;
    }

    void findCoefficients() {
        Vec3 zdir = this.coords.getZDirection();
        Vec3 ydir = this.coords.getUpDirection();
        Vec3 xdir = ydir.cross(zdir);
        this.ax = xdir.x / this.xscale;
        this.bx = xdir.y / this.xscale;
        this.cx = xdir.z / this.xscale;
        this.ay = ydir.x / this.yscale;
        this.by = ydir.y / this.yscale;
        this.cy = ydir.z / this.yscale;
        this.az = zdir.x / this.zscale;
        this.bz = zdir.y / this.zscale;
        this.cz = zdir.z / this.zscale;
        this.matScaleX = 1.0 / this.xscale;
        this.matScaleY = 1.0 / this.yscale;
        this.matScaleZ = 1.0 / this.zscale;
    }

    public double getStepSize() {
        return this.material.getStepSize() * Math.min(Math.min(this.matScaleX, this.matScaleY), this.matScaleZ);
    }

    public void getMaterialSpec(Vec3 pos, MaterialSpec spec, double size, double time) {
        ((Material3D)this.material).getMaterialSpec(spec, pos.x * this.ax + pos.y * this.bx + pos.z * this.cx - this.dx, pos.x * this.ay + pos.y * this.by + pos.z * this.cy - this.dy, pos.x * this.az + pos.y * this.bz + pos.z * this.cz - this.dz, size * this.matScaleX, size * this.matScaleY, size * this.matScaleZ, time);
    }

    public MaterialMapping duplicate() {
        return this.duplicate(this.material);
    }

    public MaterialMapping duplicate(Material mat) {
        LinearMaterialMapping map = new LinearMaterialMapping((Material3D)mat);
        map.coords = this.coords.duplicate();
        map.dx = this.dx;
        map.dy = this.dy;
        map.dz = this.dz;
        map.xscale = this.xscale;
        map.yscale = this.yscale;
        map.zscale = this.zscale;
        map.findCoefficients();
        return map;
    }

    public void copy(MaterialMapping mapping) {
        LinearMaterialMapping map = (LinearMaterialMapping)mapping;
        this.coords = map.coords.duplicate();
        this.dx = map.dx;
        this.dy = map.dy;
        this.dz = map.dz;
        this.xscale = map.xscale;
        this.yscale = map.yscale;
        this.zscale = map.zscale;
        this.findCoefficients();
    }

    public Panel getEditingPanel(Object3D obj, MaterialPreviewer preview) {
        return new Editor(obj, preview);
    }

    public LinearMaterialMapping(DataInputStream in, Material theMaterial) throws IOException, InvalidObjectException {
        super(theMaterial);
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.coords = new CoordinateSystem(in);
        this.dx = in.readDouble();
        this.dy = in.readDouble();
        this.dz = in.readDouble();
        this.xscale = in.readDouble();
        this.yscale = in.readDouble();
        this.zscale = in.readDouble();
        this.findCoefficients();
    }

    public void writeToFile(DataOutputStream out) throws IOException {
        out.writeShort(0);
        this.coords.writeToFile(out);
        out.writeDouble(this.dx);
        out.writeDouble(this.dy);
        out.writeDouble(this.dz);
        out.writeDouble(this.xscale);
        out.writeDouble(this.yscale);
        out.writeDouble(this.zscale);
    }

    class Editor
    extends Panel
    implements TextListener {
        ValueField xrotField;
        ValueField yrotField;
        ValueField zrotField;
        ValueField xscaleField;
        ValueField yscaleField;
        ValueField zscaleField;
        ValueField xtransField;
        ValueField ytransField;
        ValueField ztransField;
        Object3D theObject;
        MaterialPreviewer preview;

        public Editor(Object3D obj, MaterialPreviewer preview) {
            this.theObject = obj;
            this.preview = preview;
            GridBagConstraints gc = new GridBagConstraints();
            this.setLayout(new GridBagLayout());
            gc.gridwidth = 6;
            gc.insets = new Insets(0, 0, 0, 5);
            gc.gridy = 0;
            this.add((Component)new Label("Scale:"), gc);
            gc.gridwidth = 1;
            gc.gridy = 1;
            this.add((Component)new Label("X"), gc);
            this.xscaleField = new ValueField((double)Math.round(LinearMaterialMapping.this.xscale * 1000.0) / 1000.0, 2, 5);
            this.add((Component)this.xscaleField, gc);
            this.add((Component)new Label("Y"), gc);
            this.yscaleField = new ValueField((double)Math.round(LinearMaterialMapping.this.yscale * 1000.0) / 1000.0, 2, 5);
            this.add((Component)this.yscaleField, gc);
            this.add((Component)new Label("Z"), gc);
            this.zscaleField = new ValueField((double)Math.round(LinearMaterialMapping.this.zscale * 1000.0) / 1000.0, 2, 5);
            this.add((Component)this.zscaleField, gc);
            gc.gridwidth = 6;
            gc.gridy = 2;
            this.add((Component)new Label("Center:"), gc);
            gc.gridwidth = 1;
            gc.gridy = 3;
            this.add((Component)new Label("X"), gc);
            this.xtransField = new ValueField((double)Math.round(LinearMaterialMapping.this.dx * 1000.0) / 1000.0, 0, 5);
            this.add((Component)this.xtransField, gc);
            this.add((Component)new Label("Y"), gc);
            this.ytransField = new ValueField((double)Math.round(LinearMaterialMapping.this.dy * 1000.0) / 1000.0, 0, 5);
            this.add((Component)this.ytransField, gc);
            this.add((Component)new Label("Z"), gc);
            this.ztransField = new ValueField((double)Math.round(LinearMaterialMapping.this.dz * 1000.0) / 1000.0, 0, 5);
            this.add((Component)this.ztransField, gc);
            gc.gridwidth = 6;
            gc.gridy = 4;
            this.add((Component)new Label("Rotation:"), gc);
            gc.gridwidth = 1;
            gc.gridy = 5;
            double[] angles = LinearMaterialMapping.this.coords.getRotationAngles();
            this.add((Component)new Label("X"), gc);
            this.xrotField = new ValueField((double)Math.round(angles[0] * 1000.0) / 1000.0, 0, 5);
            this.add((Component)this.xrotField, gc);
            this.add((Component)new Label("Y"), gc);
            this.yrotField = new ValueField((double)Math.round(angles[1] * 1000.0) / 1000.0, 0, 5);
            this.add((Component)this.yrotField, gc);
            this.add((Component)new Label("Z"), gc);
            this.zrotField = new ValueField((double)Math.round(angles[2] * 1000.0) / 1000.0, 0, 5);
            this.add((Component)this.zrotField, gc);
            this.xscaleField.addTextListener(this);
            this.yscaleField.addTextListener(this);
            this.zscaleField.addTextListener(this);
            this.xtransField.addTextListener(this);
            this.ytransField.addTextListener(this);
            this.ztransField.addTextListener(this);
            this.xrotField.addTextListener(this);
            this.yrotField.addTextListener(this);
            this.zrotField.addTextListener(this);
        }

        public void textValueChanged(TextEvent e) {
            LinearMaterialMapping.this.xscale = this.xscaleField.getValue();
            LinearMaterialMapping.this.yscale = this.yscaleField.getValue();
            LinearMaterialMapping.this.zscale = this.zscaleField.getValue();
            LinearMaterialMapping.this.dx = this.xtransField.getValue();
            LinearMaterialMapping.this.dy = this.ytransField.getValue();
            LinearMaterialMapping.this.dz = this.ztransField.getValue();
            LinearMaterialMapping.this.coords.setOrientation(this.xrotField.getValue(), this.yrotField.getValue(), this.zrotField.getValue());
            LinearMaterialMapping.this.findCoefficients();
            this.preview.render();
        }
    }
}

