/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.object;

import artofillusion.Callback;
import artofillusion.Camera;
import artofillusion.ModellingApp;
import artofillusion.RenderingMesh;
import artofillusion.Scene;
import artofillusion.WireframeMesh;
import artofillusion.animation.Keyframe;
import artofillusion.animation.Skeleton;
import artofillusion.material.Material;
import artofillusion.material.MaterialMapping;
import artofillusion.math.BoundingBox;
import artofillusion.math.Vec3;
import artofillusion.object.ObjectInfo;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.LayeredMapping;
import artofillusion.texture.LayeredTexture;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.MessageDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.lang.reflect.Constructor;

public abstract class Object3D {
    protected Texture theTexture;
    protected Material theMaterial;
    protected TextureMapping texMapping;
    protected MaterialMapping matMapping;
    public static final int CANT_CONVERT = 0;
    public static final int EXACTLY = 1;
    public static final int APPROXIMATELY = 2;
    static /* synthetic */ Class class$java$io$DataInputStream;
    static /* synthetic */ Class class$artofillusion$material$Material;
    static /* synthetic */ Class class$artofillusion$texture$Texture;

    public Object3D() {
    }

    public abstract Object3D duplicate();

    public abstract void copyObject(Object3D var1);

    public abstract BoundingBox getBounds();

    public abstract void setSize(double var1, double var3, double var5);

    public static void draw(Graphics g, Camera cam, WireframeMesh mesh, BoundingBox bounds) {
        int vis = cam.visibility(bounds);
        int[] from = mesh.from;
        int[] to = mesh.to;
        int last = -1;
        Vec3[] vert = mesh.vert;
        if (vis == 0) {
            return;
        }
        if (vis == 1) {
            int i = 0;
            while (i < mesh.from.length) {
                if (from[i] == last) {
                    last = to[i];
                    cam.drawClippedLineTo(g, vert[last]);
                } else {
                    last = to[i];
                    cam.drawClippedLine(g, vert[from[i]], vert[last]);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < mesh.from.length) {
                if (from[i] == last) {
                    last = to[i];
                    cam.drawLineTo(g, vert[last]);
                } else {
                    last = to[i];
                    cam.drawLine(g, vert[from[i]], vert[last]);
                }
                ++i;
            }
        }
    }

    public boolean isClosed() {
        return true;
    }

    public int canConvertToTriangleMesh() {
        return 0;
    }

    public TriangleMesh convertToTriangleMesh(double tol) {
        return null;
    }

    public void sceneChanged(ObjectInfo info, Scene scene) {
    }

    public boolean editable() {
        return false;
    }

    public void edit(EditingWindow parent, ObjectInfo info, Callback cb) {
    }

    public void editGesture(EditingWindow parent, ObjectInfo info, Callback cb, ObjectInfo realObject) {
        this.edit(parent, info, cb);
    }

    public boolean canSetTexture() {
        return true;
    }

    public boolean canSetMaterial() {
        return this.canSetTexture() && this.isClosed();
    }

    public void setTexture(Texture tex) {
        this.theTexture = tex;
    }

    public Texture getTexture() {
        return this.theTexture;
    }

    public void setMaterial(Material mat) {
        this.theMaterial = mat;
    }

    public Material getMaterial() {
        return this.theMaterial;
    }

    public void setTextureMapping(TextureMapping mapping) {
        this.texMapping = mapping;
        if (mapping instanceof LayeredMapping) {
            this.setTexture(((LayeredMapping)mapping).getTexture());
        }
    }

    public TextureMapping getTextureMapping() {
        return this.texMapping;
    }

    public void setMaterialMapping(MaterialMapping mapping) {
        this.matMapping = mapping;
    }

    public MaterialMapping getMaterialMapping() {
        return this.matMapping;
    }

    public Skeleton getSkeleton() {
        return null;
    }

    public RenderingMesh getRenderingMesh(double tol, boolean interactive, ObjectInfo info) {
        return null;
    }

    public abstract WireframeMesh getWireframeMesh();

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        out.writeShort(0);
        if (this.canSetTexture()) {
            if (this.theMaterial == null) {
                out.writeInt(-1);
            } else {
                out.writeInt(theScene.indexOf(this.theMaterial));
                out.writeUTF(this.matMapping.getClass().getName());
                this.matMapping.writeToFile(out);
            }
            if (this.theTexture instanceof LayeredTexture) {
                out.writeInt(-1);
                ((LayeredMapping)this.texMapping).writeToFile(out, theScene);
            } else {
                out.writeInt(theScene.indexOf(this.theTexture));
                out.writeUTF(this.texMapping.getClass().getName());
                this.texMapping.writeToFile(out);
            }
        }
    }

    public Object3D(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        Constructor con;
        Class mapClass;
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        if (!this.canSetTexture()) {
            return;
        }
        int i = in.readInt();
        if (i > -1) {
            this.setMaterial(theScene.getMaterial(i));
            try {
                mapClass = ModellingApp.getClass(in.readUTF());
                con = mapClass.getConstructor(class$java$io$DataInputStream == null ? (class$java$io$DataInputStream = Object3D.class$("java.io.DataInputStream")) : class$java$io$DataInputStream, class$artofillusion$material$Material == null ? (class$artofillusion$material$Material = Object3D.class$("artofillusion.material.Material")) : class$artofillusion$material$Material);
                this.setMaterialMapping((MaterialMapping)con.newInstance(in, this.theMaterial));
            }
            catch (Exception ex) {
                throw new IOException();
            }
        }
        if ((i = in.readInt()) > -1) {
            this.setTexture(theScene.getTexture(i));
            try {
                mapClass = ModellingApp.getClass(in.readUTF());
                con = mapClass.getConstructor(class$java$io$DataInputStream == null ? (class$java$io$DataInputStream = Object3D.class$("java.io.DataInputStream")) : class$java$io$DataInputStream, class$artofillusion$texture$Texture == null ? (class$artofillusion$texture$Texture = Object3D.class$("artofillusion.texture.Texture")) : class$artofillusion$texture$Texture);
                this.setTextureMapping((TextureMapping)con.newInstance(in, this.theTexture));
            }
            catch (Exception ex) {
                throw new IOException();
            }
        } else {
            LayeredTexture tex = new LayeredTexture();
            LayeredMapping map = (LayeredMapping)tex.getDefaultMapping();
            map.readFromFile(in, theScene);
            this.setTexture(tex);
            this.setTextureMapping(map);
        }
    }

    public abstract Keyframe getPoseKeyframe();

    public abstract void applyPoseKeyframe(Keyframe var1);

    public String[] getPoseValueNames() {
        return new String[0];
    }

    public double[] getDefaultPoseValues() {
        return new double[this.getPoseValueNames().length];
    }

    public double[][] getPoseValueRange() {
        double[][] range = new double[this.getPoseValueNames().length][2];
        int i = 0;
        while (i < range.length) {
            range[i][0] = -1.7976931348623157E308;
            range[i][1] = Double.MAX_VALUE;
            ++i;
        }
        return range;
    }

    public void editKeyframe(EditingWindow parent, Keyframe k, ObjectInfo info) {
        new MessageDialog((Frame)((Object)parent), "This keyframe has no editable parameters.");
    }

    public Object3D getPosableObject() {
        return this;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

