/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.object;

import artofillusion.RenderingMesh;
import artofillusion.Scene;
import artofillusion.WireframeMesh;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.TriangleMesh;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.util.Enumeration;
import java.util.Vector;

public abstract class ObjectCollection
extends Object3D {
    protected Vector cachedObjects;
    protected BoundingBox cachedBounds;
    protected double lastTime;
    protected CoordinateSystem lastCoords;
    protected Scene lastScene;
    protected boolean usesTime;
    protected boolean usesCoords;

    public ObjectCollection() {
    }

    public ObjectCollection(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        super(in, theScene);
    }

    public synchronized Enumeration getObjects(ObjectInfo info, boolean interactive, Scene scene) {
        if (!interactive) {
            return this.enumerateObjects(info, interactive, scene);
        }
        if (this.cachedObjects == null) {
            this.cachedObjects = new Vector();
            Enumeration enumeration = this.enumerateObjects(info, interactive, scene);
            while (enumeration.hasMoreElements()) {
                this.cachedObjects.addElement(enumeration.nextElement());
            }
        }
        return this.cachedObjects.elements();
    }

    protected abstract Enumeration enumerateObjects(ObjectInfo var1, boolean var2, Scene var3);

    public BoundingBox getBounds() {
        return this.cachedBounds;
    }

    public void setUsesTime(boolean b) {
        this.usesTime = b;
    }

    public void setUsesCoords(boolean b) {
        this.usesCoords = b;
    }

    public boolean isClosed() {
        int i = 0;
        while (i < this.cachedObjects.size()) {
            ObjectInfo info = (ObjectInfo)this.cachedObjects.elementAt(i);
            if (!info.object.isClosed()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean canSetMaterial() {
        return true;
    }

    public RenderingMesh getRenderingMesh(double tol, boolean interactive, ObjectInfo info) {
        return this.convertToTriangleMesh(tol).getRenderingMesh(tol, interactive, info);
    }

    public WireframeMesh getWireframeMesh() {
        return new WireframeMesh(new Vec3[0], new int[0], new int[0]);
    }

    public int canConvertToTriangleMesh() {
        return 2;
    }

    public TriangleMesh convertToTriangleMesh(double tol) {
        Vector<Vec3> allVert = new Vector<Vec3>();
        Vector<int[]> allFace = new Vector<int[]>();
        int start = 0;
        Enumeration enumeration = this.getObjects(new ObjectInfo(this, this.lastCoords, ""), false, this.lastScene);
        while (enumeration.hasMoreElements()) {
            ObjectInfo obj = (ObjectInfo)enumeration.nextElement();
            if (obj.object.canConvertToTriangleMesh() == 0) continue;
            Mat4 trans = obj.coords.fromLocal();
            TriangleMesh tri = obj.object.convertToTriangleMesh(tol);
            MeshVertex[] vert = tri.getVertices();
            int i = 0;
            while (i < vert.length) {
                allVert.addElement(trans.times(vert[i].r));
                ++i;
            }
            TriangleMesh.Face[] face = tri.getFaces();
            int i2 = 0;
            while (i2 < face.length) {
                allFace.addElement(new int[]{face[i2].v1 + start, face[i2].v2 + start, face[i2].v3 + start});
                ++i2;
            }
            start += vert.length;
        }
        if (allVert.size() == 0) {
            allVert.addElement(new Vec3());
        }
        Object[] vert = new Vec3[allVert.size()];
        allVert.copyInto(vert);
        int[][] face = new int[allFace.size()][];
        allFace.copyInto((Object[])face);
        TriangleMesh mesh = new TriangleMesh((Vec3[])vert, (int[][])face);
        mesh.setTexture(this.getTexture());
        if (this.getTexture() != null) {
            mesh.setTextureMapping(this.getTextureMapping().duplicate());
        }
        mesh.setMaterial(this.getMaterial());
        if (this.getMaterial() != null) {
            mesh.setMaterialMapping(this.getMaterialMapping().duplicate());
        }
        return mesh;
    }

    /*
     * Unable to fully structure code
     */
    public void sceneChanged(ObjectInfo info, Scene scene) {
        block1: {
            block2: {
                if (this.cachedBounds != null && (!this.usesTime || this.lastTime == scene.getTime()) && (!this.usesCoords || this.lastCoords.equals(info.coords))) break block1;
                this.lastScene = scene;
                this.lastTime = scene.getTime();
                this.lastCoords = info.coords.duplicate();
                this.cachedObjects = null;
                enum = this.getObjects(info, true, scene);
                if (enum.hasMoreElements()) ** GOTO lbl14
                this.cachedBounds = new BoundingBox(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
                break block2;
lbl-1000:
                // 1 sources

                {
                    obj = (ObjectInfo)enum.nextElement();
                    bounds = obj.getBounds();
                    bounds = bounds.transformAndOutset(obj.coords.fromLocal());
                    this.cachedBounds = this.cachedBounds == null ? bounds : this.cachedBounds.merge(bounds);
lbl14:
                    // 2 sources

                    ** while (enum.hasMoreElements())
                }
            }
            info.clearCachedMeshes();
        }
    }
}

