/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.object;

import artofillusion.Camera;
import artofillusion.ModellingApp;
import artofillusion.RenderingMesh;
import artofillusion.TextureParameter;
import artofillusion.WireframeMesh;
import artofillusion.animation.Actor;
import artofillusion.animation.Keyframe;
import artofillusion.animation.Skeleton;
import artofillusion.animation.TextureTrack;
import artofillusion.animation.Track;
import artofillusion.animation.distortion.Distortion;
import artofillusion.material.Material;
import artofillusion.material.MaterialMapping;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.object.Mesh;
import artofillusion.object.Object3D;
import artofillusion.object.SplineMesh;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import java.awt.Graphics;

public class ObjectInfo {
    public Object3D object;
    public CoordinateSystem coords;
    public String name;
    public boolean visible;
    public boolean selected;
    public boolean parentSelected;
    public ObjectInfo parent;
    public ObjectInfo[] children;
    public Track[] tracks;
    public Keyframe pose;
    public TextureParameter[] texParam;
    public double[] texParamValue;
    public boolean[] texParamPerVertex;
    public int id;
    private Distortion distortion;
    private Distortion prevDistortion;
    private RenderingMesh cachedMesh;
    private WireframeMesh cachedWire;
    private BoundingBox cachedBounds;
    static boolean lastPreviewWasWireframe;

    public ObjectInfo(Object3D obj, CoordinateSystem c, String n) {
        this.object = obj;
        this.coords = c;
        this.name = n;
        this.visible = true;
        this.children = new ObjectInfo[0];
        this.id = -1;
        if (this.object == null || this.object.getTexture() == null) {
            this.texParam = new TextureParameter[0];
            this.texParamValue = new double[0];
            this.texParamPerVertex = new boolean[0];
        } else {
            this.texParam = this.object.getTextureMapping().getParameters();
            this.texParamValue = new double[this.texParam.length];
            int i = 0;
            while (i < this.texParamValue.length) {
                this.texParamValue[i] = this.texParam[i].defaultVal;
                ++i;
            }
            this.texParamPerVertex = new boolean[this.texParam.length];
        }
    }

    public ObjectInfo duplicate() {
        ObjectInfo info = new ObjectInfo(this.object, this.coords.duplicate(), this.name);
        info.visible = this.visible;
        info.id = this.id;
        if (this.tracks != null) {
            info.tracks = new Track[this.tracks.length];
            int i = 0;
            while (i < this.tracks.length) {
                info.tracks[i] = this.tracks[i].duplicate(info);
                ++i;
            }
        }
        info.texParam = new TextureParameter[this.texParam.length];
        System.arraycopy(this.texParam, 0, info.texParam, 0, this.texParam.length);
        info.texParamValue = new double[this.texParamValue.length];
        System.arraycopy(this.texParamValue, 0, info.texParamValue, 0, this.texParamValue.length);
        info.texParamPerVertex = new boolean[this.texParamPerVertex.length];
        System.arraycopy(this.texParamPerVertex, 0, info.texParamPerVertex, 0, this.texParamPerVertex.length);
        if (this.distortion != null) {
            info.distortion = this.distortion.duplicate();
        }
        return info;
    }

    public ObjectInfo duplicate(Object3D obj) {
        ObjectInfo info = new ObjectInfo(obj, this.coords.duplicate(), this.name);
        info.visible = this.visible;
        info.id = this.id;
        if (this.tracks != null) {
            info.tracks = new Track[this.tracks.length];
            int i = 0;
            while (i < this.tracks.length) {
                info.tracks[i] = this.tracks[i].duplicate(info);
                ++i;
            }
        }
        info.texParam = new TextureParameter[this.texParam.length];
        System.arraycopy(this.texParam, 0, info.texParam, 0, this.texParam.length);
        info.texParamValue = new double[this.texParamValue.length];
        System.arraycopy(this.texParamValue, 0, info.texParamValue, 0, this.texParamValue.length);
        info.texParamPerVertex = new boolean[this.texParamPerVertex.length];
        System.arraycopy(this.texParamPerVertex, 0, info.texParamPerVertex, 0, this.texParamPerVertex.length);
        info.setTexture(obj.getTexture(), obj.getTextureMapping());
        if (this.distortion != null) {
            info.distortion = this.distortion.duplicate();
        }
        return info;
    }

    public static ObjectInfo[] duplicateAll(ObjectInfo[] info) {
        ObjectInfo[] newobj = new ObjectInfo[info.length];
        int i = 0;
        while (i < newobj.length) {
            newobj[i] = info[i].duplicate(info[i].object.duplicate());
            ++i;
        }
        int i2 = 0;
        while (i2 < info.length) {
            int k = info[i2].children.length - 1;
            while (k >= 0) {
                int j = 0;
                while (j < info.length && info[j] != info[i2].children[k]) {
                    ++j;
                }
                if (j < info.length) {
                    newobj[i2].addChild(newobj[j], 0);
                }
                --k;
            }
            ++i2;
        }
        return newobj;
    }

    public void copyInfo(ObjectInfo info) {
        this.object = info.object;
        this.coords.copyCoords(info.coords);
        this.name = info.name.toString();
        this.visible = info.visible;
        this.id = info.id;
        this.cachedMesh = info.cachedMesh;
        this.cachedWire = info.cachedWire;
        this.cachedBounds = info.cachedBounds;
        if (info.tracks == null) {
            this.tracks = null;
        } else {
            this.tracks = new Track[info.tracks.length];
            int i = 0;
            while (i < this.tracks.length) {
                this.tracks[i] = info.tracks[i].duplicate(this);
                ++i;
            }
        }
        this.texParam = new TextureParameter[info.texParam.length];
        System.arraycopy(info.texParam, 0, this.texParam, 0, this.texParam.length);
        this.texParamValue = new double[info.texParamValue.length];
        System.arraycopy(info.texParamValue, 0, this.texParamValue, 0, this.texParamValue.length);
        this.texParamPerVertex = new boolean[info.texParamPerVertex.length];
        System.arraycopy(info.texParamPerVertex, 0, this.texParamPerVertex, 0, this.texParamPerVertex.length);
        if (info.distortion != null) {
            this.distortion = info.distortion.duplicate();
        }
        if (info.prevDistortion != null) {
            this.prevDistortion = info.prevDistortion.duplicate();
        }
    }

    public void addChild(ObjectInfo info, int position) {
        ObjectInfo[] newChildren = new ObjectInfo[this.children.length + 1];
        int i = 0;
        while (i < position) {
            newChildren[i] = this.children[i];
            ++i;
        }
        newChildren[position] = info;
        while (i < this.children.length) {
            newChildren[i + 1] = this.children[i];
            ++i;
        }
        this.children = newChildren;
        info.parent = this;
    }

    public void removeChild(ObjectInfo info) {
        int i = 0;
        while (i < this.children.length) {
            if (this.children[i] == info) {
                this.removeChild(i);
                return;
            }
            ++i;
        }
    }

    public void removeChild(int which) {
        ObjectInfo[] newChildren = new ObjectInfo[this.children.length - 1];
        this.children[which].parent = null;
        int i = 0;
        while (i < which) {
            newChildren[i] = this.children[i];
            ++i;
        }
        ++i;
        while (i < this.children.length) {
            newChildren[i - 1] = this.children[i];
            ++i;
        }
        this.children = newChildren;
    }

    public void addTrack(Track tr, int position) {
        if (this.tracks == null) {
            this.tracks = new Track[]{tr};
            return;
        }
        Track[] newTracks = new Track[this.tracks.length + 1];
        int i = 0;
        while (i < position) {
            newTracks[i] = this.tracks[i];
            ++i;
        }
        newTracks[position] = tr;
        while (i < this.tracks.length) {
            newTracks[i + 1] = this.tracks[i];
            ++i;
        }
        this.tracks = newTracks;
    }

    public void removeTrack(Track tr) {
        int i = 0;
        while (i < this.tracks.length) {
            if (this.tracks[i] == tr) {
                this.removeTrack(i);
                return;
            }
            ++i;
        }
    }

    public void removeTrack(int which) {
        Track[] newTracks = new Track[this.tracks.length - 1];
        int i = 0;
        while (i < which) {
            newTracks[i] = this.tracks[i];
            ++i;
        }
        ++i;
        while (i < this.tracks.length) {
            newTracks[i - 1] = this.tracks[i];
            ++i;
        }
        this.tracks = newTracks;
    }

    public void setTexture(Texture tex, TextureMapping map) {
        this.object.setTexture(tex);
        this.object.setTextureMapping(map);
        this.clearCachedMeshes();
        if (map == null) {
            this.texParam = new TextureParameter[0];
            this.texParamValue = new double[0];
            this.texParamPerVertex = new boolean[0];
        } else {
            TextureParameter[] newParam = map.getParameters();
            double[] newParamValue = new double[newParam.length];
            boolean[] newPerVertex = new boolean[newParam.length];
            int i = 0;
            while (i < newParam.length) {
                newParamValue[i] = newParam[i].defaultVal;
                int j = 0;
                while (j < this.texParam.length) {
                    if (newParam[i].equals(this.texParam[j])) {
                        newParamValue[i] = this.texParamValue[j];
                        newPerVertex[i] = this.texParamPerVertex[j];
                        break;
                    }
                    ++j;
                }
                if (newParam[i].type != 0) {
                    newPerVertex[i] = true;
                }
                ++i;
            }
            this.texParam = newParam;
            this.texParamValue = newParamValue;
            this.texParamPerVertex = newPerVertex;
        }
        if (this.tracks != null) {
            int i = 0;
            while (i < this.tracks.length) {
                if (this.tracks[i] instanceof TextureTrack) {
                    ((TextureTrack)this.tracks[i]).parametersChanged();
                }
                ++i;
            }
        }
    }

    public void setMaterial(Material mat, MaterialMapping map) {
        this.object.setMaterial(mat);
        this.object.setMaterialMapping(map);
    }

    public void clearDistortion() {
        this.distortion = null;
    }

    public void addDistortion(Distortion d) {
        d.setPreviousDistortion(this.distortion);
        this.distortion = d;
    }

    public boolean isDistorted() {
        return this.distortion != null;
    }

    private void checkDistortionChanged() {
        if (this.prevDistortion == this.distortion || this.distortion != null && this.distortion.isIdenticalTo(this.prevDistortion)) {
            return;
        }
        this.prevDistortion = this.distortion;
        this.clearCachedMeshes();
    }

    public RenderingMesh getRenderingMesh(double tol) {
        if (this.distortion != null) {
            if (this.object instanceof Mesh) {
                return ((Object3D)((Object)this.distortion.transform((Mesh)((Object)this.object)))).getRenderingMesh(tol, false, this);
            }
            if (this.object.canConvertToTriangleMesh() != 0) {
                return ((Object3D)((Object)this.distortion.transform(this.object.convertToTriangleMesh(tol)))).getRenderingMesh(tol, false, this);
            }
        }
        return this.object.getRenderingMesh(tol, false, this);
    }

    public RenderingMesh getPreviewMesh() {
        this.checkDistortionChanged();
        if (this.cachedMesh == null) {
            if (this.pose != null && !this.pose.equals(this.object.getPoseKeyframe())) {
                this.object.applyPoseKeyframe(this.pose);
            }
            double tol = ModellingApp.getPreferences().getInteractiveSurfaceError();
            if (this.distortion != null) {
                if (this.object instanceof Mesh) {
                    this.cachedMesh = ((Object3D)((Object)this.distortion.transform((Mesh)((Object)this.object)))).getRenderingMesh(tol, true, this);
                } else if (this.object.canConvertToTriangleMesh() != 0) {
                    this.cachedMesh = ((Object3D)((Object)this.distortion.transform(this.object.convertToTriangleMesh(tol)))).getRenderingMesh(tol, true, this);
                }
            } else {
                this.cachedMesh = this.object.getRenderingMesh(tol, true, this);
            }
        }
        lastPreviewWasWireframe = false;
        return this.cachedMesh;
    }

    public WireframeMesh getWireframePreview() {
        this.checkDistortionChanged();
        if (this.cachedWire == null) {
            if (this.pose != null && !this.pose.equals(this.object.getPoseKeyframe())) {
                this.object.applyPoseKeyframe(this.pose);
            }
            if (this.distortion != null) {
                if (this.object instanceof Mesh) {
                    this.cachedWire = ((Object3D)((Object)this.distortion.transform((Mesh)((Object)this.object)))).getWireframeMesh();
                } else if (this.object.canConvertToTriangleMesh() != 0) {
                    this.cachedWire = ((Object3D)((Object)this.distortion.transform(this.object.convertToTriangleMesh(ModellingApp.getPreferences().getInteractiveSurfaceError())))).getWireframeMesh();
                }
            } else {
                this.cachedWire = this.object.getWireframeMesh();
            }
        }
        lastPreviewWasWireframe = true;
        return this.cachedWire;
    }

    public BoundingBox getBounds() {
        this.checkDistortionChanged();
        if (this.cachedBounds == null) {
            double tol = ModellingApp.getPreferences().getInteractiveSurfaceError();
            if (this.pose != null && !this.pose.equals(this.object.getPoseKeyframe())) {
                this.object.applyPoseKeyframe(this.pose);
            }
            if (this.distortion != null && (this.object instanceof Mesh || this.object.canConvertToTriangleMesh() != 0)) {
                Object3D distortedObject = this.object instanceof Mesh ? (Object3D)((Object)this.distortion.transform((Mesh)((Object)this.object))) : (Object3D)((Object)this.distortion.transform(this.object.convertToTriangleMesh(tol)));
                if (lastPreviewWasWireframe && this.cachedWire == null) {
                    this.cachedWire = distortedObject.getWireframeMesh();
                } else if (!lastPreviewWasWireframe && this.cachedMesh == null) {
                    this.cachedMesh = distortedObject.getRenderingMesh(tol, true, this);
                }
                this.cachedBounds = distortedObject.getBounds();
            } else {
                if (!lastPreviewWasWireframe && this.cachedMesh == null && (this.object instanceof TriangleMesh || this.object instanceof SplineMesh || this.object instanceof Actor)) {
                    this.cachedMesh = this.object.getRenderingMesh(tol, true, this);
                }
                this.cachedBounds = this.object.getBounds();
            }
        }
        return this.cachedBounds;
    }

    public void clearCachedMeshes() {
        this.cachedMesh = null;
        this.cachedWire = null;
        this.cachedBounds = null;
    }

    public Skeleton getSkeleton() {
        if (this.object instanceof Mesh) {
            return ((Mesh)((Object)this.object)).getSkeleton();
        }
        if (this.object instanceof Actor) {
            return ((Actor)this.object).getSkeleton();
        }
        return null;
    }

    public void draw(Graphics g, Camera cam) {
        Object3D.draw(g, cam, this.getWireframePreview(), this.getBounds());
    }
}

