/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.Scene;
import artofillusion.math.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.Module;
import artofillusion.procedural.PointInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.ValueField;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class GridModule
extends Module {
    boolean valueOk;
    boolean errorOk;
    boolean gradOk;
    double value;
    double error;
    double xspace = 1.0;
    double yspace = 1.0;
    double zspace = 1.0;
    double lastBlur;
    double xinv = 1.0;
    double yinv = 1.0;
    double zinv = 1.0;
    PointInfo point;
    Vec3 gradient = new Vec3();

    public GridModule(Point position) {
        super("Grid", new IOPort[]{new IOPort(0, 0, 2, new String[]{"X", "(X)"}), new IOPort(0, 0, 2, new String[]{"Y", "(Y)"}), new IOPort(0, 0, 2, new String[]{"Z", "(Z)"})}, new IOPort[]{new IOPort(0, 1, 3, new String[]{"Value"})}, position);
    }

    public void init(PointInfo p) {
        this.point = p;
        this.gradOk = false;
        this.errorOk = false;
        this.valueOk = false;
    }

    public double getAverageValue(int which, double blur) {
        if (this.valueOk && blur == this.lastBlur) {
            return this.value;
        }
        this.valueOk = true;
        this.lastBlur = blur;
        double x = this.linkFrom[0] == null ? this.point.x : this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
        double y = this.linkFrom[1] == null ? this.point.y : this.linkFrom[1].getAverageValue(this.linkFromIndex[1], blur);
        double z = this.linkFrom[2] == null ? this.point.z : this.linkFrom[2].getAverageValue(this.linkFromIndex[2], blur);
        double xi = this.xspace * (double)Math.round(x * this.xinv);
        double yi = this.yspace * (double)Math.round(y * this.yinv);
        double zi = this.zspace * (double)Math.round(z * this.zinv);
        double xf = x - xi;
        double yf = y - yi;
        double zf = z - zi;
        this.value = Math.sqrt(xf * xf + yf * yf + zf * zf);
        this.gradient.set(xf, yf, zf);
        this.gradient.scale(1.0 / this.value);
        return this.value;
    }

    public double getValueError(int which, double blur) {
        if (this.errorOk && blur == this.lastBlur) {
            return this.error;
        }
        double xsize = this.linkFrom[0] == null ? 0.5 * this.point.xsize + blur : this.linkFrom[0].getValueError(this.linkFromIndex[0], blur);
        double ysize = this.linkFrom[1] == null ? 0.5 * this.point.ysize + blur : this.linkFrom[1].getValueError(this.linkFromIndex[1], blur);
        double zsize = this.linkFrom[2] == null ? 0.5 * this.point.zsize + blur : this.linkFrom[2].getValueError(this.linkFromIndex[2], blur);
        this.error = Math.max(Math.max(xsize, ysize), zsize);
        this.errorOk = true;
        return this.error;
    }

    public void getValueGradient(int which, Vec3 grad, double blur) {
        if (!this.valueOk || blur != this.lastBlur) {
            this.getAverageValue(which, blur);
        }
        if (this.gradOk) {
            grad.set(this.gradient);
            return;
        }
        double dx = this.gradient.x;
        double dy = this.gradient.y;
        double dz = this.gradient.z;
        if (dx != 0.0) {
            if (this.linkFrom[0] == null) {
                this.gradient.set(dx, 0.0, 0.0);
            } else {
                this.linkFrom[0].getValueGradient(this.linkFromIndex[0], grad, blur);
                this.gradient.x = dx * grad.x;
                this.gradient.y = dx * grad.y;
                this.gradient.z = dx * grad.z;
            }
        } else {
            this.gradient.set(0.0, 0.0, 0.0);
        }
        if (dy != 0.0) {
            if (this.linkFrom[1] == null) {
                this.gradient.y += dy;
            } else {
                this.linkFrom[1].getValueGradient(this.linkFromIndex[1], grad, blur);
                this.gradient.x += dy * grad.x;
                this.gradient.y += dy * grad.y;
                this.gradient.z += dy * grad.z;
            }
        }
        if (dz != 0.0) {
            if (this.linkFrom[2] == null) {
                this.gradient.z += dz;
            } else {
                this.linkFrom[2].getValueGradient(this.linkFromIndex[2], grad, blur);
                this.gradient.x += dz * grad.x;
                this.gradient.y += dz * grad.y;
                this.gradient.z += dz * grad.z;
            }
        }
        this.gradOk = true;
        grad.set(this.gradient);
    }

    public boolean edit(Frame fr, Scene theScene) {
        ValueField xField = new ValueField(this.xspace, 3);
        ValueField yField = new ValueField(this.xspace, 3);
        ValueField zField = new ValueField(this.xspace, 3);
        ComponentsDialog dlg = new ComponentsDialog(fr, "Set Grid Spacing:", new Component[]{xField, yField, zField}, new String[]{"X", "Y", "Z"});
        if (!dlg.clickedOk()) {
            return false;
        }
        this.xspace = xField.getValue();
        this.yspace = yField.getValue();
        this.zspace = zField.getValue();
        this.xinv = 1.0 / this.xspace;
        this.yinv = 1.0 / this.yspace;
        this.zinv = 1.0 / this.zspace;
        return true;
    }

    public Module duplicate() {
        GridModule mod = new GridModule(new Point(this.bounds.x, this.bounds.y));
        mod.xspace = this.xspace;
        mod.yspace = this.yspace;
        mod.zspace = this.zspace;
        mod.xinv = this.xinv;
        mod.yinv = this.yinv;
        mod.zinv = this.zinv;
        return mod;
    }

    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        out.writeDouble(this.xspace);
        out.writeDouble(this.yspace);
        out.writeDouble(this.zspace);
    }

    public void readFromStream(DataInputStream in, Scene theScene) throws IOException {
        this.xspace = in.readDouble();
        this.yspace = in.readDouble();
        this.zspace = in.readDouble();
        this.xinv = 1.0 / this.xspace;
        this.yinv = 1.0 / this.yspace;
        this.zinv = 1.0 / this.zspace;
    }
}

