/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.Scene;
import artofillusion.math.Noise;
import artofillusion.math.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.Module;
import artofillusion.procedural.PointInfo;
import artofillusion.ui.PanelDialog;
import artofillusion.ui.ValueField;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class JitterModule
extends Module {
    boolean valueOk;
    Vec3 v = new Vec3();
    Vec3 tempVec = new Vec3();
    double xamp = 0.1;
    double yamp = 0.1;
    double zamp = 0.1;
    double xscale = 1.0;
    double yscale = 1.0;
    double zscale = 1.0;
    double invxscale = 1.0;
    double invyscale = 1.0;
    double invzscale = 1.0;
    double lastBlur;
    PointInfo point;

    public JitterModule(Point position) {
        super("Jitter", new IOPort[]{new IOPort(0, 0, 2, new String[]{"X", "(X)"}), new IOPort(0, 0, 2, new String[]{"Y", "(Y)"}), new IOPort(0, 0, 2, new String[]{"Z", "(Z)"})}, new IOPort[]{new IOPort(0, 1, 3, new String[]{"X"}), new IOPort(0, 1, 3, new String[]{"Y"}), new IOPort(0, 1, 3, new String[]{"Z"})}, position);
    }

    public void init(PointInfo p) {
        this.point = p;
        this.valueOk = false;
    }

    public double getAverageValue(int which, double blur) {
        if (!this.valueOk || blur != this.lastBlur) {
            this.v.x = this.linkFrom[0] == null ? this.point.x : this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
            this.v.y = this.linkFrom[1] == null ? this.point.y : this.linkFrom[1].getAverageValue(this.linkFromIndex[1], blur);
            this.v.z = this.linkFrom[2] == null ? this.point.z : this.linkFrom[2].getAverageValue(this.linkFromIndex[2], blur);
            Noise.calcVector(this.tempVec, this.invxscale * this.v.x, this.invyscale * this.v.y, this.invzscale * this.v.z);
            this.v.x += this.xamp * this.tempVec.x;
            this.v.y += this.yamp * this.tempVec.y;
            this.v.z += this.zamp * this.tempVec.z;
            this.valueOk = true;
            this.lastBlur = blur;
        }
        if (which == 0) {
            return this.v.x;
        }
        if (which == 1) {
            return this.v.y;
        }
        return this.v.z;
    }

    public double getValueError(int which, double blur) {
        if (this.linkFrom[which] != null) {
            return this.linkFrom[which].getValueError(this.linkFromIndex[which], blur);
        }
        if (which == 0) {
            return this.point.xsize * 0.5 + blur;
        }
        if (which == 1) {
            return this.point.ysize * 0.5 + blur;
        }
        return this.point.zsize * 0.5 + blur;
    }

    public void getValueGradient(int which, Vec3 grad, double blur) {
        if (this.linkFrom[which] != null) {
            this.linkFrom[which].getValueGradient(this.linkFromIndex[which], grad, blur);
        } else if (which == 0) {
            grad.set(1.0, 0.0, 0.0);
        } else if (which == 1) {
            grad.set(0.0, 1.0, 0.0);
        } else {
            grad.set(0.0, 0.0, 1.0);
        }
    }

    public boolean edit(Frame fr, Scene theScene) {
        ValueField amp1 = new ValueField(this.xamp, 0, 4);
        ValueField amp2 = new ValueField(this.yamp, 0, 4);
        ValueField amp3 = new ValueField(this.zamp, 0, 4);
        ValueField scale1 = new ValueField(this.xscale, 3, 4);
        ValueField scale2 = new ValueField(this.yscale, 3, 4);
        ValueField scale3 = new ValueField(this.zscale, 3, 4);
        Panel p = new Panel();
        GridBagConstraints gc = new GridBagConstraints();
        p.setLayout(new GridBagLayout());
        gc.gridy = 0;
        p.add((Component)new Label(""), gc);
        p.add((Component)new Label("X"), gc);
        p.add((Component)new Label("Y"), gc);
        p.add((Component)new Label("Z"), gc);
        gc.gridy = 1;
        p.add((Component)new Label("Amplitude"), gc);
        p.add((Component)amp1, gc);
        p.add((Component)amp2, gc);
        p.add((Component)amp3, gc);
        gc.gridy = 2;
        p.add((Component)new Label("Scale"), gc);
        p.add((Component)scale1, gc);
        p.add((Component)scale2, gc);
        p.add((Component)scale3, gc);
        PanelDialog dlg = new PanelDialog(fr, "Select Jitter Parameters:", p);
        if (!dlg.clickedOk()) {
            return false;
        }
        this.xamp = amp1.getValue();
        this.yamp = amp2.getValue();
        this.zamp = amp3.getValue();
        this.xscale = scale1.getValue();
        this.yscale = scale2.getValue();
        this.zscale = scale3.getValue();
        this.invxscale = 1.0 / this.xscale;
        this.invyscale = 1.0 / this.yscale;
        this.invzscale = 1.0 / this.zscale;
        return true;
    }

    public Module duplicate() {
        JitterModule mod = new JitterModule(new Point(this.bounds.x, this.bounds.y));
        mod.xamp = this.xamp;
        mod.yamp = this.yamp;
        mod.zamp = this.zamp;
        mod.xscale = this.xscale;
        mod.yscale = this.yscale;
        mod.zscale = this.zscale;
        mod.invxscale = this.invxscale;
        mod.invyscale = this.invyscale;
        mod.invzscale = this.invzscale;
        return mod;
    }

    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        out.writeDouble(this.xamp);
        out.writeDouble(this.yamp);
        out.writeDouble(this.zamp);
        out.writeDouble(this.xscale);
        out.writeDouble(this.yscale);
        out.writeDouble(this.zscale);
    }

    public void readFromStream(DataInputStream in, Scene theScene) throws IOException {
        this.xamp = in.readDouble();
        this.yamp = in.readDouble();
        this.zamp = in.readDouble();
        this.xscale = in.readDouble();
        this.yscale = in.readDouble();
        this.zscale = in.readDouble();
        this.invxscale = 1.0 / this.xscale;
        this.invyscale = 1.0 / this.yscale;
        this.invzscale = 1.0 / this.zscale;
    }
}

