/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.Scene;
import artofillusion.math.Noise;
import artofillusion.math.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.Module;
import artofillusion.procedural.PointInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.ValueField;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class NoiseModule
extends Module {
    boolean valueOk;
    boolean errorOk;
    boolean gradOk;
    int octaves = 4;
    double value;
    double error;
    double amplitude = 1.0;
    double lastBlur;
    Vec3 gradient = new Vec3();
    Vec3 tempVec = new Vec3();
    PointInfo point;

    public NoiseModule(Point position) {
        super("Noise", new IOPort[]{new IOPort(0, 0, 2, new String[]{"X", "(X)"}), new IOPort(0, 0, 2, new String[]{"Y", "(Y)"}), new IOPort(0, 0, 2, new String[]{"Z", "(Z)"}), new IOPort(0, 0, 2, new String[]{"Noise", "(0.5)"})}, new IOPort[]{new IOPort(0, 1, 3, new String[]{"Value"})}, position);
    }

    public void init(PointInfo p) {
        this.point = p;
        this.gradOk = false;
        this.errorOk = false;
        this.valueOk = false;
    }

    public double getAverageValue(int which, double blur) {
        if (this.valueOk && blur == this.lastBlur) {
            return this.value;
        }
        double x = this.linkFrom[0] == null ? this.point.x : this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
        double y = this.linkFrom[1] == null ? this.point.y : this.linkFrom[1].getAverageValue(this.linkFromIndex[1], blur);
        double z = this.linkFrom[2] == null ? this.point.z : this.linkFrom[2].getAverageValue(this.linkFromIndex[2], blur);
        double persistence = this.linkFrom[3] == null ? 0.5 : this.linkFrom[3].getAverageValue(this.linkFromIndex[3], blur);
        double xsize = this.linkFrom[0] == null ? 0.5 * this.point.xsize + blur : this.linkFrom[0].getValueError(this.linkFromIndex[0], blur);
        double ysize = this.linkFrom[1] == null ? 0.5 * this.point.ysize + blur : this.linkFrom[1].getValueError(this.linkFromIndex[1], blur);
        double zsize = this.linkFrom[2] == null ? 0.5 * this.point.zsize + blur : this.linkFrom[2].getValueError(this.linkFromIndex[2], blur);
        double amp = this.amplitude;
        double scale = 1.0;
        double cutoff = 0.5 / Math.max(Math.max(xsize, ysize), zsize);
        this.value = 0.0;
        int i = 0;
        while (i < this.octaves && cutoff > scale) {
            this.value += amp * Noise.value(x * scale + 123.456, y * scale + 123.456, z * scale + 123.456);
            amp *= persistence;
            scale *= 2.0;
            ++i;
        }
        this.value = 0.5 * this.value + 0.5;
        this.valueOk = true;
        this.lastBlur = blur;
        return this.value;
    }

    public double getValueError(int which, double blur) {
        if (!this.valueOk || blur != this.lastBlur) {
            this.getAverageValue(which, blur);
        }
        if (this.errorOk) {
            return this.error;
        }
        double x = this.linkFrom[0] == null ? this.point.x : this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
        double y = this.linkFrom[1] == null ? this.point.y : this.linkFrom[1].getAverageValue(this.linkFromIndex[1], blur);
        double z = this.linkFrom[2] == null ? this.point.z : this.linkFrom[2].getAverageValue(this.linkFromIndex[2], blur);
        double persistence = this.linkFrom[3] == null ? 0.5 : this.linkFrom[3].getAverageValue(this.linkFromIndex[3], blur);
        double xsize = this.linkFrom[0] == null ? 0.5 * this.point.xsize + blur : this.linkFrom[0].getValueError(this.linkFromIndex[0], blur);
        double ysize = this.linkFrom[1] == null ? 0.5 * this.point.ysize + blur : this.linkFrom[1].getValueError(this.linkFromIndex[1], blur);
        double zsize = this.linkFrom[2] == null ? 0.5 * this.point.zsize + blur : this.linkFrom[2].getValueError(this.linkFromIndex[2], blur);
        double amp = this.amplitude;
        double scale = 1.0;
        double cutoff = 0.5 / Math.max(Math.max(xsize, ysize), zsize);
        this.error = 0.0;
        this.gradient.set(0.0, 0.0, 0.0);
        int i = 0;
        while (i < this.octaves && cutoff > scale) {
            Noise.calcGradient(this.tempVec, x * scale + 123.456, y * scale + 123.456, z * scale + 123.456);
            this.tempVec.scale(amp * scale);
            this.gradient.add(this.tempVec);
            this.error += Math.abs(xsize * this.tempVec.x) + Math.abs(ysize * this.tempVec.y) + Math.abs(zsize * this.tempVec.z);
            amp *= persistence;
            scale *= 2.0;
            ++i;
        }
        while (i < this.octaves) {
            this.error += amp;
            amp *= persistence;
            scale *= 2.0;
            ++i;
        }
        this.error *= 0.5;
        this.gradient.scale(0.5);
        this.errorOk = true;
        return this.error;
    }

    public void getValueGradient(int which, Vec3 grad, double blur) {
        if (this.gradOk && blur == this.lastBlur) {
            grad.set(this.gradient);
            return;
        }
        if (!this.errorOk || blur != this.lastBlur) {
            this.getValueError(which, blur);
        }
        double dx = this.gradient.x;
        double dy = this.gradient.y;
        double dz = this.gradient.z;
        if (dx != 0.0) {
            if (this.linkFrom[0] == null) {
                this.gradient.set(dx, 0.0, 0.0);
            } else {
                this.linkFrom[0].getValueGradient(this.linkFromIndex[0], grad, blur);
                this.gradient.x = dx * grad.x;
                this.gradient.y = dx * grad.y;
                this.gradient.z = dx * grad.z;
            }
        } else {
            this.gradient.set(0.0, 0.0, 0.0);
        }
        if (dy != 0.0) {
            if (this.linkFrom[1] == null) {
                this.gradient.y += dy;
            } else {
                this.linkFrom[1].getValueGradient(this.linkFromIndex[1], grad, blur);
                this.gradient.x += dy * grad.x;
                this.gradient.y += dy * grad.y;
                this.gradient.z += dy * grad.z;
            }
        }
        if (dz != 0.0) {
            if (this.linkFrom[2] == null) {
                this.gradient.z += dz;
            } else {
                this.linkFrom[2].getValueGradient(this.linkFromIndex[2], grad, blur);
                this.gradient.x += dz * grad.x;
                this.gradient.y += dz * grad.y;
                this.gradient.z += dz * grad.z;
            }
        }
        this.gradOk = true;
        grad.set(this.gradient);
    }

    public boolean edit(Frame fr, Scene theScene) {
        ValueField octavesField = new ValueField((double)this.octaves, 7);
        ValueField ampField = new ValueField(this.amplitude, 0);
        ComponentsDialog dlg = new ComponentsDialog(fr, "Set noise properties:", new Component[]{ampField, octavesField}, new String[]{"Amplitude", "Octaves"});
        if (!dlg.clickedOk()) {
            return false;
        }
        this.octaves = (int)octavesField.getValue();
        this.amplitude = ampField.getValue();
        return true;
    }

    public Module duplicate() {
        NoiseModule mod = new NoiseModule(new Point(this.bounds.x, this.bounds.y));
        mod.octaves = this.octaves;
        mod.amplitude = this.amplitude;
        return mod;
    }

    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        out.writeInt(this.octaves);
        out.writeDouble(this.amplitude);
    }

    public void readFromStream(DataInputStream in, Scene theScene) throws IOException {
        this.octaves = in.readInt();
        this.amplitude = in.readDouble();
    }
}

