/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.Scene;
import artofillusion.math.RGBColor;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.Module;
import artofillusion.procedural.PointInfo;
import artofillusion.ui.ColorChooser;
import artofillusion.ui.Translate;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SpectrumModule
extends Module {
    RGBColor[] color = new RGBColor[]{new RGBColor(0.0f, 0.0f, 0.0f), new RGBColor(1.0f, 1.0f, 1.0f)};
    RGBColor outputColor;
    float[][] a1;
    float[][] b1;
    float[][] c1;
    double[] index = new double[]{0.0, 1.0};
    double lastBlur;
    boolean repeat;
    boolean colorOk;

    public SpectrumModule(Point position) {
        super("Spectrum", new IOPort[]{new IOPort(0, 0, 2, new String[]{"Index", "(0)"})}, new IOPort[]{new IOPort(1, 1, 3, new String[]{"Color"})}, position);
        this.outputColor = new RGBColor(0.0f, 0.0f, 0.0f);
        this.calcCoefficients();
    }

    public void init(PointInfo p) {
        this.colorOk = false;
    }

    private void calcCoefficients() {
        this.a1 = new float[this.color.length][3];
        this.b1 = new float[this.color.length][3];
        this.c1 = new float[this.color.length][3];
        int i = 0;
        while (i < this.color.length - 1) {
            float d = (float)(this.index[i + 1] - this.index[i]);
            if (d == 0.0f) {
                this.b1[i][2] = 0.0f;
                this.b1[i][1] = 0.0f;
                this.b1[i][0] = 0.0f;
                this.a1[i][2] = 0.0f;
                this.a1[i][1] = 0.0f;
                this.a1[i][0] = 0.0f;
            } else {
                this.a1[i][0] = 0.5f * (this.color[i + 1].getRed() - this.color[i].getRed()) / d;
                this.a1[i][1] = 0.5f * (this.color[i + 1].getGreen() - this.color[i].getGreen()) / d;
                this.a1[i][2] = 0.5f * (this.color[i + 1].getBlue() - this.color[i].getBlue()) / d;
                this.b1[i][0] = this.color[i].getRed() - 2.0f * this.a1[i][0] * (float)this.index[i];
                this.b1[i][1] = this.color[i].getGreen() - 2.0f * this.a1[i][1] * (float)this.index[i];
                this.b1[i][2] = this.color[i].getBlue() - 2.0f * this.a1[i][2] * (float)this.index[i];
                this.c1[i + 1][0] = (float)((double)this.c1[i][0] + this.index[i + 1] * ((double)this.a1[i][0] * this.index[i + 1] + (double)this.b1[i][0]) - this.index[i] * ((double)this.a1[i][0] * this.index[i] + (double)this.b1[i][0]));
                this.c1[i + 1][1] = (float)((double)this.c1[i][1] + this.index[i + 1] * ((double)this.a1[i][1] * this.index[i + 1] + (double)this.b1[i][1]) - this.index[i] * ((double)this.a1[i][1] * this.index[i] + (double)this.b1[i][1]));
                this.c1[i + 1][2] = (float)((double)this.c1[i][2] + this.index[i + 1] * ((double)this.a1[i][2] * this.index[i + 1] + (double)this.b1[i][2]) - this.index[i] * ((double)this.a1[i][2] * this.index[i] + (double)this.b1[i][2]));
            }
            ++i;
        }
        if (!this.repeat) {
            this.b1[i][0] = this.color[i].getRed();
            this.b1[i][1] = this.color[i].getGreen();
            this.b1[i][2] = this.color[i].getBlue();
        }
        i = 1;
        while (i < this.color.length) {
            float[] fArray = this.c1[i];
            fArray[0] = fArray[0] - (float)(this.index[i] * ((double)this.a1[i][0] * this.index[i] + (double)this.b1[i][0]));
            float[] fArray2 = this.c1[i];
            fArray2[1] = fArray2[1] - (float)(this.index[i] * ((double)this.a1[i][1] * this.index[i] + (double)this.b1[i][1]));
            float[] fArray3 = this.c1[i];
            fArray3[2] = fArray3[2] - (float)(this.index[i] * ((double)this.a1[i][2] * this.index[i] + (double)this.b1[i][2]));
            ++i;
        }
    }

    private void calcColor(double value, RGBColor c) {
        if (value <= 0.0 || value >= 1.0) {
            if (this.repeat) {
                value -= Math.floor(value);
            } else {
                if (value <= 0.0) {
                    c.copy(this.color[0]);
                    return;
                }
                c.copy(this.color[this.color.length - 1]);
                return;
            }
        }
        int i = 1;
        while (i < this.index.length && value > this.index[i]) {
            ++i;
        }
        int i2 = i;
        int i1 = i - 1;
        float d = (float)(this.index[i2] - this.index[i1]);
        float fract = d > 0.0f ? (float)(value - this.index[i1]) / d : 0.0f;
        float fract2 = 1.0f - fract;
        c.setRGB(fract * this.color[i2].getRed() + fract2 * this.color[i1].getRed(), fract * this.color[i2].getGreen() + fract2 * this.color[i1].getGreen(), fract * this.color[i2].getBlue() + fract2 * this.color[i1].getBlue());
    }

    private void integrateColor(double value, RGBColor c) {
        float vf;
        if (!this.repeat) {
            if (value <= 0.0) {
                c.setRGB((float)value * this.b1[0][0], (float)value * this.b1[0][1], (float)value * this.b1[0][2]);
                return;
            }
            if (value >= 1.0) {
                int i = this.color.length - 1;
                c.setRGB(this.c1[i][0] + (float)value * this.b1[i][0], this.c1[i][1] + (float)value * this.b1[i][1], this.c1[i][2] + (float)value * this.b1[i][2]);
                return;
            }
            vf = (float)value;
            c.setRGB(0.0f, 0.0f, 0.0f);
        } else {
            float vi = (float)Math.floor(value);
            vf = (float)value - vi;
            c.setRGB(vi * this.c1[this.color.length - 1][0], vi * this.c1[this.color.length - 1][1], vi * this.c1[this.color.length - 1][2]);
        }
        if ((double)vf == 0.0) {
            return;
        }
        int i = 1;
        while (i < this.index.length && (double)vf > this.index[i]) {
            ++i;
        }
        c.add(this.c1[--i][0] + vf * (vf * this.a1[i][0] + this.b1[i][0]), this.c1[i][1] + vf * (vf * this.a1[i][1] + this.b1[i][1]), this.c1[i][2] + vf * (vf * this.a1[i][2] + this.b1[i][2]));
    }

    public void getColor(int which, RGBColor c, double blur) {
        double error;
        if (this.colorOk && blur == this.lastBlur) {
            c.copy(this.outputColor);
            return;
        }
        this.colorOk = true;
        this.lastBlur = blur;
        double value = this.linkFrom[0] == null ? 0.0 : this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
        double d = error = this.linkFrom[0] == null ? 0.0 : this.linkFrom[0].getValueError(this.linkFromIndex[0], blur);
        if (error == 0.0) {
            this.calcColor(value, c);
        } else {
            this.integrateColor(value + 0.5 * error, c);
            this.integrateColor(value - 0.5 * error, this.outputColor);
            c.subtract(this.outputColor);
            c.scale(1.0 / error);
            this.outputColor.copy(c);
        }
    }

    public Module duplicate() {
        SpectrumModule mod = new SpectrumModule(new Point(this.bounds.x, this.bounds.y));
        mod.repeat = this.repeat;
        mod.color = new RGBColor[this.color.length];
        mod.index = new double[this.index.length];
        int i = 0;
        while (i < this.color.length) {
            mod.color[i] = this.color[i].duplicate();
            mod.index[i] = this.index[i];
            ++i;
        }
        mod.calcCoefficients();
        return mod;
    }

    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        out.writeInt(this.color.length);
        int i = 0;
        while (i < this.color.length) {
            out.writeDouble(this.index[i]);
            this.color[i].writeToFile(out);
            ++i;
        }
        out.writeBoolean(this.repeat);
    }

    public void readFromStream(DataInputStream in, Scene theScene) throws IOException {
        int num = in.readInt();
        this.color = new RGBColor[num];
        this.index = new double[num];
        int i = 0;
        while (i < this.color.length) {
            this.index[i] = in.readDouble();
            this.color[i] = new RGBColor(in);
            ++i;
        }
        this.repeat = in.readBoolean();
        this.calcCoefficients();
    }

    public void calcSize() {
        this.bounds.width = 50;
        this.bounds.height = 30;
    }

    protected void drawContents(Graphics g) {
        int x1 = this.bounds.x + 5;
        int y1 = this.bounds.y + 5;
        RGBColor temp = new RGBColor(0.0f, 0.0f, 0.0f);
        int i = 0;
        while (i < 40) {
            this.calcColor((double)i / 39.0, temp);
            g.setColor(temp.getColor());
            g.drawLine(x1 + i, y1, x1 + i, y1 + 20);
            ++i;
        }
    }

    public boolean edit(Frame fr, Scene theScene) {
        EditingDialog dlg = new EditingDialog(fr);
        this.calcCoefficients();
        return dlg.clickedOk;
    }

    private class EditingDialog
    extends Dialog
    implements ActionListener,
    KeyListener,
    MouseListener,
    MouseMotionListener,
    TextListener {
        Canvas canvas;
        TextField indexField;
        Panel preview;
        Checkbox repeatBox;
        Button deleteButton;
        Point clickPoint;
        Point[] handlePos;
        int selected;
        int rows;
        SpectrumModule oldModule;
        boolean clickedOk;
        static final int HANDLE_SIZE = 5;

        public EditingDialog(Frame parent) {
            super(parent, "Function", true);
            Panel p = new Panel();
            GridBagConstraints gc = new GridBagConstraints();
            p.setLayout(new BorderLayout());
            p.add((Component)new Label("Drag to move handles.  Control-click to add a handle."), "North");
            this.canvas = new Canvas(this){
                private final /* synthetic */ EditingDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void update(Graphics g) {
                    this.paint(g);
                }

                public void paint(Graphics g) {
                    EditingDialog.access$000(this.this$1, g);
                }

                public Dimension getPreferredSize() {
                    return new Dimension(200, 30 + this.this$1.rows * 5);
                }
            };
            this.canvas.addKeyListener(this);
            this.canvas.addMouseListener(this);
            this.canvas.addMouseMotionListener(this);
            p.add((Component)this.canvas, "Center");
            this.add((Component)p, "North");
            p = new Panel();
            p.setLayout(new GridBagLayout());
            gc.gridy = 0;
            gc.insets = new Insets(0, 0, 0, 10);
            p.add((Component)new Label("Value:"), gc);
            this.indexField = new TextField("", 5);
            p.add((Component)this.indexField, gc);
            this.indexField.addKeyListener(this);
            this.indexField.addTextListener(this);
            p.add((Component)new Label("Color:"), gc);
            this.preview = SpectrumModule.this.color[0].getSample(30, 20);
            p.add((Component)this.preview, gc);
            this.preview.addMouseListener(this);
            Button b = new Button("Add");
            p.add((Component)b, gc);
            b.addActionListener(this);
            b.setActionCommand("add");
            b = new Button("Delete");
            p.add((Component)b, gc);
            b.addActionListener(this);
            b.setActionCommand("delete");
            this.deleteButton = b;
            gc.gridy = 1;
            gc.gridwidth = 6;
            this.repeatBox = new Checkbox("Function is Periodic", SpectrumModule.this.repeat);
            p.add((Component)this.repeatBox, gc);
            this.add((Component)p, "Center");
            p = new Panel();
            p.add(Translate.button("ok", this));
            p.add(Translate.button("cancel", this));
            this.add((Component)p, "South");
            this.oldModule = (SpectrumModule)SpectrumModule.this.duplicate();
            this.adjustComponents();
            this.handlePos = new Point[SpectrumModule.this.index.length];
            int i = 0;
            while (i < SpectrumModule.this.index.length) {
                this.handlePos[i] = new Point(0, 0);
                ++i;
            }
            this.rows = 1;
            this.pack();
            this.positionHandles();
            this.show();
            this.canvas.requestFocus();
        }

        private void adjustComponents() {
            this.indexField.setText("" + SpectrumModule.this.index[this.selected]);
            this.preview.setBackground(SpectrumModule.this.color[this.selected].getColor());
            this.preview.repaint();
            boolean movable = this.selected > 0 && this.selected < SpectrumModule.this.index.length - 1;
            this.indexField.setEnabled(movable);
            this.deleteButton.setEnabled(movable);
        }

        private void positionHandles() {
            Dimension d = this.canvas.getSize();
            int oldrows = this.rows;
            int i = 0;
            while (i < SpectrumModule.this.index.length) {
                this.handlePos[i].x = (int)(SpectrumModule.this.index[i] * (double)d.width);
                ++i;
            }
            if (this.clickPoint != null) {
                return;
            }
            this.rows = 1;
            int i2 = 1;
            while (i2 < SpectrumModule.this.index.length) {
                int row = 0;
                boolean overlap = true;
                while (overlap) {
                    overlap = false;
                    int j = 0;
                    while (j < i2 && (row != this.handlePos[j].y || this.handlePos[i2].x - this.handlePos[j].x > 5)) {
                        ++j;
                    }
                    if (j >= i2) continue;
                    ++row;
                    overlap = true;
                }
                this.handlePos[i2].y = row;
                if (row >= this.rows) {
                    this.rows = row + 1;
                }
                ++i2;
            }
            if (oldrows != this.rows) {
                this.pack();
            }
        }

        private void paintCanvas(Graphics g) {
            Dimension d = this.canvas.getSize();
            RGBColor temp = new RGBColor(0.0f, 0.0f, 0.0f);
            double scale = 1.0 / (double)(d.width - 1);
            int i = 0;
            while (i < d.width) {
                SpectrumModule.this.calcColor((double)i * scale, temp);
                g.setColor(temp.getColor());
                g.drawLine(i, 0, i, 30);
                ++i;
            }
            g.setColor(((Component)this).getBackground());
            g.fillRect(0, 30, d.width, d.height);
            g.setColor(Color.black);
            int i2 = 0;
            while (i2 < SpectrumModule.this.index.length) {
                if (i2 == this.selected) {
                    g.setColor(Color.red);
                }
                int x = this.handlePos[i2].x;
                int y = 30 + this.handlePos[i2].y * 5;
                g.fillPolygon(new int[]{x, x + 5, x - 5}, new int[]{y, y + 5, y + 5}, 3);
                g.setColor(Color.black);
                g.drawLine(x, y, x, 30);
                ++i2;
            }
        }

        public void addHandle(double where) {
            double[] newindex = new double[SpectrumModule.this.index.length + 1];
            RGBColor[] newcolor = new RGBColor[SpectrumModule.this.color.length + 1];
            int i = 0;
            while (i < SpectrumModule.this.index.length && SpectrumModule.this.index[i] < where) {
                newindex[i] = SpectrumModule.this.index[i];
                newcolor[i] = SpectrumModule.this.color[i];
                ++i;
            }
            newindex[i] = where;
            newcolor[i] = new RGBColor(1.0f, 1.0f, 1.0f);
            SpectrumModule.this.calcColor(newindex[i], newcolor[i]);
            this.selected = i;
            while (i < SpectrumModule.this.index.length) {
                newindex[i + 1] = SpectrumModule.this.index[i];
                newcolor[i + 1] = SpectrumModule.this.color[i];
                ++i;
            }
            SpectrumModule.this.index = newindex;
            SpectrumModule.this.color = newcolor;
            this.handlePos = new Point[SpectrumModule.this.index.length + 1];
            i = 0;
            while (i < this.handlePos.length) {
                this.handlePos[i] = new Point(0, 0);
                ++i;
            }
            SpectrumModule.this.calcCoefficients();
            this.adjustComponents();
            this.positionHandles();
            this.canvas.repaint();
        }

        public void deleteSelectedHandle() {
            if (this.selected == 0 || this.selected == SpectrumModule.this.index.length - 1) {
                return;
            }
            double[] newindex = new double[SpectrumModule.this.index.length - 1];
            RGBColor[] newcolor = new RGBColor[SpectrumModule.this.color.length - 1];
            int i = 0;
            while (i < SpectrumModule.this.index.length - 1) {
                if (i < this.selected) {
                    newindex[i] = SpectrumModule.this.index[i];
                    newcolor[i] = SpectrumModule.this.color[i];
                } else {
                    newindex[i] = SpectrumModule.this.index[i + 1];
                    newcolor[i] = SpectrumModule.this.color[i + 1];
                }
                ++i;
            }
            this.selected = 0;
            SpectrumModule.this.index = newindex;
            SpectrumModule.this.color = newcolor;
            this.handlePos = new Point[SpectrumModule.this.index.length];
            i = 0;
            while (i < this.handlePos.length) {
                this.handlePos[i] = new Point(0, 0);
                ++i;
            }
            SpectrumModule.this.calcCoefficients();
            this.adjustComponents();
            this.positionHandles();
            this.canvas.repaint();
        }

        public void actionPerformed(ActionEvent ev) {
            String command = ev.getActionCommand();
            if ("add".equals(command)) {
                this.addHandle(0.5);
            }
            if ("delete".equals(command)) {
                this.deleteSelectedHandle();
            }
            if ("ok".equals(command)) {
                this.clickedOk = true;
                SpectrumModule.this.repeat = this.repeatBox.getState();
                this.dispose();
            }
            if ("cancel".equals(command)) {
                SpectrumModule.this.color = this.oldModule.color;
                SpectrumModule.this.index = this.oldModule.index;
                SpectrumModule.this.repeat = this.oldModule.repeat;
                SpectrumModule.this.calcCoefficients();
                this.dispose();
            }
        }

        public void keyPressed(KeyEvent ev) {
            if (ev.getKeyCode() == 10) {
                this.clickedOk = true;
                SpectrumModule.this.repeat = this.repeatBox.getState();
                this.dispose();
            }
            if (ev.getKeyCode() == 27) {
                SpectrumModule.this.color = this.oldModule.color;
                SpectrumModule.this.index = this.oldModule.index;
                SpectrumModule.this.repeat = this.oldModule.repeat;
                SpectrumModule.this.calcCoefficients();
                this.dispose();
            }
            if (ev.getSource() != this.canvas) {
                return;
            }
            if (ev.getKeyCode() == 8 || ev.getKeyCode() == 127) {
                this.deleteSelectedHandle();
            }
        }

        public void mousePressed(MouseEvent ev) {
            if (ev.getSource() == this.preview) {
                new ColorChooser((Frame)this.getParent(), "Select Color", SpectrumModule.this.color[this.selected]);
                this.preview.setBackground(SpectrumModule.this.color[this.selected].getColor());
                this.canvas.repaint();
                this.preview.repaint();
                return;
            }
            this.clickPoint = ev.getPoint();
            this.canvas.requestFocus();
            if (ev.isControlDown()) {
                Dimension d = this.canvas.getSize();
                double ind = (double)this.clickPoint.x / ((double)d.width - 1.0);
                this.addHandle(0.001 * (double)((int)(ind * 1000.0)));
                return;
            }
            int i = 0;
            while (i < this.handlePos.length) {
                int x = this.handlePos[i].x;
                int y = 30 + this.handlePos[i].y * 5;
                if (this.clickPoint.x >= x - 5 && this.clickPoint.x <= x + 5 && this.clickPoint.y >= y && this.clickPoint.y <= y + 5) {
                    this.selected = i;
                    this.adjustComponents();
                    this.canvas.repaint();
                    return;
                }
                ++i;
            }
            this.clickPoint = null;
        }

        public void mouseDragged(MouseEvent ev) {
            Point tempPos;
            RGBColor tempcolor;
            double temp;
            if (this.clickPoint == null || this.selected == 0 || this.selected == SpectrumModule.this.index.length - 1) {
                return;
            }
            Dimension d = this.canvas.getSize();
            Point pos = ev.getPoint();
            this.handlePos[this.selected].x = pos.x;
            double ind = (double)pos.x / ((double)d.width - 1.0);
            if (ind < 0.0) {
                ind = 0.0;
            }
            if (ind > 1.0) {
                ind = 1.0;
            }
            SpectrumModule.this.index[this.selected] = 0.001 * (double)((int)(1000.0 * ind));
            while (SpectrumModule.this.index[this.selected] < SpectrumModule.this.index[this.selected - 1]) {
                temp = SpectrumModule.this.index[this.selected];
                SpectrumModule.this.index[this.selected] = SpectrumModule.this.index[this.selected - 1];
                SpectrumModule.this.index[this.selected - 1] = temp;
                tempcolor = SpectrumModule.this.color[this.selected];
                SpectrumModule.this.color[this.selected] = SpectrumModule.this.color[this.selected - 1];
                SpectrumModule.this.color[this.selected - 1] = tempcolor;
                tempPos = this.handlePos[this.selected];
                this.handlePos[this.selected] = this.handlePos[this.selected - 1];
                this.handlePos[this.selected - 1] = tempPos;
                --this.selected;
            }
            while (SpectrumModule.this.index[this.selected] > SpectrumModule.this.index[this.selected + 1]) {
                temp = SpectrumModule.this.index[this.selected];
                SpectrumModule.this.index[this.selected] = SpectrumModule.this.index[this.selected + 1];
                SpectrumModule.this.index[this.selected + 1] = temp;
                tempcolor = SpectrumModule.this.color[this.selected];
                SpectrumModule.this.color[this.selected] = SpectrumModule.this.color[this.selected + 1];
                SpectrumModule.this.color[this.selected + 1] = tempcolor;
                tempPos = this.handlePos[this.selected];
                this.handlePos[this.selected] = this.handlePos[this.selected + 1];
                this.handlePos[this.selected + 1] = tempPos;
                ++this.selected;
            }
            this.adjustComponents();
            this.canvas.repaint();
        }

        public void mouseReleased(MouseEvent ev) {
            this.clickPoint = null;
            SpectrumModule.this.calcCoefficients();
            this.positionHandles();
            this.canvas.repaint();
        }

        public void textValueChanged(TextEvent ev) {
            double val;
            try {
                val = Double.valueOf(this.indexField.getText());
            }
            catch (NumberFormatException ex) {
                this.indexField.setForeground(Color.red);
                return;
            }
            if (val < 0.0 || val > 1.0) {
                this.indexField.setForeground(Color.red);
            } else {
                SpectrumModule.this.index[this.selected] = val;
                this.indexField.setForeground(Color.black);
                SpectrumModule.this.calcCoefficients();
                this.positionHandles();
                this.canvas.repaint();
            }
        }

        public void keyReleased(KeyEvent ev) {
        }

        public void keyTyped(KeyEvent ev) {
        }

        public void mouseClicked(MouseEvent ev) {
        }

        public void mouseEntered(MouseEvent ev) {
        }

        public void mouseExited(MouseEvent ev) {
        }

        public void mouseMoved(MouseEvent ev) {
        }

        static /* synthetic */ void access$000(EditingDialog x0, Graphics x1) {
            x0.paintCanvas(x1);
        }
    }
}

