/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.Scene;
import artofillusion.math.Noise;
import artofillusion.math.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.Module;
import artofillusion.procedural.PointInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.ValueField;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class WoodModule
extends Module {
    boolean valueOk;
    boolean mod = true;
    int octaves = 2;
    double value;
    double error;
    double amplitude = 1.0;
    double spacing = 0.25;
    double lastBlur;
    Vec3 gradient = new Vec3();
    Vec3 tempVec = new Vec3();
    PointInfo point;

    public WoodModule(Point position) {
        super("Wood", new IOPort[]{new IOPort(0, 0, 2, new String[]{"X", "(X)"}), new IOPort(0, 0, 2, new String[]{"Y", "(Y)"}), new IOPort(0, 0, 2, new String[]{"Z", "(Z)"}), new IOPort(0, 0, 2, new String[]{"Noise", "(0.5)"})}, new IOPort[]{new IOPort(0, 1, 3, new String[]{"Value"})}, position);
    }

    public void init(PointInfo p) {
        this.point = p;
        this.valueOk = false;
    }

    public double getAverageValue(int which, double blur) {
        if (this.valueOk && blur == this.lastBlur) {
            return this.value;
        }
        double x = this.linkFrom[0] == null ? this.point.x : this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
        double y = this.linkFrom[1] == null ? this.point.y : this.linkFrom[1].getAverageValue(this.linkFromIndex[1], blur);
        double z = this.linkFrom[2] == null ? this.point.z : this.linkFrom[2].getAverageValue(this.linkFromIndex[2], blur);
        double persistence = this.linkFrom[3] == null ? 0.5 : this.linkFrom[3].getAverageValue(this.linkFromIndex[3], blur);
        double xsize = this.linkFrom[0] == null ? 0.5 * this.point.xsize + blur : this.linkFrom[0].getValueError(this.linkFromIndex[0], blur);
        double ysize = this.linkFrom[1] == null ? 0.5 * this.point.ysize + blur : this.linkFrom[1].getValueError(this.linkFromIndex[1], blur);
        double zsize = this.linkFrom[2] == null ? 0.5 * this.point.zsize + blur : this.linkFrom[2].getValueError(this.linkFromIndex[2], blur);
        double amp = this.amplitude;
        double scale = 1.0;
        double cutoff = 0.5 / Math.max(Math.max(xsize, ysize), zsize);
        this.value = 0.0;
        this.error = 0.0;
        this.gradient.set(0.0, 0.0, 0.0);
        int i = 0;
        while (i < this.octaves && cutoff > scale) {
            double d = amp * Noise.value(x * scale + 123.456, y * scale + 123.456, z * scale + 123.456);
            this.value += Math.abs(d);
            Noise.calcGradient(this.tempVec, x * scale + 123.456, y * scale + 123.456, z * scale + 123.456);
            if (d > 0.0) {
                this.tempVec.scale(amp * scale);
            } else {
                this.tempVec.scale(-amp * scale);
            }
            this.gradient.add(this.tempVec);
            this.error += Math.abs(xsize * this.tempVec.x) + Math.abs(ysize * this.tempVec.y) + Math.abs(zsize * this.tempVec.z);
            amp *= persistence;
            scale *= 2.0;
            ++i;
        }
        scale = 1.0 / this.spacing;
        double r = Math.sqrt(x * x + y * y);
        double rinv = 1.0 / r;
        if (this.linkFrom[0] == null) {
            this.tempVec.set(1.0, 0.0, 0.0);
        } else {
            this.linkFrom[0].getValueGradient(this.linkFromIndex[0], this.tempVec, blur);
        }
        if (r == 0.0) {
            this.gradient.set(0.0, 0.0, 0.0);
            this.error = 1000000.0;
        } else {
            this.gradient.set(x * rinv * scale * this.tempVec.x + this.gradient.x, y * rinv * scale * this.tempVec.y + this.gradient.y, this.gradient.z);
            this.error = Math.abs(xsize * this.gradient.x) + Math.abs(ysize * this.gradient.y) + Math.abs(zsize * this.gradient.z);
        }
        if (!this.mod) {
            this.value = r * scale + this.value;
        } else if (this.error == 0.0) {
            this.value = r * scale + this.value;
            this.value -= Math.floor(this.value);
        } else if (this.error >= 0.5) {
            this.error = 0.5;
            this.value = 0.5;
        } else {
            double min = r * scale + this.value - this.error;
            double max = r * scale + this.value + this.error;
            min -= Math.floor(min);
            if ((max -= Math.floor(max)) > min) {
                this.value = 0.5 * (max + min);
            } else {
                this.value = (0.5 * max * max + 0.5 * (1.0 + min) * (1.0 - min)) / (1.0 - min + max);
                this.gradient.scale((max - min) / (2.0 * this.error));
                this.error = 0.5;
            }
        }
        this.valueOk = true;
        this.lastBlur = blur;
        return this.value;
    }

    public double getValueError(int which, double blur) {
        if (!this.valueOk || blur != this.lastBlur) {
            this.getAverageValue(which, blur);
        }
        return this.error;
    }

    public void getValueGradient(int which, Vec3 grad, double blur) {
        if (!this.valueOk || blur != this.lastBlur) {
            this.getAverageValue(which, blur);
        }
        grad.set(this.gradient);
    }

    public boolean edit(Frame fr, Scene theScene) {
        ValueField octavesField = new ValueField((double)this.octaves, 7);
        ValueField ampField = new ValueField(this.amplitude, 0);
        ValueField spacingField = new ValueField(this.spacing, 3);
        Checkbox modBox = new Checkbox("Only Output Fraction", this.mod);
        ComponentsDialog dlg = new ComponentsDialog(fr, "Set wood properties:", new Component[]{ampField, spacingField, octavesField, modBox}, new String[]{"Noise Amplitude", "Ring Spacing", "Noise Octaves", ""});
        if (!dlg.clickedOk()) {
            return false;
        }
        this.octaves = (int)octavesField.getValue();
        this.amplitude = ampField.getValue();
        this.spacing = spacingField.getValue();
        this.mod = modBox.getState();
        return true;
    }

    public Module duplicate() {
        WoodModule mod = new WoodModule(new Point(this.bounds.x, this.bounds.y));
        mod.octaves = this.octaves;
        mod.amplitude = this.amplitude;
        mod.spacing = this.spacing;
        return mod;
    }

    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        out.writeInt(this.octaves);
        out.writeDouble(this.amplitude);
        out.writeDouble(this.spacing);
    }

    public void readFromStream(DataInputStream in, Scene theScene) throws IOException {
        this.octaves = in.readInt();
        this.amplitude = in.readDouble();
        this.spacing = in.readDouble();
    }
}

