/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.script;

import artofillusion.Scene;
import artofillusion.animation.Track;
import artofillusion.math.CoordinateSystem;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.script.ObjectScript;
import artofillusion.script.ScriptRunner;
import artofillusion.script.ScriptedObject;
import artofillusion.script.ScriptedObjectEnumeration;
import java.awt.Frame;

public class ScriptedObjectController {
    private ObjectInfo info;
    private ScriptedObject object;
    private ScriptedObjectEnumeration enumeration;
    private Scene scene;
    private boolean preview;

    ScriptedObjectController(ObjectInfo obj, ScriptedObjectEnumeration scriptedObjectEnumeration, boolean interactive, Scene sc) {
        this.info = obj;
        this.object = (ScriptedObject)obj.object;
        this.enumeration = scriptedObjectEnumeration;
        this.preview = interactive;
        this.scene = sc;
        this.object.setUsesTime(false);
        this.object.setUsesCoords(false);
        new Thread(){

            public void run() {
                try {
                    ObjectScript script = ScriptedObjectController.this.object.getObjectScript();
                    script.execute(ScriptedObjectController.this);
                    ScriptedObjectController.this.enumeration.executionComplete();
                }
                catch (Exception ex) {
                    ScriptedObjectController.this.enumeration.executionComplete();
                    Frame fr = new Frame();
                    ScriptRunner.displayError(ex, fr, 1);
                    fr.dispose();
                }
            }
        }.start();
    }

    public final CoordinateSystem getCoordinates() {
        this.object.setUsesCoords(true);
        return this.info.coords;
    }

    public final double getTime() {
        this.object.setUsesTime(true);
        return this.scene.getTime();
    }

    public final Scene getScene() {
        this.object.setUsesTime(true);
        return this.scene;
    }

    public final boolean isPreview() {
        return this.preview;
    }

    public final double getParameter(String name) throws IllegalArgumentException {
        int i = this.object.getNumParameters() - 1;
        while (i >= 0) {
            if (this.object.getParameterName(i).equals(name)) {
                return this.object.getParameterValue(i);
            }
            --i;
        }
        throw new IllegalArgumentException("Unknown parameter '" + name + "'");
    }

    public final void addObject(ObjectInfo info) {
        info.tracks = new Track[0];
        if (info.object.canSetTexture() && info.object.getTextureMapping() == null) {
            info.setTexture(this.object.getTexture(), this.object.getTextureMapping());
        }
        if (info.object.canSetMaterial() && info.object.getMaterialMapping() == null) {
            info.setMaterial(this.object.getMaterial(), this.object.getMaterialMapping());
        }
        this.enumeration.addObject(info);
    }

    public final void addObject(Object3D obj, CoordinateSystem coords) {
        this.addObject(new ObjectInfo(obj, coords, ""));
    }
}

