/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.texture;

import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.texture.LayeredMapping;
import artofillusion.texture.LayeredTexture;
import artofillusion.texture.Linear2DTriangle;
import artofillusion.texture.Linear3DTriangle;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;
import artofillusion.texture.UniformTriangle;

public class LayeredTriangle
extends RenderingTriangle {
    double x1;
    double x2;
    double x3;
    double y1;
    double y2;
    double y3;
    double z1;
    double z2;
    double z3;
    LayeredMapping map;
    RenderingTriangle[] layerTriangle;
    Vec3 temp = new Vec3();

    public LayeredTriangle(int v1, int v2, int v3, int n1, int n2, int n3, double t1x, double t1y, double t1z, double t2x, double t2y, double t2z, double t3x, double t3y, double t3z, LayeredMapping theMapping, LayeredTexture theTexture, Vec3[] vert) {
        super(v1, v2, v3, n1, n2, n3, theMapping);
        this.map = theMapping;
        this.x1 = t1x;
        this.y1 = t1y;
        this.z1 = t1z;
        this.x2 = t2x;
        this.y2 = t2y;
        this.z2 = t2z;
        this.x3 = t3x;
        this.y3 = t3y;
        this.z3 = t3z;
        this.layerTriangle = new RenderingTriangle[this.map.getNumLayers()];
        int i = 0;
        while (i < this.layerTriangle.length) {
            RenderingTriangle tri = this.map.getLayerMapping(i).mapTriangle(v1, v2, v3, n1, n2, n3, vert);
            if (!(tri instanceof UniformTriangle || tri instanceof Linear2DTriangle || tri instanceof Linear3DTriangle)) {
                this.layerTriangle[i] = tri;
            }
            ++i;
        }
    }

    public void getTextureSpec(TextureSpec spec, boolean front, double u, double v, double w, double size, double time) {
        this.temp.set(this.x1 * u + this.x2 * v + this.x3 * w, this.y1 * u + this.y2 * v + this.y3 * w, this.z1 * u + this.z2 * v + this.z3 * w);
        TextureSpec tempSpec = this.map.tempSpec;
        int[] numParams = this.map.numParams;
        int[] paramStartIndex = this.map.paramStartIndex;
        int[] fractParamIndex = this.map.fractParamIndex;
        int[] blendMode = this.map.blendMode;
        double[] paramTemp = this.map.paramTemp;
        double[] param = this.getParameters(u, v, w);
        TextureMapping[] mapping = this.map.mapping;
        float rt = 1.0f;
        float gt = 1.0f;
        float bt = 1.0f;
        double ft = 1.0;
        spec.diffuse.setRGB(0.0f, 0.0f, 0.0f);
        spec.specular.setRGB(0.0f, 0.0f, 0.0f);
        spec.transparent.setRGB(1.0f, 1.0f, 1.0f);
        spec.emissive.setRGB(0.0f, 0.0f, 0.0f);
        spec.cloudiness = 0.0;
        spec.roughness = 0.0;
        spec.bumpGrad.set(0.0, 0.0, 0.0);
        int i = 0;
        while (i < mapping.length) {
            if (mapping[i].appliesToFace(front)) {
                double f = param[fractParamIndex[i]];
                if (numParams[i] > 0) {
                    int j = 0;
                    while (j < numParams[i]) {
                        paramTemp[j] = param[paramStartIndex[i] + j];
                        ++j;
                    }
                }
                if (this.layerTriangle[i] == null) {
                    mapping[i].getTextureSpec(this.temp, tempSpec, front, size, time, paramTemp);
                } else {
                    this.layerTriangle[i].getTextureSpec(tempSpec, front, u, v, w, size, time);
                }
                float r = rt * (float)f;
                float g = gt * (float)f;
                float b = bt * (float)f;
                spec.diffuse.add(r * tempSpec.diffuse.red, g * tempSpec.diffuse.green, b * tempSpec.diffuse.blue);
                spec.specular.add(r * tempSpec.specular.red, g * tempSpec.specular.green, b * tempSpec.specular.blue);
                spec.emissive.add(r * tempSpec.emissive.red, g * tempSpec.emissive.green, b * tempSpec.emissive.blue);
                if (blendMode[i] == 0) {
                    spec.transparent.subtract(r * (1.0f - tempSpec.transparent.red), g * (1.0f - tempSpec.transparent.green), b * (1.0f - tempSpec.transparent.blue));
                    f = ft * f;
                } else {
                    spec.transparent.subtract(r *= 1.0f - tempSpec.transparent.red, g *= 1.0f - tempSpec.transparent.green, b *= 1.0f - tempSpec.transparent.blue);
                    f = Math.max(Math.max(r, g), b);
                }
                spec.roughness += ft * tempSpec.roughness;
                spec.cloudiness += ft * tempSpec.cloudiness;
                if (blendMode[i] == 2) {
                    tempSpec.bumpGrad.scale(param[fractParamIndex[i]]);
                } else {
                    tempSpec.bumpGrad.scale(f);
                }
                spec.bumpGrad.add(tempSpec.bumpGrad);
                rt -= r;
                gt -= g;
                bt -= b;
                ft -= f;
                if (rt <= 0.0f && gt <= 0.0f && bt <= 0.0f) {
                    return;
                }
            }
            ++i;
        }
    }

    public void getTransparency(RGBColor trans, boolean front, double u, double v, double w, double size, double time) {
        this.temp.set(this.x1 * u + this.x2 * v + this.x3 * w, this.y1 * u + this.y2 * v + this.y3 * w, this.z1 * u + this.z2 * v + this.z3 * w);
        TextureSpec tempSpec = this.map.tempSpec;
        int[] numParams = this.map.numParams;
        int[] paramStartIndex = this.map.paramStartIndex;
        int[] fractParamIndex = this.map.fractParamIndex;
        int[] blendMode = this.map.blendMode;
        double[] paramTemp = this.map.paramTemp;
        double[] param = this.getParameters(u, v, w);
        TextureMapping[] mapping = this.map.mapping;
        float rt = 1.0f;
        float gt = 1.0f;
        float bt = 1.0f;
        trans.setRGB(1.0f, 1.0f, 1.0f);
        int i = 0;
        while (i < mapping.length) {
            if (mapping[i].appliesToFace(front)) {
                double f = param[fractParamIndex[i]];
                if (numParams[i] > 0) {
                    int j = 0;
                    while (j < numParams[i]) {
                        paramTemp[j] = param[paramStartIndex[i] + j];
                        ++j;
                    }
                }
                if (this.layerTriangle[i] == null) {
                    mapping[i].getTransparency(this.temp, tempSpec.transparent, front, size, time, paramTemp);
                } else {
                    this.layerTriangle[i].getTransparency(tempSpec.transparent, front, u, v, w, size, time);
                }
                float r = rt * (float)f;
                float g = gt * (float)f;
                float b = bt * (float)f;
                if (blendMode[i] == 0) {
                    trans.subtract(r * (1.0f - tempSpec.transparent.red), g * (1.0f - tempSpec.transparent.green), b * (1.0f - tempSpec.transparent.blue));
                } else {
                    trans.subtract(r *= 1.0f - tempSpec.transparent.red, g *= 1.0f - tempSpec.transparent.green, b *= 1.0f - tempSpec.transparent.blue);
                }
                rt -= r;
                gt -= g;
                bt -= b;
                if (rt <= 0.0f && gt <= 0.0f && bt <= 0.0f) {
                    return;
                }
            }
            ++i;
        }
    }

    public double getDisplacement(double u, double v, double w, double size, double time) {
        this.temp.set(this.x1 * u + this.x2 * v + this.x3 * w, this.y1 * u + this.y2 * v + this.y3 * w, this.z1 * u + this.z2 * v + this.z3 * w);
        TextureSpec tempSpec = this.map.tempSpec;
        int[] numParams = this.map.numParams;
        int[] paramStartIndex = this.map.paramStartIndex;
        int[] fractParamIndex = this.map.fractParamIndex;
        int[] blendMode = this.map.blendMode;
        double[] paramTemp = this.map.paramTemp;
        double[] param = this.getParameters(u, v, w);
        TextureMapping[] mapping = this.map.mapping;
        double ft = 1.0;
        double height = 0.0;
        int i = 0;
        while (i < mapping.length) {
            double f = param[fractParamIndex[i]];
            if (numParams[i] > 0) {
                int j = 0;
                while (j < numParams[i]) {
                    paramTemp[j] = param[paramStartIndex[i] + j];
                    ++j;
                }
            }
            double tempHeight = this.layerTriangle[i] == null ? mapping[i].getDisplacement(this.temp, size, time, paramTemp) : this.layerTriangle[i].getDisplacement(u, v, w, size, time);
            f *= ft;
            if (blendMode[i] == 1) {
                mapping[i].getTransparency(this.temp, tempSpec.transparent, true, size, time, paramTemp);
                float min = tempSpec.transparent.red;
                if (min > tempSpec.transparent.green) {
                    min = tempSpec.transparent.green;
                }
                if (min > tempSpec.transparent.blue) {
                    min = tempSpec.transparent.blue;
                }
                f *= ft * (double)(1.0f - min);
            }
            if (blendMode[i] != 2) {
                ft -= f;
            }
            height += tempHeight * f;
            if (ft <= 0.0) {
                return height;
            }
            ++i;
        }
        return height;
    }

    public void setMesh(RenderingMesh mesh) {
        super.setMesh(mesh);
        int i = 0;
        while (i < this.layerTriangle.length) {
            if (this.layerTriangle[i] != null) {
                this.layerTriangle[i].setMesh(mesh);
            }
            ++i;
        }
    }
}

