/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.texture;

import artofillusion.MaterialPreviewer;
import artofillusion.MeshViewer;
import artofillusion.ModellingApp;
import artofillusion.MoveViewTool;
import artofillusion.ReshapeMeshTool;
import artofillusion.RotateMeshTool;
import artofillusion.RotateViewTool;
import artofillusion.ScaleMeshTool;
import artofillusion.Scene;
import artofillusion.SkewMeshTool;
import artofillusion.SplineMeshViewer;
import artofillusion.TaperMeshTool;
import artofillusion.TextureParameter;
import artofillusion.TriMeshViewer;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.animation.Actor;
import artofillusion.math.Vec2;
import artofillusion.object.Mesh;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.LayeredMapping;
import artofillusion.texture.LayeredTexture;
import artofillusion.texture.Texture;
import artofillusion.texture.Texture2D;
import artofillusion.texture.UVMapping;
import artofillusion.texture.UVMappingViewer;
import artofillusion.ui.DividedPanel;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.GenericTool;
import artofillusion.ui.ToolPalette;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class UVMappingWindow
extends Dialog
implements ActionListener,
EditingWindow,
ItemListener,
TextListener {
    Object3D oldObj;
    Mesh editObj;
    UVMapping map;
    Vec2[] coord;
    UVMappingViewer mapView;
    MeshViewer meshView;
    MaterialPreviewer preview;
    ValueField minuField;
    ValueField minvField;
    ValueField maxuField;
    ValueField maxvField;
    ValueField uField;
    ValueField vField;
    Choice componentChoice;
    Choice resChoice;
    boolean[] selectedVertices;

    public UVMappingWindow(Frame parent, ObjectInfo obj, UVMapping map) {
        super(parent, "UV Texture Coordinates", true);
        this.oldObj = obj.object;
        this.editObj = this.oldObj instanceof Actor ? (Mesh)((Object)((Actor)this.oldObj).getObject().duplicate()) : (Mesh)((Object)this.oldObj.duplicate());
        this.map = map;
        ObjectInfo editInfo = obj.duplicate((Object3D)((Object)this.editObj));
        this.coord = map.findTextureCoordinates(this.editObj, obj.object.getTextureMapping().getParameters());
        this.selectedVertices = new boolean[0];
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        double minu = Double.MAX_VALUE;
        double maxu = -1.7976931348623157E308;
        double minv = Double.MAX_VALUE;
        double maxv = -1.7976931348623157E308;
        int i = 0;
        while (i < this.coord.length) {
            if (this.coord[i].x < minu) {
                minu = this.coord[i].x;
            }
            if (this.coord[i].x > maxu) {
                maxu = this.coord[i].x;
            }
            if (this.coord[i].y < minv) {
                minv = this.coord[i].y;
            }
            if (this.coord[i].y > maxv) {
                maxv = this.coord[i].y;
            }
            ++i;
        }
        double padu = 0.1 * (maxu - minu);
        double padv = 0.1 * (maxv - minv);
        minu -= padu;
        maxu += padu;
        minv -= padv;
        maxv += padv;
        Texture tex = obj.object.getTexture();
        if (tex instanceof LayeredTexture) {
            LayeredMapping layered = (LayeredMapping)obj.object.getTextureMapping();
            int i2 = 0;
            while (i2 < layered.getNumLayers()) {
                if (layered.getLayerMapping(i2) == map) {
                    tex = layered.getLayer(i2);
                    break;
                }
                ++i2;
            }
        }
        TextureParameter[] param = map.getParameters();
        double[] paramVal = null;
        if (param != null) {
            paramVal = new double[param.length];
            int i3 = 0;
            while (i3 < param.length) {
                paramVal[i3] = param[i3].defaultVal;
                ++i3;
            }
        }
        Panel mapViewPanel = new Panel();
        mapViewPanel.setLayout(new BorderLayout());
        this.mapView = new UVMappingViewer((Texture2D)tex, this, minu, maxu, minv, maxv, 0, 4, 0.0, paramVal);
        mapViewPanel.add((Component)this.mapView, "Center");
        this.mapView.setPreferredSize(200, 200);
        ToolPalette tools = new ToolPalette(5, 1);
        mapViewPanel.add((Component)tools, "North");
        tools.setBackground(((Component)this).getBackground());
        ReshapeMeshTool defaultTool = new ReshapeMeshTool(this);
        tools.addTool(defaultTool);
        tools.addTool(new ScaleMeshTool(this));
        tools.addTool(new RotateMeshTool(this, true));
        tools.addTool(new SkewMeshTool(this));
        tools.addTool(new TaperMeshTool(this));
        this.mapView.setTool(defaultTool);
        Panel meshViewPanel = new Panel();
        meshViewPanel.setLayout(new BorderLayout());
        this.meshView = this.editObj instanceof TriangleMesh ? new TriMeshViewer(editInfo, new Panel()) : new SplineMeshViewer(editInfo, new Panel());
        this.meshView.setPreferredSize(150, 150);
        this.meshView.setTool(new GenericTool(this, "movePoints.gif", "selected/movePoints.gif"));
        this.meshView.setMetaTool(new MoveViewTool(this));
        this.meshView.setAltTool(new RotateViewTool(this));
        meshViewPanel.add((Component)this.meshView, "Center");
        this.preview = new MaterialPreviewer(editInfo, 150, 150);
        meshViewPanel.add((Component)this.preview, "South");
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        gc.fill = 1;
        DividedPanel div = new DividedPanel(mapViewPanel, meshViewPanel, 1.0f, 1.0f, false);
        this.add((Component)div, gc);
        gc.weighty = 0.0;
        gc.weightx = 0.0;
        gc.gridx = 0;
        gc.fill = 2;
        Panel p = new Panel();
        this.add((Component)p, gc);
        p.setLayout(new FlowLayout(0));
        p.add(new Label("Displayed Component:"));
        this.componentChoice = new Choice();
        p.add(this.componentChoice);
        this.componentChoice.add(Translate.text("Diffuse"));
        this.componentChoice.add(Translate.text("Specular"));
        this.componentChoice.add(Translate.text("Transparent"));
        this.componentChoice.add(Translate.text("Hilight"));
        this.componentChoice.add(Translate.text("Emissive"));
        this.componentChoice.addItemListener(this);
        p.add(new Label("  Resolution:"));
        this.resChoice = new Choice();
        p.add(this.resChoice);
        this.resChoice.add("Low");
        this.resChoice.add("Medium");
        this.resChoice.add("High");
        this.resChoice.addItemListener(this);
        this.add((Component)new Label("Displayed Coordinate Range:"), gc);
        p = new Panel();
        this.add((Component)p, gc);
        p.setLayout(new FlowLayout(0));
        p.add(new Label("U:"));
        this.minuField = new ValueField(minu, 0, 5);
        p.add(this.minuField);
        p.add(new Label(" to "));
        this.maxuField = new ValueField(maxu, 0, 5);
        p.add(this.maxuField);
        p.add(new Label("    V:"));
        this.minvField = new ValueField(minv, 0, 5);
        p.add(this.minvField);
        p.add(new Label(" to "));
        this.maxvField = new ValueField(maxv, 0, 5);
        p.add(this.maxvField);
        this.add((Component)new Label("Selected Vertex Coordinates:"), gc);
        p = new Panel();
        this.add((Component)p, gc);
        p.setLayout(new FlowLayout(0));
        p.add(new Label("U:"));
        this.uField = new ValueField(Double.NaN, 0, 5);
        p.add(this.uField);
        p.add(new Label(" V:"));
        this.vField = new ValueField(Double.NaN, 0, 5);
        p.add(this.vField);
        this.minuField.addTextListener(this);
        this.minvField.addTextListener(this);
        this.maxuField.addTextListener(this);
        this.maxvField.addTextListener(this);
        this.uField.addTextListener(this);
        this.vField.addTextListener(this);
        p = new Panel();
        this.add((Component)p, gc);
        p.add(Translate.button("ok", this));
        p.add(Translate.button("cancel", this));
        this.pack();
        ModellingApp.centerWindow(this);
        this.show();
    }

    private void rebuildImage() {
        int res = 1 << 2 - this.resChoice.getSelectedIndex();
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.mapView.setParameters(this.minuField.getValue(), this.maxuField.getValue(), this.minvField.getValue(), this.maxvField.getValue(), this.componentChoice.getSelectedIndex(), res);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void actionPerformed(ActionEvent ev) {
        if (ev.getActionCommand().equals("ok")) {
            if (this.oldObj instanceof Actor) {
                this.map.setTextureCoordinates((Actor)this.oldObj, this.map.getParameters(), this.coord);
            } else {
                this.map.setTextureCoordinates((Mesh)((Object)this.oldObj), this.map.getParameters(), this.coord);
            }
        }
        this.dispose();
    }

    public void itemStateChanged(ItemEvent ev) {
        this.rebuildImage();
    }

    public void textValueChanged(TextEvent ev) {
        Object source = ev.getSource();
        boolean[] sel = this.mapView.getSelection();
        if (source == this.uField || source == this.vField) {
            int i = 0;
            while (i < sel.length) {
                if (sel[i]) {
                    if (source == this.uField && !Double.isNaN(this.uField.getValue())) {
                        this.coord[i].x = this.uField.getValue();
                    }
                    if (source == this.vField && !Double.isNaN(this.vField.getValue())) {
                        this.coord[i].y = this.vField.getValue();
                    }
                }
                ++i;
            }
            this.setTextureCoords(this.coord);
            this.mapView.updateVertexPositions(this.coord);
            this.mapView.repaint();
        } else {
            this.rebuildImage();
        }
    }

    public void setTextureCoords(Vec2[] coords) {
        this.coord = coords;
        this.map.setTextureCoordinates(this.editObj, ((Object3D)((Object)this.editObj)).getTextureMapping().getParameters(), coords);
        this.map.setTextureCoordinates((Mesh)((Object)this.preview.getObject().object), this.preview.getObject().object.getTextureMapping().getParameters(), coords);
        this.preview.render();
    }

    public void setTool(EditingTool tool) {
        this.mapView.setTool(tool);
    }

    public void setHelpText(String text) {
    }

    public Frame getFrame() {
        return (Frame)this.getParent();
    }

    public void updateImage() {
    }

    public void updateMenus() {
        int[] sel = this.meshView.getSelectionDistance();
        boolean same = this.selectedVertices.length == sel.length;
        int i = 0;
        while (i < sel.length && same) {
            if (this.selectedVertices[i] != (sel[i] == 0)) {
                same = false;
            }
            ++i;
        }
        if (!same) {
            this.selectedVertices = new boolean[sel.length];
            int i2 = 0;
            while (i2 < sel.length) {
                this.selectedVertices[i2] = sel[i2] == 0;
                ++i2;
            }
            this.mapView.setDisplayedVertices(this.coord, this.selectedVertices);
        }
        this.updateTextFields();
    }

    public void updateTextFields() {
        boolean[] sel = this.mapView.getSelection();
        boolean any = false;
        double u = 0.0;
        double v = 0.0;
        int i = 0;
        while (i < sel.length) {
            if (sel[i]) {
                if (!any) {
                    u = this.coord[i].x;
                    v = this.coord[i].y;
                    any = true;
                } else {
                    if (u != this.coord[i].x) {
                        u = Double.NaN;
                    }
                    if (v != this.coord[i].y) {
                        v = Double.NaN;
                    }
                }
            }
            ++i;
        }
        this.uField.setValue(any ? u : Double.NaN);
        this.vField.setValue(any ? v : Double.NaN);
        this.uField.setEnabled(any);
        this.vField.setEnabled(any);
    }

    public void setUndoRecord(UndoRecord command) {
    }

    public Scene getScene() {
        return null;
    }

    public ViewerCanvas getView() {
        return this.mapView;
    }

    public boolean confirmClose() {
        return true;
    }
}

