/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.material.MaterialMapping;
import artofillusion.math.BoundingBox;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.Sphere;
import artofillusion.raytracer.RTObject;
import artofillusion.raytracer.Ray;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;
import artofillusion.texture.UniformMapping;

public class RTEllipsoid
implements RTObject {
    Sphere theSphere;
    Vec3 v;
    Vec3 v2;
    Vec3 dir;
    Vec3 trueNorm;
    Vec3 bumpGrad;
    double rx;
    double ry;
    double rz;
    double rx2;
    double ry2;
    double rz2;
    double cx;
    double cy;
    double cz;
    double sy;
    double sz;
    double t;
    double t2;
    double time;
    double[] param;
    int lastRay;
    int intersections;
    boolean bumpMapped;
    boolean lastRayResult;
    boolean transform;
    boolean uniform;
    boolean normValid;
    Mat4 toLocal;
    Mat4 fromLocal;
    public static final double TOL = 1.0E-12;

    public RTEllipsoid(Sphere sphere, Mat4 fromLocal, Mat4 toLocal, double time, double[] param) {
        Vec3 radii = sphere.getRadii();
        Vec3 vx = toLocal.timesDirection(Vec3.vx());
        Vec3 vy = toLocal.timesDirection(Vec3.vy());
        this.theSphere = sphere;
        this.time = time;
        this.param = param;
        this.v = new Vec3();
        this.v2 = new Vec3();
        this.trueNorm = new Vec3();
        this.uniform = sphere.getTextureMapping() instanceof UniformMapping;
        this.transform = true;
        if (vx.x == 1.0 || vx.x == -1.0) {
            if (vy.y == 1.0 || vy.y == -1.0) {
                this.rx = radii.x;
                this.ry = radii.y;
                this.rz = radii.z;
                this.transform = false;
            } else if (vy.z == 1.0 || vy.z == -1.0) {
                this.rx = radii.x;
                this.ry = radii.z;
                this.rz = radii.y;
                this.transform = false;
            }
        } else if (vx.y == 1.0 || vx.y == -1.0) {
            if (vy.x == 1.0 || vy.x == -1.0) {
                this.rx = radii.y;
                this.ry = radii.x;
                this.rz = radii.z;
                this.transform = false;
            } else if (vy.z == 1.0 || vy.z == -1.0) {
                this.rx = radii.z;
                this.ry = radii.x;
                this.rz = radii.y;
                this.transform = false;
            }
        } else if (vx.z == 1.0 || vx.z == -1.0) {
            if (vy.x == 1.0 || vy.x == -1.0) {
                this.rx = radii.y;
                this.ry = radii.z;
                this.rz = radii.x;
                this.transform = false;
            } else if (vy.y == 1.0 || vy.y == -1.0) {
                this.rx = radii.z;
                this.ry = radii.y;
                this.rz = radii.x;
                this.transform = false;
            }
        }
        if (this.transform) {
            this.rx = radii.x;
            this.ry = radii.y;
            this.rz = radii.z;
            this.fromLocal = fromLocal;
        }
        if (this.transform || !this.uniform) {
            this.dir = new Vec3();
        }
        this.cx = fromLocal.m14 / fromLocal.m44;
        this.cy = fromLocal.m24 / fromLocal.m44;
        this.cz = fromLocal.m34 / fromLocal.m44;
        this.rx2 = this.rx * this.rx;
        this.ry2 = this.ry * this.ry;
        this.rz2 = this.rz * this.rz;
        this.sy = this.rx2 / this.ry2;
        this.sz = this.rx2 / this.rz2;
        this.bumpMapped = sphere.getTexture().bumpMapped();
        this.toLocal = toLocal;
        this.lastRay = -1;
    }

    public final MaterialMapping getMaterialMapping() {
        return this.theSphere.getMaterialMapping();
    }

    public boolean intersects(Ray r) {
        Vec3 orig = r.getOrigin();
        Vec3 rdir = r.getDirection();
        if (this.lastRay == r.getID()) {
            return this.lastRayResult;
        }
        this.lastRay = r.getID();
        this.normValid = false;
        this.v.set(this.cx - orig.x, this.cy - orig.y, this.cz - orig.z);
        if (this.transform) {
            this.toLocal.transformDirection(this.v);
            this.dir.set(rdir);
            this.toLocal.transformDirection(this.dir);
        } else if (this.uniform) {
            this.dir = rdir;
        } else {
            this.dir.set(rdir);
        }
        double temp1 = this.sy * this.dir.y;
        double temp2 = this.sz * this.dir.z;
        double b = this.dir.x * this.v.x + temp1 * this.v.y + temp2 * this.v.z;
        double c = this.v.x * this.v.x + this.sy * this.v.y * this.v.y + this.sz * this.v.z * this.v.z - this.rx2;
        if (c > 1.0E-12) {
            if (b <= 0.0) {
                this.lastRayResult = false;
                return false;
            }
            double a = this.dir.x * this.dir.x + temp1 * this.dir.y + temp2 * this.dir.z;
            double d = b * b - a * c;
            if (d < 0.0) {
                this.lastRayResult = false;
                return false;
            }
            this.intersections = 2;
            temp1 = Math.sqrt(d);
            this.t = (b - temp1) / a;
            this.t2 = (b + temp1) / a;
            this.v2.set(orig.x + this.t2 * this.dir.x, orig.y + this.t2 * this.dir.y, orig.z + this.t2 * this.dir.z);
        } else if (c < -1.0E-12) {
            double a = this.dir.x * this.dir.x + temp1 * this.dir.y + temp2 * this.dir.z;
            double d = b * b - a * c;
            if (d < 0.0) {
                this.lastRayResult = false;
                return false;
            }
            this.intersections = 1;
            this.t = (b + Math.sqrt(d)) / a;
        } else {
            if (b <= 0.0) {
                this.lastRayResult = false;
                return false;
            }
            double a = this.dir.x * this.dir.x + temp1 * this.dir.y + temp2 * this.dir.z;
            double d = b * b - a * c;
            if (d < 0.0) {
                this.lastRayResult = false;
                return false;
            }
            this.intersections = 1;
            this.t = (b + Math.sqrt(d)) / a;
        }
        this.v.set(orig.x + this.t * rdir.x, orig.y + this.t * rdir.y, orig.z + this.t * rdir.z);
        this.lastRayResult = true;
        return true;
    }

    public int numIntersections() {
        return this.intersections;
    }

    public final void intersectionPoint(int n, Vec3 p) {
        if (n == 0) {
            p.set(this.v);
        } else {
            p.set(this.v2);
        }
    }

    public final double intersectionDist(int n) {
        if (n == 0) {
            return this.t;
        }
        return this.t2;
    }

    public void intersectionNormal(Vec3 n) {
        this.calcTrueNorm();
        n.set(this.trueNorm);
        if (this.bumpMapped) {
            n.scale(this.bumpGrad.dot(n) + 1.0);
            n.subtract(this.bumpGrad);
            n.normalize();
        }
    }

    public void trueNormal(Vec3 n) {
        this.calcTrueNorm();
        n.set(this.trueNorm);
    }

    private final void calcTrueNorm() {
        if (this.normValid) {
            return;
        }
        this.normValid = true;
        if (this.transform) {
            this.trueNorm.set(this.v.x - this.cx, this.v.y - this.cy, this.v.z - this.cz);
            this.toLocal.transformDirection(this.trueNorm);
            this.trueNorm.set(this.trueNorm.x, this.trueNorm.y * this.sy, this.trueNorm.z * this.sz);
            this.fromLocal.transformDirection(this.trueNorm);
        } else {
            this.trueNorm.set(this.v.x - this.cx, (this.v.y - this.cy) * this.sy, (this.v.z - this.cz) * this.sz);
        }
        this.trueNorm.normalize();
    }

    public void intersectionTexture(TextureSpec spec, boolean front, double size) {
        TextureMapping map = this.theSphere.getTextureMapping();
        if (map instanceof UniformMapping) {
            map.getTextureSpec(this.v, spec, front, size, this.time, this.param);
        } else {
            this.dir.set(this.v);
            this.toLocal.transform(this.dir);
            map.getTextureSpec(this.dir, spec, front, size, this.time, this.param);
        }
        if (this.bumpMapped) {
            this.bumpGrad = spec.bumpGrad;
            if (this.transform) {
                this.fromLocal.transformDirection(this.bumpGrad);
            }
        }
    }

    public void intersectionTransparency(int n, RGBColor trans, boolean front, double size) {
        TextureMapping map = this.theSphere.getTextureMapping();
        if (map instanceof UniformMapping) {
            map.getTransparency(this.v, trans, front, size, this.time, this.param);
        } else {
            if (n == 0) {
                this.dir.set(this.v);
            } else {
                this.dir.set(this.v2);
            }
            this.toLocal.transform(this.dir);
            map.getTransparency(this.dir, trans, front, size, this.time, this.param);
        }
    }

    public BoundingBox getBounds() {
        if (this.transform) {
            return new BoundingBox(-this.rx, this.rx, -this.ry, this.ry, -this.rz, this.rz).transformAndOutset(this.fromLocal);
        }
        return new BoundingBox(this.cx - this.rx, this.cx + this.rx, this.cy - this.ry, this.cy + this.ry, this.cz - this.rz, this.cz + this.rz);
    }

    public boolean intersectsBox(BoundingBox bb) {
        double centerx;
        double centery;
        double centerz;
        if (this.transform) {
            bb = bb.transformAndOutset(this.toLocal);
            centerz = 0.0;
            centery = 0.0;
            centerx = 0.0;
        } else {
            centerx = this.cx;
            centery = this.cy;
            centerz = this.cz;
        }
        Vec3 c = new Vec3(centerx, centery, centerz);
        if (centerx < bb.minx) {
            c.x = bb.minx;
        } else if (centerx > bb.maxx) {
            c.x = bb.maxx;
        }
        if (centery < bb.miny) {
            c.y = bb.miny;
        } else if (centery > bb.maxy) {
            c.y = bb.maxy;
        }
        if (centerz < bb.minz) {
            c.z = bb.minz;
        } else if (centerz > bb.maxz) {
            c.z = bb.maxz;
        }
        if (!this.transform) {
            c.set(c.x - centerx, c.y - centery, c.z - centerz);
        }
        if (c.x * c.x + c.y * c.y * this.sy + c.z * c.z * this.sz > this.rx2) {
            return false;
        }
        double dx = 1.0 / this.rx;
        double dy = 1.0 / this.ry;
        double dz = 1.0 / this.rz;
        c.set((bb.minx - centerx) * dx, (bb.miny - centery) * dy, (bb.minz - centerz) * dz);
        if (c.length2() > 1.0) {
            return true;
        }
        c.set((bb.minx - centerx) * dx, (bb.miny - centery) * dy, (bb.maxz - centerz) * dz);
        if (c.length2() > 1.0) {
            return true;
        }
        c.set((bb.minx - centerx) * dx, (bb.maxy - centery) * dy, (bb.minz - centerz) * dz);
        if (c.length2() > 1.0) {
            return true;
        }
        c.set((bb.minx - centerx) * dx, (bb.maxy - centery) * dy, (bb.maxz - centerz) * dz);
        if (c.length2() > 1.0) {
            return true;
        }
        c.set((bb.maxx - centerx) * dx, (bb.miny - centery) * dy, (bb.minz - centerz) * dz);
        if (c.length2() > 1.0) {
            return true;
        }
        c.set((bb.maxx - centerx) * dx, (bb.miny - centery) * dy, (bb.maxz - centerz) * dz);
        if (c.length2() > 1.0) {
            return true;
        }
        c.set((bb.maxx - centerx) * dx, (bb.maxy - centery) * dy, (bb.minz - centerz) * dz);
        if (c.length2() > 1.0) {
            return true;
        }
        c.set((bb.maxx - centerx) * dx, (bb.maxy - centery) * dy, (bb.maxz - centerz) * dz);
        return c.length2() > 1.0;
    }

    public Mat4 toLocal() {
        return this.toLocal;
    }
}

