/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	ExtrusionNode.h
*
******************************************************************/

#ifndef _EXTRUSION_H_
#define _EXTRUSION_H_

#include "GeometryNode.h"

class ExtrusionNode : public GeometryNode {

public:

	ExtrusionNode();
	~ExtrusionNode();

	////////////////////////////////////////////////
	//	BeginCap
	////////////////////////////////////////////////
	
	void setBeginCap(bool value);
	void setBeginCap(int value);
	bool getBeginCap();

	////////////////////////////////////////////////
	//	EndCap
	////////////////////////////////////////////////
	
	void setEndCap(bool value);
	void setEndCap(int value);
	bool getEndCap();

	////////////////////////////////////////////////
	//	CCW
	////////////////////////////////////////////////
	
	void setCCW(bool value);
	void setCCW(int value);
	bool getCCW();

	////////////////////////////////////////////////
	//	Convex
	////////////////////////////////////////////////
	
	void setConvex(bool value);
	void setConvex(int value);
	bool getConvex();

	////////////////////////////////////////////////
	//	CreaseAngle
	////////////////////////////////////////////////
	
	void setCreaseAngle(float value);
	float getCreaseAngle();

	////////////////////////////////////////////////
	//	Solid
	////////////////////////////////////////////////
	
	void setSolid(bool value);
	void setSolid(int value);
	bool getSolid();

	////////////////////////////////////////////////
	// orientation
	////////////////////////////////////////////////

	void addOrientation(float value[]);
	void addOrientation(float x, float y, float z, float angle);
	int getNOrientations();
	void getOrientation(int index, float value[]);

	////////////////////////////////////////////////
	// scale
	////////////////////////////////////////////////

	void addScale(float value[]);
	void addScale(float x, float z);
	int getNScales();
	void getScale(int index, float value[]);

	////////////////////////////////////////////////
	// crossSection
	////////////////////////////////////////////////

	void addCrossSection(float value[]);
	void addCrossSection(float x, float z);
	int getNCrossSections();
	void getCrossSection(int index, float value[]);

	////////////////////////////////////////////////
	// spine
	////////////////////////////////////////////////

	void addSpine(float value[]);
	void addSpine(float x, float y, float z);
	int getNSpines();
	void getSpine(int index, float value[]);

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	ExtrusionNode *next();
	ExtrusionNode *nextTraversal();

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	////////////////////////////////////////////////
	//	BoundingBox
	////////////////////////////////////////////////

	void recomputeBoundingBox();

	////////////////////////////////////////////////
	//	recomputeDisplayList
	////////////////////////////////////////////////

	void recomputeDisplayList();

	////////////////////////////////////////////////
	//	Infomation
	////////////////////////////////////////////////

	void outputContext(ostream &printStream, String indentString);
};

#endif

