/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	JString.h
*
******************************************************************/

#ifndef _JSTRING_H_
#define _JSTRING_H_

class  JString 
{
	char	*mValue;

public:

	JString();
	JString(char value[]);
	JString(char value[], int offset, int count); 

	~JString();

	void setValue(char value[]);
	void setValue(char value[], int offset, int count); 
	char *getValue();
	void deleteValue();
	int length();
	char charAt(int  index);
	int compareTo(char *anotherString);
	int compareToIgnoreCase(char *anotherString);
	void concat(char *str);
	void copyValueOf(char data[]);
	void copyValueOf(char  data[], int  offset, int count);
	int regionMatches(int toffset, char *other, int ooffset, int len);
	int regionMatchesIgnoreCase(int toffset, char *other, int ooffset, int len);
	int startsWith(char *prefix);
	int endsWith(char *suffix);
};

#endif
