/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	TextureCoordinateNode.h
*
******************************************************************/

#ifndef _TEXTURECOORDINATE_H_
#define _TEXTURECOORDINATE_H_

#include "vrmlfields.h"
#include "Node.h"

class TextureCoordinateNode : public Node {
	
public:

	TextureCoordinateNode();
	~TextureCoordinateNode();

	////////////////////////////////////////////////
	//	point 
	////////////////////////////////////////////////

	void addPoint(float point[]);
	int getNPoints();
	void getPoint(int index, float point[]);

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	////////////////////////////////////////////////
	//	Output
	////////////////////////////////////////////////

	void outputContext(ostream &printStream, String indentString);

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	TextureCoordinateNode *next();
	TextureCoordinateNode *nextTraversal();

};

#endif

