/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	TransformNode.h
*
******************************************************************/

#ifndef _TRANSFORM_H_
#define _TRANSFORM_H_

#include "vrmlfields.h"
#include "Node.h"
#include "GroupingNode.h"

class TransformNode : public GroupingNode {

public:

	TransformNode();
	~TransformNode();

	////////////////////////////////////////////////
	//	Translation
	////////////////////////////////////////////////

	void setTranslation(float value[]);
	void setTranslation(float x, float y, float z);
	void getTranslation(float value[]);

	////////////////////////////////////////////////
	//	Scale
	////////////////////////////////////////////////

	void setScale(float value[]);
	void setScale(float x, float y, float z);
	void getScale(float value[]);

	////////////////////////////////////////////////
	//	Center
	////////////////////////////////////////////////

	void setCenter(float value[]);
	void setCenter(float x, float y, float z);
	void getCenter(float value[]);

	////////////////////////////////////////////////
	//	Rotation
	////////////////////////////////////////////////

	void setRotation(float value[]);
	void setRotation(float x, float y, float z, float w);
	void getRotation(float value[]);

	////////////////////////////////////////////////
	//	ScaleOrientation
	////////////////////////////////////////////////

	void setScaleOrientation(float value[]);
	void setScaleOrientation(float x, float y, float z, float w);
	void getScaleOrientation(float value[]);

	////////////////////////////////////////////////
	//	Matrix
	////////////////////////////////////////////////

	void getSFMatrix(SFMatrix *mOut);

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	TransformNode *next();
	TransformNode *nextTraversal();

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	////////////////////////////////////////////////
	//	Infomation
	////////////////////////////////////////////////

	void outputContext(ostream &printStream, String indentString);
};

#endif

