/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	ConeNode.h
*
******************************************************************/

#ifndef _CONE_H_
#define _CONE_H_

#include "GeometryNode.h"

class ConeNode : public GeometryNode {

public:

	ConeNode();
	~ConeNode();

	////////////////////////////////////////////////
	//	bottomRadius
	////////////////////////////////////////////////

	void setBottomRadius(float value);
	float getBottomRadius();

	////////////////////////////////////////////////
	//	height
	////////////////////////////////////////////////

	void setHeight(float value);
	float getHeight();

	////////////////////////////////////////////////
	//	side
	////////////////////////////////////////////////

	void setSide(bool value);
	void setSide(int value);
	bool getSide();

	////////////////////////////////////////////////
	//	bottom
	////////////////////////////////////////////////

	void setBottom(bool value);
	void setBottom(int value);
	bool getBottom();

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	ConeNode *next();
	ConeNode *nextTraversal();

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	////////////////////////////////////////////////
	//	BoundingBox
	////////////////////////////////////////////////

	void recomputeBoundingBox();

	////////////////////////////////////////////////
	//	recomputeDisplayList
	////////////////////////////////////////////////

#ifdef SUPPORT_OPENGL
	void recomputeDisplayList();
#endif

	////////////////////////////////////////////////
	//	Infomation
	////////////////////////////////////////////////

	void outputContext(ostream &printStream, String indentString);
};

#endif

