/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	CoordinateInterpolatorNode.h
*
******************************************************************/

#ifndef _COORDINATEINTERPOLATOR_H_
#define _COORDINATEINTERPOLATOR_H_

#include "Node.h"

class CoordinateInterpolatorNode : public Node {

public:

	CoordinateInterpolatorNode();
	~CoordinateInterpolatorNode();

	////////////////////////////////////////////////
	//	key
	////////////////////////////////////////////////
	
	void addKey(float value);
	int getNKeys();
	float getKey(int index);
	Field *getKeyField();

	////////////////////////////////////////////////
	//	keyValue
	////////////////////////////////////////////////
	
	void addKeyValue(float vector[]);
	int getNKeyValues();
	void getKeyValue(int index, float vector[]);
	Field *getKeyValueField();

	////////////////////////////////////////////////
	//	fraction
	////////////////////////////////////////////////
	
	void setFraction(float value);
	float getFraction();
	Field *getFractionField();

	////////////////////////////////////////////////
	//	value
	////////////////////////////////////////////////
	
	void setValue(float vector[]);
	void getValue(float vector[]);
	Field *getValueField();

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	////////////////////////////////////////////////
	//	Output
	////////////////////////////////////////////////

	void outputContext(ostream &printStream, String indentString);

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	CoordinateInterpolatorNode *next();
	CoordinateInterpolatorNode *nextTraversal();
};

#endif

