/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	CylinderSensorNode.h
*
******************************************************************/

#ifndef _CYLINDERSENSOR_H_
#define _CYLINDERSENSOR_H_

#include "vrmlfields.h"
#include "Node.h"

class CylinderSensorNode : public Node {
	
public:

	CylinderSensorNode();
	~CylinderSensorNode();

	////////////////////////////////////////////////
	//	Enabled
	////////////////////////////////////////////////
	
	void setEnabled(bool  value);
	void setEnabled(int value);
	bool  getEnabled();
	bool  isEnabled();

	////////////////////////////////////////////////
	//	AutoOffset
	////////////////////////////////////////////////
	
	void setAutoOffset(bool  value);
	void setAutoOffset(int value);
	bool  getAutoOffset();
	bool  isAutoOffset();

	////////////////////////////////////////////////
	//	DiskAngle
	////////////////////////////////////////////////
	
	void setDiskAngle(float value);
	float getDiskAngle();

	////////////////////////////////////////////////
	//	MinAngle
	////////////////////////////////////////////////
	
	void setMinAngle(float value);
	float getMinAngle();

	////////////////////////////////////////////////
	//	MaxAngle
	////////////////////////////////////////////////
	
	void setMaxAngle(float value);
	float getMaxAngle();

	////////////////////////////////////////////////
	//	Offset
	////////////////////////////////////////////////
	
	void setOffset(float value);
	float getOffset();

	////////////////////////////////////////////////
	//	isActive
	////////////////////////////////////////////////
	
	void setIsActive(bool  value);
	void setIsActive(int value);
	bool  getIsActive();
	bool isActive();

	////////////////////////////////////////////////
	//	Rotation
	////////////////////////////////////////////////
	
	void setRotationChanged(float value[]);
	void setRotationChanged(float x, float y, float z, float rot);
	void getRotationChanged(float value[]);

	////////////////////////////////////////////////
	//	TrackPoint
	////////////////////////////////////////////////
	
	void setTrackPointChanged(float value[]);
	void setTrackPointChanged(float x, float y, float z);
	void getTrackPointChanged(float value[]);

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	CylinderSensorNode *next();
	CylinderSensorNode *nextTraversal();

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	////////////////////////////////////////////////
	//	Infomation
	////////////////////////////////////////////////

	void outputContext(ostream &printStream, String indentString);
};

#endif

