/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	Event.h
*
******************************************************************/

#ifndef _EVENT_H_
#define _EVENT_H_

#include <time.h>
#include "JString.h"
#include "Field.h"
#include "SFTime.h"
#include "CJavaVM.h"

#ifdef SUPPORT_JSAI
class Event : public CJavaVM {
#else
class Event {
#endif

#ifdef SUPPORT_JSAI
	jclass		mEventClass;
#endif

	JString		mName;
	double		mTime;
	Field		*mField;

public:

	Event(Field *field);
	Event(char *name, double time, Field *field);

	void InitializeJavaIDs();

	////////////////////////////////////////////////
	//	Name
	////////////////////////////////////////////////

	void setName(char *name);
	char *getName();

	////////////////////////////////////////////////
	//	Time
	////////////////////////////////////////////////
	
	void setTimeStamp(double time);
	double getTimeStamp();

	////////////////////////////////////////////////
	//	ConstField
	////////////////////////////////////////////////

	void setField(Field *field);
	Field *getField();

	////////////////////////////////////////////////
	//	for Java
	////////////////////////////////////////////////

#ifdef SUPPORT_JSAI

	void setEventClass(jclass eventClass);
	jclass getEventClass();
	jobject toJavaObject();

#endif

};

#endif
