/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	FontStyleNode.h
*
******************************************************************/

#ifndef _FONTSTYLE_H_
#define _FONTSTYLE_H_

#include "vrmlfields.h"
#include "Node.h"

enum {
FONTSTYLE_FAMILY_SERIF,
FONTSTYLE_FAMILY_SANS,
FONTSTYLE_FAMILY_TYPEWRITER,
};

enum {
FONTSTYLE_STYLE_PLAIN,
FONTSTYLE_STYLE_BOLD,
FONTSTYLE_STYLE_ITALIC,
FONTSTYLE_STYLE_BOLDITALIC,
};

enum {
FONTSTYLE_JUSTIFY_BEGIN,
FONTSTYLE_JUSTIFY_MIDDLE,
FONTSTYLE_JUSTIFY_END,
FONTSTYLE_JUSTIFY_FIRST,
};

class FontStyleNode : public Node {
	
public:

	FontStyleNode();
	~FontStyleNode();

	////////////////////////////////////////////////
	//	Size
	////////////////////////////////////////////////

	void setSize(float value);
	float getSize();

	////////////////////////////////////////////////
	//	Family
	////////////////////////////////////////////////
	
	void setFamily(String value);
	String getFamily();
	int getFamilyNumber();

	////////////////////////////////////////////////
	//	Style
	////////////////////////////////////////////////
	
	void setStyle(String value);
	String getStyle();
	int getStyleNumber();

	////////////////////////////////////////////////
	//	Language
	////////////////////////////////////////////////
	
	void setLanguage(String value);
	String getLanguage();

	////////////////////////////////////////////////
	//	Horizontal
	////////////////////////////////////////////////
	
	void setHorizontal(bool value);
	void setHorizontal(int value);
	bool getHorizontal();

	////////////////////////////////////////////////
	//	LeftToRight
	////////////////////////////////////////////////
	
	void setLeftToRight(bool value);
	void setLeftToRight(int value);
	bool getLeftToRight();

	////////////////////////////////////////////////
	//	TopToBottom
	////////////////////////////////////////////////
	
	void setTopToBottom(bool value);
	void setTopToBottom(int value);
	bool getTopToBottom();

	////////////////////////////////////////////////
	// Justify
	////////////////////////////////////////////////

	void addJustify(String value);
	int getNJustifys();
	String getJustify(int index);

	////////////////////////////////////////////////
	//	Spacing
	////////////////////////////////////////////////

	void setSpacing(float value);
	float getSpacing();

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	FontStyleNode *next();
	FontStyleNode *nextTraversal();

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	////////////////////////////////////////////////
	//	Justifymation
	////////////////////////////////////////////////

	void outputContext(ostream &printStream, String indentString);
};

#endif

