/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	OrientationInterpolatorNode.h
*
******************************************************************/

#ifndef _ORIENTATIONINTERPOLATOR_H_
#define _ORIENTATIONINTERPOLATOR_H_

#include "vrmlfields.h"
#include "Node.h"

class OrientationInterpolatorNode : public Node {

public:

	OrientationInterpolatorNode();
	~OrientationInterpolatorNode();

	////////////////////////////////////////////////
	//	key
	////////////////////////////////////////////////
	
	void addKey(float value);
	int getNKeys();
	float getKey(int index);
	Field *getKeyField();

	////////////////////////////////////////////////
	//	keyValue
	////////////////////////////////////////////////
	
	void addKeyValue(float rotation[]);
	int getNKeyValues();
	void getKeyValue(int index, float rotation[]);
	Field *getKeyValueField();

	////////////////////////////////////////////////
	//	fraction
	////////////////////////////////////////////////
	
	void setFraction(float value);
	float getFraction();
	Field *getFractionField();

	////////////////////////////////////////////////
	//	value
	////////////////////////////////////////////////
	
	void setValue(float rotation[]);
	void getValue(float rotation[]);
	Field *getValueField();

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	////////////////////////////////////////////////
	//	Output
	////////////////////////////////////////////////

	void outputContext(ostream& printStream, String indentString);

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	OrientationInterpolatorNode *next();
	OrientationInterpolatorNode *nextTraversal();
};

#endif

