/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	PositionInterpolatorNode.h
*
******************************************************************/

#ifndef _POSITIONINTERPOLATOR_H_
#define _POSITIONINTERPOLATOR_H_

#include "vrmlfields.h"
#include "Node.h"

class PositionInterpolatorNode : public Node {

public:

	PositionInterpolatorNode();
	~PositionInterpolatorNode();

	////////////////////////////////////////////////
	//	key
	////////////////////////////////////////////////
	
	void addKey(float value);
	int getNKeys();
	float getKey(int index);
	Field *getKeyField();

	////////////////////////////////////////////////
	//	keyValue
	////////////////////////////////////////////////
	
	void addKeyValue(float vector[]);
	int getNKeyValues();
	void getKeyValue(int index, float vector[]);
	Field *getKeyValueField();

	////////////////////////////////////////////////
	//	fraction
	////////////////////////////////////////////////
	
	void setFraction(float value);
	float getFraction();
	Field *getFractionField();

	////////////////////////////////////////////////
	//	value
	////////////////////////////////////////////////
	
	void setValue(float vector[]);
	void getValue(float vector[]);
	Field *getValueField();

	////////////////////////////////////////////////
	//	Virtual functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	void outputContext(ostream &printStream, String indentString);

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	PositionInterpolatorNode *next();
	PositionInterpolatorNode *nextTraversal();

};

#endif

