/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	PROTO.h
*
******************************************************************/

#ifndef _PROTO_H_
#define _PROTO_H_

#include "CLinkedList.h"
#include "JString.h"
#include "Field.h"
#include "JVector.h"

class PROTO : public CLinkedListNode<PROTO> {
	JString				mName;
	JString				mString;
	JVector<Field>		mDefaultFieldVector;
	JVector<Field>		mFieldVector;
public:

	PROTO(char *name, char *string, char *fieldString);
	~PROTO(void);

	void		setName(char *name);
	char		*getName(void);

	void		setString(char *string);
	char		*getString();
	void		getString(char *returnString);

	void		addDefaultField(Field *field);
	void		addField(Field *field);

	int			getNDefaultFields();
	int			getNFields();

	Field		*getDefaultField(int n);
	Field		*getField(int n);

	void		addFieldValues(char *fieldString, int bDefaultField);
	void		addDefaultFields(char *fieldString);
	void		addFields(char *fieldString);
	void		deleteDefaultFields(void);
	void		deleteFields(void);

	Field		*getField(char *name);
	int			getFieldType(char *name);
};


#endif


