/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	UrlFile.h
*
******************************************************************/

#ifndef _URLFILE_H_
#define _URLFILE_H_

#include "CJavaVM.h"
#include "JString.h"

#ifdef SUPPORT_URL

class UrlFile : public CJavaVM {

	static jclass		mUrlGetStreamClassID;
	static jmethodID	mUrlGetStreamInitMethodID;
	static jmethodID	mUrlGetStreamGetStreamMethodID;
	static jobject		mUrlGetStreamObject;		

	JString				*mUrl;	
	JString				*mUrlString;

public:

	UrlFile();
	~UrlFile();
	void	initialize();
	void	setUrl(char *urlString);
	char	*getUrl();
	bool	getStream(char *urlString);
	char	*getOutputFilename();
	bool	deleteOutputFilename();
};

#endif

#endif
