/* DiaCanvas -- A technical drawing canvas.
 * Copyright (C) 1999, Arjan Molenaar
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __DIA_TOOL_H__
#define __DIA_TOOL_H__

//#include <gdk/gdk.h>
#include <diacanvas/diaobject.h>
#include <diacanvas/diadisplay.h>
//#include <diacanvas/diadefs.h>

DIA_OPEN

typedef struct _DiaTool DiaTool;

/* Returns TRUE if event is handled and no further handling is required. */
typedef gint (* DiaToolEventFunc)   (DiaTool *tool, DiaEvent *event, 
				     DiaDisplay *display);

typedef void (* DiaToolDestroyFunc) (DiaTool* tool);

struct _DiaTool
{
  /* The four old event handlers are replaced by one (1)
   * general event-handler
   */
  DiaToolEventFunc   event;
  
  /* This function is used to free the tool 
   * (this is done as soon as a new tool is set active)
   */
  DiaToolDestroyFunc destroy;
};

void     dia_tool_set_active (DiaTool *tool);
DiaTool* dia_tool_get_active ();

DIA_CLOSE

#endif /* __DIA_TOOL_H__ */


