#!/bin/bash
#
# update_figs.sh -- converts ePiX-0.6.4 and earlier files to 0.6.5
#   by stripping out the "const " declaration of *pic_unit and (most)
#   dereferences ("*") in plot commands.
#
# August 19, 2001, Andrew D. Hwang   ahwang@mathcs.holycross.edu
#
# July 5, 2002: v0.8.5 -- strips "()" from bold and color declarations
#   Potentially modified files are archived or saved with ".old" extension
# July 12: v0.8.5a -- Re-written to fix bug with Solaris' "sed"
#

# Conversion function
epix_update() {
    mv $file $file.old
    sed 's/^const //g' $file.old | \
    sed 's/x_size()/x_size/g' | \
    sed 's/y_size()/y_size/g' | \
    sed 's/bold()/bold/g' | \
    sed 's/red()/red/g' | \
    sed 's/green()/green/g' | \
    sed 's/blue()/blue/g' | \
    sed 's/cyan()/cyan/g' | \
    sed 's/magenta()/magenta/g' | \
    sed 's/yellow()/yellow/g' > $file
    echo -n "."
}

echo "This operation is potentially destructive."
echo -n "Create backup? [yes/no/quit] "
read ANSWER

while [ "$ANSWER" != "yes" -a "$ANSWER" != "no" -a "$ANSWER" != "quit" ]
do
    echo -n "Please answer yes, no, or quit: "
    read ANSWER
done

echo

case "$ANSWER" in

    quit)
    echo "Operation cancelled"
    exit 0
    ;;

    no)
    echo "No backup created -- original files have \".old\" suffix"
    ;;

    yes)
    tar -cf - *.c *.cc *.C 2> /dev/null | gzip -9 > update_figs.tar.gz
    echo "All \".c\", \".cc\", and \".C\" files saved to update_figs.tar.gz"
    ;;

    *)
    echo "Internal error -- perhaps I've been tampered...?"
    exit 1
    ;;
esac

echo -n "Processing "
for file in $(ls *.c *.cc *.C 2> /dev/null)
do
    epix_update $file

    if [ "$ANSWER" = "yes" ]; then
    rm -f $file.old
    fi
done 

echo " done"

exit 0

