/* gtkDPSwidget.h
 * Copyright (C) 1997, 1998 GYVE Development Team
 *
 * Author:  Terumoto 'tel' HAYAKAWA <hayakawa@cv.cs.ritsumei.ac.jp>
 * Created: 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GTK__DPS_WIDGET_H
#define GTK__DPS_WIDGET_H 


#include <gdk/gdk.h>
#include <gtk/gtkwidget.h>

#include <gtkDPS/gtkDPScontext.h>

/*#include <DPS/dpsXclient.h>*/

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define GTK_TYPE_DPS_WIDGET (gtk_dps_widget_get_type())
#define GTK_DPS_WIDGET(obj) (GTK_CHECK_CAST ((obj), GTK_TYPE_DPS_WIDGET, GtkDPSWidget))
#define GTK_DPS_WIDGET_CLASS(klass)  (GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_DPS_WIDGET, GtkDPSWidgetClass))
#define GTK_IS_DPS_WIDGET(obj) (GTK_CHECK_TYPE ((obj), GTK_TYPE_DPS_WIDGET))
#define GTK_IS_DPS_WIDGET_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_DPS_WIDGET))

typedef struct _GtkDPSWidget       GtkDPSWidget;
typedef struct _GtkDPSWidgetClass  GtkDPSWidgetClass;

struct _GtkDPSWidget
{
  GtkWidget     widget;
  GtkDPSContext *gtk_dps_context;
};

struct _GtkDPSWidgetClass
{
  GtkWidgetClass parent_class;
};


guint          gtk_dps_widget_get_type       (void);

#define  gtk_dps_widget_begin(widget)						\
{										\
  GtkDPSWidget * gtk_dps_widget = GTK_DPS_WIDGET(widget);			\
  gtk_dps_context_begin(gtk_dps_widget->gtk_dps_context);
#define gtk_dps_widget_end()		\
  gtk_dps_context_end(gtk_dps_widget->gtk_dps_context);		\
}

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* GTK__DPS_WIDGET_H */
